/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.component.state;

import org.mule.munit.runner.processors.MunitModule;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.runtime.api.deployment.management.ComponentInitialStateManager;
import org.mule.runtime.api.meta.AnnotatedObject;

import javax.inject.Inject;

/**
 * The goal of this class is to shutdown flow sources.
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class MunitComponentInitialStateManager implements ComponentInitialStateManager {

  @Inject
  protected MunitModule munitModule;

  @Override
  public boolean mustStartMessageSource(AnnotatedObject component) {
    if (munitModule.getExcludeFlowSources().getFlows().isEmpty()) {
      return !munitModule.isDisableFlowSources();
    } else {
      return shouldStartMessageSource(component);
    }
  }

  private boolean shouldStartMessageSource(AnnotatedObject component) {
    ComponentLocation location = component.getLocation();
    LocationPart locationPart = location.getParts().get(0);
    String partPath = locationPart.getPartPath();

    Boolean shouldStart = !munitModule.isDisableFlowSources();
    if (munitModule.getExcludeFlowSources().getFlows().contains(partPath)) {
      return !shouldStart;
    } else {
      return shouldStart;
    }

  }

}
