/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.simple;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.File;
import java.util.Date;
import java.util.List;

/**
 * The Goal of this class is to start a Mule context with a simple MUnit configuration. This configuration will not mock any
 * endpoint nor will it add any other feature.
 * <p/>
 * Each of the MunitSimpleRunnerAction provided will be run after the context is started in the order provided by the list.
 */

// TODO let's check coverage and then thing about killing this
public class MunitSimpleRunner {

  private transient Log log = LogFactory.getLog(this.getClass());

  private File appDir;
  private String resources;
  private List<MunitSimpleRunnerAction> actions;

  public MunitSimpleRunner(String resources, List<MunitSimpleRunnerAction> actions, File appDir) {
    this.appDir = appDir;
    this.actions = actions;
    this.resources = resources;
  }

  // public void setMuleContextManager(MuleContextManager muleContextManager) {
  // this.muleContextManager = muleContextManager;
  // }


  /**
   * Starts a Mule Context and run each of the actions provided.
   */
  public void run() {
    log.debug("Counting application flow paths: " + new Date().toString());
    initMuleContextManager();
    try {
      // muleContextManager.createAndStartMule(resources, appDir, null);

      for (MunitSimpleRunnerAction action : actions) {
        action.execute(null);
      }
    } catch (Exception e) {
      throw new RuntimeException(e);
    } finally {
      // muleContextManager.killMule();
      log.debug("Application flow paths count done: " + new Date().toString());
    }
  }


  public String getResources() {
    return resources;
  }

  private void initMuleContextManager() {
    // if (null == muleContextManager) {
    // MockingConfiguration mockingConfiguration = new MockingConfiguration(false, new ArrayList<>(), false, null);
    // muleContextManager = new MuleContextManager(mockingConfiguration, classLoaderHolder);
    // }
  }
}
