/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner;

import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.munit.common.model.Attachment;
import org.mule.munit.common.model.EventAttributes;
import org.mule.munit.common.model.Payload;
import org.mule.munit.common.model.Property;
import org.mule.munit.common.model.UntypedEventError;
import org.mule.munit.common.model.Variable;
import org.mule.munit.runner.processors.ExcludeFlowSources;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ConstructDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OptionalParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclarer;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionLoadingDelegate;

public class MunitExtensionLoadingDelegate
implements ExtensionLoadingDelegate {
    private static final String VERSION = "2.0.0-rc";
    private static final String DESCRIPTION = "MUnit: Core components";
    private static final String NAME = "MUnit";
    private static final String VENDOR = "MuleSoft, Inc.";
    private static final MuleVersion MIN_MULE_VERSION = new MuleVersion("4.0.0");
    private static final String PREFIX = "munit";
    private static final String NAMESPACE = "http://www.mulesoft.org/schema/mule/munit";
    private static final String SCHEMA_LOCATION = "http://www.mulesoft.org/schema/mule/munit/current/mule-munit.xsd";
    private static final String SCHEMA_VERSION = "2.0.0-rc";
    private static final String XSD_FILE_NAME = "mule-munit.xsd";
    private static final String CONFIG_NAME = "config";
    private static final String CONFIG_DESCRIPTION = "MUnit configuration";
    private static final String EXCLUDE_FLOW_SOURCES_NAME = "exclude-flow-sources";
    private static final String EXCLUDE_FLOW_SOURCES_DESCRIPTION = "Flow sources to exclude";
    private static final int EXCLUDE_FLOW_SOURCES_ORDER = 2;
    private static final String TEST_NAME = "test";
    private static final String TEST_DESCRIPTION = "The MUnit test flow";
    private static final String BEFORE_TEST_NAME = "before-test";
    private static final String BEFORE_TEST_DESCRIPTION = "Flow to be run before each MUnit test, one time per each test";
    private static final String AFTER_TEST_NAME = "after-test";
    private static final String AFTER_TEST_DESCRIPTION = "Flow to be run after each MUnit test, one time per each test";
    private static final String BEFORE_SUITE_NAME = "before-suite";
    private static final String BEFORE_SUITE_DESCRIPTION = "Flow to be run before any other in a MUnit suite, just one time";
    private static final String AFTER_SUITE_NAME = "after-suite";
    private static final String AFTER_SUITE_DESCRIPTION = "Flow to be run after any other in a MUnit suite, just one time";
    private static final String DESCRIPTION_NAME = "description";
    private static final String DESCRIPTION_DESCRIPTION = "Description message to be shown in case of test failure.";
    private static final String IGNORE_NAME = "ignore";
    private static final String IGNORE_DESCRIPTION = "Defines if the test must be ignored.";
    private static final String TAGS_NAME = "tags";
    private static final String TAGS_DESCRIPTION = "Defines the tags for the test.";
    private static final String EXPECTED_ERROR_TYPE_NAME = "expectedErrorType";
    private static final String EXPECTED_ERROR_TYPE_DESCRIPTION = "Error ID expected on this test.";
    private static final String EXPECTED_EXCEPTION_NAME = "expectedException";
    private static final String EXPECTED_EXCEPTION_DESCRIPTION = "Error expected on this test.";
    private static final String BEHAVIOR_NAME = "behavior";
    private static final String BEHAVIOR_DESCRIPTION = "Processors that define test behavior";
    private static final String EXECUTION_NAME = "execution";
    private static final String EXECUTION_DESCRIPTION = "Processors that define execution of the test";
    private static final String VALIDATION_NAME = "validation";
    private static final String VALIDATION_DESCRIPTION = "Processors that define validation of the test";
    private static final String SET_EVENT_NAME = "set-event";
    private static final String SET_EVENT_DESCRIPTION = "Defines the event to be used for testing";
    private static final String CLONE_ORIGINAL_EVENT_NAME = "cloneOriginalEvent";
    private static final String CLONE_ORIGINAL_EVENT_DESCRIPTION = "Define if the original Event should be cloned";
    private static final String PAYLOAD_NAME = "payload";
    private static final String PAYLOAD_DESCRIPTION = "The payload to be set.";
    private static final String ATTRIBUTES_NAME = "attributes";
    private static final String ATTRIBUTES_DESCRIPTION = "Attributes to be set.";
    private static final String ERROR_NAME = "error";
    private static final String ERROR_DESCRIPTION = "Error to be set.";
    private static final String VARIABLE_NAME = "variables";
    private static final String VARIABLE_DESCRIPTION = "Variables to be set.";
    private static final String INBOUND_PROPERTIES_NAME = "inbound-properties";
    private static final String INBOUND_PROPERTIES_DESCRIPTION = "Inbound properties to be set.";
    private static final String OUTBOUND_PROPERTIES_NAME = "outbound-properties";
    private static final String OUTBOUND_PROPERTIES_DESCRIPTION = "Outbound properties to be set.";
    private static final String INBOUND_ATTACHMENTS_NAME = "inbound-attachments";
    private static final String INBOUND_ATTACHMENTS_DESCRIPTION = "Inbound attachments to be set.";
    private static final String OUTBOUND_ATTACHMENTS_NAME = "outbound-attachments";
    private static final String OUTBOUND_ATTACHMENTS_DESCRIPTION = "Outbound attachments to be set.";
    private static final String SET_NULL_PAYLOAD_NAME = "set-null-payload";
    private static final String SET_NULL_PAYLOAD_DESCRIPTION = "Defines a Null payload for testing";
    private ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    private BaseTypeBuilder typeBuilder = BaseTypeBuilder.create((MetadataFormat)JavaTypeLoader.JAVA);

    public void accept(ExtensionDeclarer extensionDeclarer, ExtensionLoadingContext extensionLoadingContext) {
        this.declareGeneral(extensionDeclarer);
        this.declareXmlDsl(extensionDeclarer);
        this.declareConfiguration(extensionDeclarer);
        this.declareOperations(extensionDeclarer);
    }

    private void declareGeneral(ExtensionDeclarer extensionDeclarer) {
        extensionDeclarer.named(NAME).describedAs(DESCRIPTION).onVersion("2.0.0-rc").fromVendor(VENDOR).withCategory(Category.COMMUNITY).withMinMuleVersion(MIN_MULE_VERSION);
    }

    private void declareXmlDsl(ExtensionDeclarer extensionDeclarer) {
        XmlDslModel xmlDslModel = XmlDslModel.builder().setPrefix(PREFIX).setNamespace(NAMESPACE).setSchemaLocation(SCHEMA_LOCATION).setSchemaVersion("2.0.0-rc").setXsdFileName(XSD_FILE_NAME).build();
        extensionDeclarer.withXmlDsl(xmlDslModel);
    }

    private void declareConfiguration(ExtensionDeclarer extensionDeclarer) {
        ConfigurationDeclarer configurationDeclarer = extensionDeclarer.withConfig(CONFIG_NAME).describedAs(CONFIG_DESCRIPTION);
        ParameterGroupDeclarer parameterGroupDeclarer = configurationDeclarer.onDefaultParameterGroup();
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameterGroupDeclarer.withOptionalParameter(EXCLUDE_FLOW_SOURCES_NAME).describedAs(EXCLUDE_FLOW_SOURCES_DESCRIPTION)).ofType(this.typeLoader.load(ExcludeFlowSources.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).withLayout(LayoutModel.builder().order(2).build());
    }

    private void declareOperations(ExtensionDeclarer extensionDeclarer) {
        this.declareMunitTestFlow(extensionDeclarer);
        this.declareMunitFlow(extensionDeclarer, BEFORE_TEST_NAME, BEFORE_TEST_DESCRIPTION);
        this.declareMunitFlow(extensionDeclarer, AFTER_TEST_NAME, AFTER_TEST_DESCRIPTION);
        this.declareMunitFlow(extensionDeclarer, BEFORE_SUITE_NAME, BEFORE_SUITE_DESCRIPTION);
        this.declareMunitFlow(extensionDeclarer, AFTER_SUITE_NAME, AFTER_SUITE_DESCRIPTION);
        this.declareSetEvent(extensionDeclarer);
        this.declareSetNullPayload(extensionDeclarer);
    }

    private void declareMunitTestFlow(ExtensionDeclarer extensionDeclarer) {
        ConstructDeclarer testDeclarer = this.declareMunitFlow(extensionDeclarer, TEST_NAME, TEST_DESCRIPTION);
        ParameterGroupDeclarer parameterGroupDeclarer = testDeclarer.onDefaultParameterGroup();
        this.addOptionalParameter(IGNORE_NAME, IGNORE_DESCRIPTION, Boolean.class, parameterGroupDeclarer);
        this.addOptionalParameter(TAGS_NAME, TAGS_DESCRIPTION, String.class, parameterGroupDeclarer);
        this.addOptionalParameter(EXPECTED_ERROR_TYPE_NAME, EXPECTED_ERROR_TYPE_DESCRIPTION, String.class, parameterGroupDeclarer);
        this.addOptionalParameter(EXPECTED_EXCEPTION_NAME, EXPECTED_EXCEPTION_DESCRIPTION, String.class, parameterGroupDeclarer);
        this.declareMunitTestSection(BEHAVIOR_NAME, BEHAVIOR_DESCRIPTION, extensionDeclarer, testDeclarer);
        this.declareMunitTestSection(EXECUTION_NAME, EXECUTION_DESCRIPTION, extensionDeclarer, testDeclarer);
        this.declareMunitTestSection(VALIDATION_NAME, VALIDATION_DESCRIPTION, extensionDeclarer, testDeclarer);
    }

    private void declareMunitTestSection(String name, String description, ExtensionDeclarer extensionDeclarer, ConstructDeclarer testDeclarer) {
        StereotypeModel stereoType = StereotypeModelBuilder.newStereotype((String)name, (String)PREFIX).build();
        ((ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct(name).describedAs(description)).withStereotype(stereoType)).withChain();
        testDeclarer.withOptionalComponent(name).withAllowedStereotypes(new StereotypeModel[]{stereoType});
    }

    private ConstructDeclarer declareMunitFlow(ExtensionDeclarer extensionDeclarer, String name, String description) {
        ConstructDeclarer constructDeclarer = ((ConstructDeclarer)extensionDeclarer.withConstruct(name).describedAs(description)).allowingTopLevelDefinition();
        this.addOptionalParameter(DESCRIPTION_NAME, DESCRIPTION_DESCRIPTION, String.class, constructDeclarer.onDefaultParameterGroup());
        return constructDeclarer;
    }

    private void declareSetEvent(ExtensionDeclarer extensionDeclarer) {
        OperationDeclarer operationDeclarer = (OperationDeclarer)extensionDeclarer.withOperation(SET_EVENT_NAME).describedAs(SET_EVENT_DESCRIPTION);
        operationDeclarer.withOutputAttributes().ofType(this.typeLoader.load(Object.class));
        operationDeclarer.withOutput().ofType((MetadataType)this.typeBuilder.anyType().build());
        ParameterGroupDeclarer declarer = operationDeclarer.onDefaultParameterGroup();
        this.addOptionalParameter(CLONE_ORIGINAL_EVENT_NAME, CLONE_ORIGINAL_EVENT_DESCRIPTION, Boolean.class, declarer);
        this.addOptionalParameter(PAYLOAD_NAME, PAYLOAD_DESCRIPTION, Payload.class, declarer);
        this.addOptionalParameter(ATTRIBUTES_NAME, ATTRIBUTES_DESCRIPTION, EventAttributes.class, declarer);
        this.addOptionalParameter(ERROR_NAME, ERROR_DESCRIPTION, UntypedEventError.class, declarer);
        this.addOptionalListParameter(VARIABLE_NAME, VARIABLE_DESCRIPTION, Variable.class, declarer);
        this.addOptionalListParameter(INBOUND_PROPERTIES_NAME, INBOUND_PROPERTIES_DESCRIPTION, Property.class, declarer);
        this.addOptionalListParameter(OUTBOUND_PROPERTIES_NAME, OUTBOUND_PROPERTIES_DESCRIPTION, Property.class, declarer);
        this.addOptionalListParameter(INBOUND_ATTACHMENTS_NAME, INBOUND_ATTACHMENTS_DESCRIPTION, Attachment.class, declarer);
        this.addOptionalListParameter(OUTBOUND_ATTACHMENTS_NAME, OUTBOUND_ATTACHMENTS_DESCRIPTION, Attachment.class, declarer);
    }

    private void declareSetNullPayload(ExtensionDeclarer extensionDeclarer) {
        OperationDeclarer operationDeclarer = (OperationDeclarer)extensionDeclarer.withOperation(SET_NULL_PAYLOAD_NAME).describedAs(SET_NULL_PAYLOAD_DESCRIPTION);
        operationDeclarer.withOutputAttributes().ofType(this.typeLoader.load(Object.class));
        operationDeclarer.withOutput().ofType((MetadataType)this.typeBuilder.anyType().build());
    }

    private void addOptionalParameter(String name, String description, Class<?> clazz, ParameterGroupDeclarer declarer) {
        this.addOptionalParameter(name, description, this.typeLoader.load(clazz), declarer);
    }

    private void addOptionalListParameter(String name, String description, Class<?> clazz, ParameterGroupDeclarer declarer) {
        this.addOptionalParameter(name, description, (MetadataType)this.typeBuilder.arrayType().of(this.typeLoader.load(clazz)).build(), declarer);
    }

    private void addOptionalParameter(String name, String description, MetadataType type, ParameterGroupDeclarer declarer) {
        ((OptionalParameterDeclarer)declarer.withOptionalParameter(name).describedAs(description)).ofType(type);
    }
}

