/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.component.state;

import java.util.Optional;
import javax.inject.Inject;
import org.mule.munit.runner.processors.MunitModule;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.runtime.api.deployment.management.ComponentInitialStateManager;
import org.mule.runtime.api.meta.AnnotatedObject;

public class MunitComponentInitialStateManager
implements ComponentInitialStateManager {
    private static final Boolean DEFAULT_MESSAGESOURCE_STATE = false;
    @Inject
    protected Optional<MunitModule> munitModule;

    public boolean mustStartMessageSource(AnnotatedObject component) {
        if (!this.munitModule.isPresent()) {
            return DEFAULT_MESSAGESOURCE_STATE;
        }
        if (this.munitModule.get().getExcludeFlowSources().getFlows().isEmpty()) {
            return !this.munitModule.get().isDisableFlowSources();
        }
        return this.shouldStartMessageSource(component);
    }

    private boolean shouldStartMessageSource(AnnotatedObject component) {
        ComponentLocation location = component.getLocation();
        LocationPart locationPart = (LocationPart)location.getParts().get(0);
        String partPath = locationPart.getPartPath();
        Boolean shouldStart = !this.munitModule.get().isDisableFlowSources();
        if (this.munitModule.get().getExcludeFlowSources().getFlows().contains(partPath)) {
            return shouldStart == false;
        }
        return shouldStart;
    }
}

