/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.config.factory;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.processor.MessageProcessorBuilder;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.MessageProcessorChainBuilder;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;

public class MessageProcessorChainFactory {
    private final MuleContext muleContext;
    private final Map<QName, Object> annotations;

    public MessageProcessorChainFactory(MuleContext muleContext, Map<QName, Object> annotations) {
        this.muleContext = muleContext;
        this.annotations = annotations;
    }

    public MessageProcessorChain create(String processorChainName, List<Processor> messageProcessors) throws MuleException {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.setName("'" + processorChainName + "' processor chain");
        this.configureMessageProcessors(messageProcessors, (MessageProcessorChainBuilder)builder);
        MessageProcessorChain processorChain = builder.build();
        processorChain.setMuleContext(this.muleContext);
        processorChain.setAnnotations(this.annotations);
        return processorChain;
    }

    protected void configureMessageProcessors(List<Processor> messageProcessors, MessageProcessorChainBuilder builder) throws MuleException {
        if (null != messageProcessors) {
            for (Processor processor : messageProcessors) {
                if (processor instanceof Processor) {
                    builder.chain(new Processor[]{processor});
                    continue;
                }
                if (processor instanceof MessageProcessorBuilder) {
                    builder.chain(new MessageProcessorBuilder[]{(MessageProcessorBuilder)processor});
                    continue;
                }
                throw new IllegalArgumentException("MessageProcessorBuilder should only have MessageProcessor's or MessageProcessorBuilder's configured");
            }
        }
    }
}

