/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.context.plugin;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.munit.common.extension.MunitPlugin;
import org.mule.munit.runner.context.plugin.MunitPluginFactory;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;

public class MunitPluginManager {
    private transient Log logger = LogFactory.getLog(this.getClass());
    private MuleContext context;
    private MunitPluginFactory pluginFactory;
    private Collection<MunitPlugin> plugins = Collections.emptyList();

    public MunitPluginManager() {
        this.pluginFactory = new MunitPluginFactory();
    }

    public void setMuleContext(MuleContext context) {
        Preconditions.checkNotNull((Object)context, (String)"The context must not be null");
        this.context = context;
    }

    public void setPluginFactory(MunitPluginFactory pluginFactory) {
        Preconditions.checkNotNull((Object)pluginFactory, (String)"The plugin factory must not be null");
        this.pluginFactory = pluginFactory;
    }

    public void loadAndInitialisePlugins() throws InitialisationException {
        this.loadPlugins();
        this.initialisePlugins();
    }

    public void loadPlugins() {
        this.logger.debug((Object)"Loading MUnit plugins...");
        if (null == this.context) {
            throw new IllegalStateException("The plugin manager requires a mule context and it's currently null");
        }
        this.plugins = this.pluginFactory.loadPlugins(this.context);
    }

    public void initialisePlugins() throws InitialisationException {
        this.logger.debug((Object)"Initializing MUnit plugins...");
        for (MunitPlugin plugin : this.plugins) {
            plugin.initialise();
            this.logger.debug((Object)(plugin.getClass().getName() + " MUnit plugin initialised"));
        }
    }

    public void startPlugins() throws MuleException {
        this.logger.debug((Object)"Starting MUnit plugins...");
        for (MunitPlugin plugin : this.plugins) {
            plugin.start();
            this.logger.debug((Object)(plugin.getClass().getName() + " MUnit plugin started"));
        }
    }

    public void stopPlugins() throws MuleException {
        this.logger.debug((Object)"Stopping MUnit plugins...");
        for (MunitPlugin plugin : this.plugins) {
            plugin.stop();
            this.logger.debug((Object)(plugin.getClass().getName() + " MUnit plugin stop"));
        }
    }

    public void disposePlugins() {
        this.logger.debug((Object)"Disposing MUnit plugins...");
        for (MunitPlugin plugin : this.plugins) {
            plugin.dispose();
            this.logger.debug((Object)(plugin.getClass().getName() + " MUnit plugin disposed"));
        }
    }
}

