/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.model;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.munit.common.event.EventBuilder;
import org.mule.munit.common.protocol.listeners.SuiteRunEventListener;
import org.mule.munit.common.protocol.message.TestStatus;
import org.mule.munit.runner.flow.AfterSuite;
import org.mule.munit.runner.flow.BeforeSuite;
import org.mule.munit.runner.flow.SimpleFlow;
import org.mule.munit.runner.model.SuiteResult;
import org.mule.munit.runner.model.Test;
import org.mule.munit.runner.model.TestResult;
import org.mule.munit.runner.output.DefaultOutputHandler;
import org.mule.munit.runner.output.TestOutputHandler;
import org.mule.munit.runner.remote.api.notifiers.DummySuiteRunEventListener;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.exception.MessagingException;

public class Suite {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private String path;
    private BeforeSuite beforeSuiteFlow;
    private List<Test> tests;
    private AfterSuite afterSuiteFlow;
    private TestOutputHandler outputHandler;
    private SuiteRunEventListener suiteRunEventListener;

    public Suite(String path) {
        this.path = path;
        this.tests = new ArrayList<Test>();
        this.outputHandler = new DefaultOutputHandler();
        this.suiteRunEventListener = new DummySuiteRunEventListener();
    }

    public void setOutputHandler(TestOutputHandler outputHandler) {
        Preconditions.checkNotNull((Object)outputHandler, (Object)"The outputHandler must not be null");
        this.outputHandler = outputHandler;
    }

    public void setSuiteRunEventListener(SuiteRunEventListener suiteRunEventListener) {
        Preconditions.checkNotNull((Object)suiteRunEventListener, (Object)"The suiteRunEventListener must not be null");
        this.suiteRunEventListener = suiteRunEventListener;
    }

    public String getPath() {
        return this.path;
    }

    public void setBeforeSuite(BeforeSuite beforeSuite) {
        this.beforeSuiteFlow = beforeSuite;
    }

    public void addTest(Test test) {
        this.tests.add(test);
    }

    public void setAfterSuite(AfterSuite afterSuite) {
        this.afterSuiteFlow = afterSuite;
    }

    public int getNumberOfTests() {
        return this.tests.size();
    }

    public boolean allTestsIgnored() {
        return this.tests.stream().allMatch(Test::isIgnore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SuiteResult run() throws Exception {
        SuiteResult result = new SuiteResult(this.path);
        try {
            this.runBeforeSuite();
            for (Test test : this.tests) {
                this.suiteRunEventListener.notifyTestStart(test.getName());
                TestResult testResult = test.run();
                result.add(testResult);
                this.suiteRunEventListener.notifyTestEnd(testResult.getName(), testResult.getStackTrace(), testResult.getStatus(), testResult.getElapsedTime());
            }
        }
        catch (Throwable e) {
            this.logger.error((Object)("Could not Run the suite: " + this.path), e);
        }
        finally {
            this.runAfterSuite();
        }
        return result;
    }

    private void runBeforeSuite() throws Throwable {
        String flowName = "";
        try {
            this.logger.debug((Object)"Executing Before Suite scope...");
            if (null != this.beforeSuiteFlow) {
                flowName = this.beforeSuiteFlow.getName();
                Event event = new EventBuilder(this.beforeSuiteFlow.getLocation()).build();
                this.suiteRunEventListener.notifyBeforeSuiteStart(flowName);
                this.process(this.beforeSuiteFlow, event);
                this.suiteRunEventListener.notifyBeforeSuiteEnd(flowName, "", TestStatus.SUCCESS);
            }
        }
        catch (MuleRuntimeException e) {
            Throwable cause = ((MessagingException)e.getCause()).getRootCause();
            this.handleBeforeSuiteEndByException(flowName, cause);
            throw cause;
        }
        catch (Throwable e) {
            this.handleBeforeSuiteEndByException(flowName, e);
            throw e;
        }
    }

    private void runAfterSuite() {
        String flowName = "";
        try {
            this.logger.debug((Object)"Executing After Suite scope...");
            if (null != this.afterSuiteFlow) {
                flowName = this.afterSuiteFlow.getName();
                Event event = new EventBuilder(this.afterSuiteFlow.getLocation()).build();
                this.suiteRunEventListener.notifyAfterSuiteStart(flowName);
                this.process(this.afterSuiteFlow, event);
                this.suiteRunEventListener.notifyAfterSuiteEnd(flowName, "", TestStatus.SUCCESS);
            }
        }
        catch (MuleRuntimeException e) {
            Throwable cause = ((MessagingException)e.getCause()).getRootCause();
            this.handleAfterSuiteEndByException(flowName, cause);
        }
        catch (Throwable e) {
            this.handleAfterSuiteEndByException(flowName, e);
        }
    }

    protected void handleBeforeSuiteEndByException(String flowName, Throwable cause) {
        String message = String.format("Before suite %s execution failed", flowName);
        this.logger.error((Object)message, cause);
        String stackTrace = this.getStackTrace(cause, message);
        this.suiteRunEventListener.notifyBeforeSuiteEnd(flowName, stackTrace, this.getStatus(cause));
    }

    private void handleAfterSuiteEndByException(String flowName, Throwable cause) {
        String message = String.format("After suite %s execution failed", flowName);
        this.logger.error((Object)message, cause);
        String stackTrace = this.getStackTrace(cause, message);
        this.suiteRunEventListener.notifyAfterSuiteEnd(flowName, stackTrace, this.getStatus(cause));
    }

    protected void process(SimpleFlow simpleFlow, Event event) throws MuleException {
        this.outputHandler.printDescription(simpleFlow.getName(), simpleFlow.getDescription());
        simpleFlow.execute(event).join();
    }

    private String getStackTrace(Throwable cause, String message) {
        RuntimeException e = new RuntimeException(message, cause);
        return ExceptionUtils.getStackTrace((Throwable)e);
    }

    private TestStatus getStatus(Throwable e) {
        return e instanceof AssertionError ? TestStatus.FAILURE : TestStatus.ERROR;
    }
}

