/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.model;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.munit.common.event.EventBuilder;
import org.mule.munit.runner.flow.AfterTest;
import org.mule.munit.runner.flow.BeforeTest;
import org.mule.munit.runner.flow.SimpleFlow;
import org.mule.munit.runner.flow.TestFlow;
import org.mule.munit.runner.model.TestResult;
import org.mule.munit.runner.output.TestOutputHandler;
import org.mule.munit.runner.processors.MunitModule;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.exception.MessagingException;

public class Test {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected BeforeTest before;
    protected AfterTest after;
    protected TestFlow test;
    protected TestOutputHandler outputHandler;
    protected MunitModule munitModule;

    public Test(BeforeTest before, TestFlow test, AfterTest after, TestOutputHandler outputHandler, MunitModule munitModule) {
        this.before = before;
        this.test = test;
        this.after = after;
        this.outputHandler = outputHandler;
        this.munitModule = munitModule;
    }

    public String getName() {
        return this.test.getName();
    }

    public boolean isIgnore() {
        return this.test.isIgnore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult run() {
        TestResult result = new TestResult(this.getName());
        this.logger.debug((Object)("About to run MUnit test: " + this.getName()));
        if (this.test.isIgnore()) {
            this.logger.debug((Object)("MUnit test: " + this.getName() + " is ignored it won't run."));
            result.setSkipped();
            result.setElapsedTime(0L);
            return result;
        }
        long testStartTime = System.currentTimeMillis();
        Event event = new EventBuilder(this.test.getLocation()).withPayload((Object)"").build();
        try {
            event = this.runBefore(event);
            this.showDescription();
            event = this.test.run(event);
        }
        catch (AssertionError t) {
            result.setFailure(ExceptionUtils.getStackTrace((Throwable)((Object)t)));
        }
        catch (Throwable e) {
            result.setError(ExceptionUtils.getStackTrace((Throwable)e));
            if (e instanceof MessagingException) {
                event = ((MessagingException)e).getEvent();
            }
        }
        finally {
            this.munitModule.reset();
            this.runAfter(result, event);
        }
        result.setElapsedTime(System.currentTimeMillis() - testStartTime);
        return result;
    }

    private Event runBefore(Event event) throws Throwable {
        this.logger.debug((Object)"Running before test scopes...");
        try {
            return this.run(event, this.before);
        }
        catch (MuleRuntimeException e) {
            MessagingException muleException = (MessagingException)e.getCause();
            Throwable cause = muleException.getRootCause();
            throw this.handleRunBeforeFailure((MuleException)muleException, cause);
        }
        catch (MuleException e) {
            throw this.handleRunBeforeFailure(e, e.getCause());
        }
    }

    private void runAfter(TestResult result, Event event) {
        this.logger.debug((Object)"Running after test scopes...");
        try {
            this.run(event, this.after);
        }
        catch (MuleRuntimeException e) {
            MessagingException muleException = (MessagingException)e.getCause();
            Throwable cause = muleException.getRootCause();
            this.handleRunAfterFailure(result, (MuleException)muleException, cause);
        }
        catch (MuleException e) {
            this.handleRunAfterFailure(result, e, e.getCause());
        }
    }

    private void handleRunAfterFailure(TestResult result, MuleException e, Throwable cause) {
        if (null != cause && cause.getClass().isAssignableFrom(AssertionError.class)) {
            result.setFailure(ExceptionUtils.getStackTrace((Throwable)cause));
        } else {
            result.setError(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private Throwable handleRunBeforeFailure(MuleException e, Throwable cause) throws Throwable {
        if (null != cause && cause.getClass().isAssignableFrom(AssertionError.class)) {
            return cause;
        }
        return e;
    }

    protected Event run(Event event, SimpleFlow flow) throws MuleException {
        if (flow != null) {
            this.outputHandler.printDescription(flow.getName(), flow.getDescription());
            event = (Event)flow.execute(event).join();
        }
        return event;
    }

    private void showDescription() {
        this.outputHandler.printDescription(this.test.getName(), this.test.getDescription());
    }
}

