/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.output;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.runner.output.ConsolePrinter;
import org.mule.munit.runner.output.OutputPrinter;
import org.mule.munit.runner.output.TestOutputHandler;

public class DefaultOutputHandler
implements TestOutputHandler {
    private List<OutputPrinter> printers = new ArrayList<OutputPrinter>();

    public DefaultOutputHandler() {
        this.printers.add(new ConsolePrinter());
    }

    public DefaultOutputHandler(List<OutputPrinter> printers) {
        this.printers = printers;
    }

    @Override
    public void printDescription(String name, String description) {
        String text = "Running " + name;
        if (StringUtils.isNotBlank((CharSequence)description)) {
            text = text + " - " + description;
        }
        this.print(text);
    }

    @Override
    public void printTestName(String suitePath) {
        String title = StringUtils.repeat((String)"=", (int)(40 + suitePath.length()));
        this.print(title);
        this.print("===========  Running  " + suitePath + "  test ===========");
        this.print(title);
    }

    public List<OutputPrinter> getPrinters() {
        return this.printers;
    }

    private void print(String text) {
        for (OutputPrinter printer : this.printers) {
            printer.print(text);
        }
    }
}

