/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.processors;

import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.util.MunitExpressionWrapper;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.processor.Processor;

public abstract class MunitProcessor
extends AbstractAnnotatedObject
implements Initialisable,
Processor {
    @Inject
    protected MuleContext muleContext;
    protected MunitExpressionWrapper expressionWrapper;

    public void initialise() throws InitialisationException {
        this.expressionWrapper = new MunitExpressionWrapper(this.muleContext.getExpressionManager());
    }

    public InternalEvent process(InternalEvent event) throws MuleException {
        try {
            return this.doProcess(event);
        }
        catch (AssertionError error) {
            AssertionError exception = new AssertionError((Object)this.getMessage(error));
            throw exception;
        }
        catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke((String)this.getProcessor()), event, (Throwable)e);
        }
    }

    protected abstract InternalEvent doProcess(InternalEvent var1);

    protected abstract String getProcessor();

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    private String getMessage(AssertionError error) {
        String message = ((Throwable)((Object)error)).getMessage();
        if (StringUtils.isEmpty((CharSequence)message)) {
            return this.getProcessor();
        }
        return message;
    }
}

