/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.remote.api.notifiers;

import java.io.PrintStream;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.protocol.listeners.RunEventListener;
import org.mule.munit.common.protocol.message.TestStatus;

public class StreamNotifier
implements RunEventListener {
    private PrintStream out;
    private int tests = 0;
    private int failures = 0;
    private int errors = 0;
    private int skipped = 0;

    public StreamNotifier(PrintStream out) {
        this.out = out;
    }

    public void notifyTestEnd(String name, String stackTrace, TestStatus status, long elapsedTime) {
        ++this.tests;
        switch (status) {
            case SUCCESS: {
                this.out.println("SUCCESS - Test " + name + " finished Successfully - Time elapsed: " + elapsedTime + "ms");
                break;
            }
            case ERROR: {
                this.out.println("ERROR - The test " + name + " finished with an Error - Time elapsed: " + elapsedTime + "ms");
                ++this.errors;
                break;
            }
            case FAILURE: {
                this.out.println("FAILURE - The test " + name + " finished with a Failure - Time elapsed: " + elapsedTime + "ms");
                ++this.failures;
                break;
            }
            case IGNORED: {
                this.out.println("SKIPPED - Test " + name + " was Skipped - Time elapsed: " + elapsedTime + "ms");
                ++this.skipped;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)stackTrace)) {
            this.out.println(stackTrace);
        }
        this.out.flush();
    }

    public void notifySuiteEnd(String suite, long elapsedTime) {
        this.out.println();
        String title = "Number of tests run: " + this.tests + " - Failed: " + this.failures + " - Errors: " + this.errors + " - Skipped: " + this.skipped + " - Time elapsed: " + elapsedTime + "ms";
        String titleFrame = StringUtils.repeat((String)"=", (int)title.length());
        this.out.println(titleFrame);
        this.out.println(title);
        this.out.println(titleFrame);
        this.out.flush();
    }
}

