/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.remote.api.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.munit.runner.remote.api.server.RunMessageHandler;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.MuleContext;

public class RunnerServer
implements Runnable,
Lifecycle {
    private static final int SOCKET_TIMEOUT_MILLIS = 10000;
    protected static final String MUNIT_SERVER_PORT = "munit.server.port";
    private static transient Log log = LogFactory.getLog(RunnerServer.class);
    @Inject
    private MuleContext muleContext;
    @Inject
    private ConfigurationComponentLocator componentLocator;
    private int port;
    private boolean keepRunning = true;
    private ServerSocket providerSocket = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.providerSocket = this.createServerSocket();
            do {
                log.info((Object)"Waiting for client connection ");
                Socket connection = this.providerSocket.accept();
                log.info((Object)("Client connection received from " + connection.getInetAddress().getHostName() + " - " + this.keepRunning));
                ObjectOutputStream out = new ObjectOutputStream(connection.getOutputStream());
                ObjectInputStream in = new ObjectInputStream(connection.getInputStream());
                this.handleClientMessage(in, out);
            } while (this.keepRunning);
        }
        catch (SocketTimeoutException timeoutException) {
            log.debug((Object)"MUnit server time out");
            if (this.keepRunning) {
                log.error((Object)("Client connection timeout after " + String.valueOf(10000) + " milliseconds"));
            }
        }
        catch (IOException ioException) {
            if (this.providerSocket != null && this.providerSocket.isClosed()) {
                if (this.keepRunning) {
                    log.warn((Object)("Kill signal received before accept timeout in port [" + this.port + "]"), (Throwable)ioException);
                } else {
                    log.debug((Object)("Shut down signal received MUnit server running in port [" + this.port + "]..."));
                }
            } else {
                log.error((Object)("Failed to start MUnit server in port [" + this.port + "]"), (Throwable)ioException);
            }
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"Fail to deserialize message.", (Throwable)e);
        }
        finally {
            try {
                log.debug((Object)("Shutting down MUnit server running in port [" + this.port + "]..."));
                if (null != this.providerSocket) {
                    this.providerSocket.close();
                }
                this.keepRunning = false;
                log.debug((Object)"MUnit server shutdown");
            }
            catch (IOException ioException) {
                log.debug((Object)"MUnit server error during shutdown.");
            }
        }
    }

    protected ServerSocket createServerSocket() throws IOException {
        this.port = Integer.parseInt(System.getProperty(MUNIT_SERVER_PORT));
        ServerSocket providerSocket = new ServerSocket(this.port, 10);
        providerSocket.setSoTimeout(10000);
        log.debug((Object)("MUnit server started listening in port [" + this.port + "]..."));
        return providerSocket;
    }

    protected void handleClientMessage(ObjectInput in, ObjectOutput out) throws IOException, ClassNotFoundException {
        RunMessageHandler commander = new RunMessageHandler(in, out, this.componentLocator);
        commander.handle();
    }

    protected void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    protected boolean isKeepRunning() {
        return this.keepRunning;
    }

    public void initialise() throws InitialisationException {
        log.debug((Object)"Initializing MUnit server...");
        this.muleContext.getSchedulerService().ioScheduler().schedule((Runnable)this, 0L, TimeUnit.SECONDS);
    }

    public void start() throws MuleException {
    }

    public void stop() throws MuleException {
        log.debug((Object)"Stop signal received, shooting down MUnit server...");
        this.keepRunning = false;
    }

    public void dispose() {
        log.debug((Object)"Dispose signal received, shooting down MUnit server...");
        try {
            this.keepRunning = false;
            if (this.providerSocket != null) {
                this.providerSocket.close();
            }
        }
        catch (IOException e) {
            log.warn((Object)"Error when sending kill signal to MUnit server", (Throwable)e);
        }
    }
}

