/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.simple;

import java.io.File;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.munit.runner.simple.MunitSimpleRunnerAction;

public class MunitSimpleRunner {
    private transient Log log = LogFactory.getLog(this.getClass());
    private File appDir;
    private String resources;
    private List<MunitSimpleRunnerAction> actions;

    public MunitSimpleRunner(String resources, List<MunitSimpleRunnerAction> actions, File appDir) {
        this.appDir = appDir;
        this.actions = actions;
        this.resources = resources;
    }

    public void run() {
        this.log.debug((Object)("Counting application flow paths: " + new Date().toString()));
        this.initMuleContextManager();
        try {
            for (MunitSimpleRunnerAction action : this.actions) {
                action.execute(null);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.log.debug((Object)("Application flow paths count done: " + new Date().toString()));
        }
    }

    public String getResources() {
        return this.resources;
    }

    private void initMuleContextManager() {
    }
}

