/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.config.factory;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.processor.MessageProcessorBuilder;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.MessageProcessorChainBuilder;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;

import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

/**
 * Generates a {@link MessageProcessorChain}
 *
 * @since 2.0.0
 * @author Mulesoft Inc.
 */
public class MessageProcessorChainFactory {

  private final MuleContext muleContext;
  private final Map<QName, Object> annotations;

  public MessageProcessorChainFactory(MuleContext muleContext, Map<QName, Object> annotations) {
    this.muleContext = muleContext;
    this.annotations = annotations;
  }

  public MessageProcessorChain create(String processorChainName, List<Processor> messageProcessors)
      throws MuleException {
    DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
    builder.setName("'" + processorChainName + "' processor chain");
    configureMessageProcessors(messageProcessors, builder);

    MessageProcessorChain processorChain = builder.build();
    processorChain.setMuleContext(muleContext);
    processorChain.setAnnotations(annotations);
    return processorChain;
  }

  protected void configureMessageProcessors(List<Processor> messageProcessors, MessageProcessorChainBuilder builder)
      throws MuleException {
    if (null != messageProcessors) {
      for (Object processor : messageProcessors) {
        if (processor instanceof Processor) {
          builder.chain((Processor) processor);
        } else if (processor instanceof MessageProcessorBuilder) {
          builder.chain((MessageProcessorBuilder) processor);
        } else {
          throw new IllegalArgumentException(
                                             "MessageProcessorBuilder should only have MessageProcessor's or MessageProcessorBuilder's configured");
        }
      }
    }
  }

}
