/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.output;


/**
 * Defines how the stage notification of the test will be handled
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public interface TestOutputHandler {

  /**
   * Prints the MUnit flow information
   *
   * @param name The name of the Munit flow (before-test,after-test,before-suite,after-suite,test)
   * @param description The flow description
   */
  void printDescription(String name, String description);

  void printTestName(String suitePath);
}
