/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.processors;

import javax.inject.Inject;

import org.mule.munit.common.behavior.BehaviorManager;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.core.api.MuleContext;

/**
 * <p>
 * Model representing the MUnit configuration
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class MunitModule extends AbstractAnnotatedObject {

  public static final String MUNIT_MODULE_ID = "___MUnitModule";

  @Inject
  protected MuleContext muleContext;

  /**
   * Defines if the flow sources should be disabled or not
   */
  protected boolean disableFlowSources = true;

  /**
   * List of flows to exclude from disableFlowSources configuration
   */
  protected ExcludeFlowSources excludeFlowSources = new ExcludeFlowSources();

  public void setDisableFlowSources(boolean disableFlowSources) {
    this.disableFlowSources = disableFlowSources;
  }

  public boolean isDisableFlowSources() {
    return disableFlowSources;
  }

  public void setExcludeFlowSources(ExcludeFlowSources excludeFlowSources) {
    this.excludeFlowSources = excludeFlowSources;
  }

  public ExcludeFlowSources getExcludeFlowSources() {
    return excludeFlowSources;
  }

  public MuleContext getMuleContext() {
    return muleContext;
  }

  public void reset() {
    BehaviorManager behaviorManager = muleContext.getRegistry().lookupObject(BehaviorManager.ID);
    if (behaviorManager != null) {
      behaviorManager.reset();
    }
  }
}
