/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.remote.api.notifiers;


import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.protocol.listeners.RunEventListener;
import org.mule.munit.common.protocol.message.TestStatus;

import java.io.PrintStream;

/**
 * <p>
 * Prints friendly messages of the test results through a given {@link PrintStream}
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class StreamNotifier implements RunEventListener {

  private PrintStream out;
  private int tests = 0;
  private int failures = 0;
  private int errors = 0;
  private int skipped = 0;

  public StreamNotifier(PrintStream out) {
    this.out = out;
  }

  @Override
  public void notifyTestEnd(String name, String stackTrace, TestStatus status, long elapsedTime) {
    tests++;
    switch (status) {
      case SUCCESS:
        out.println("SUCCESS - Test " + name + " finished Successfully - Time elapsed: " + elapsedTime + "ms");
        break;
      case ERROR:
        out.println("ERROR - The test " + name + " finished with an Error - Time elapsed: " + elapsedTime + "ms");
        errors++;
        break;
      case FAILURE:
        out.println("FAILURE - The test " + name + " finished with a Failure - Time elapsed: " + elapsedTime + "ms");
        failures++;
        break;
      case IGNORED:
        out.println("SKIPPED - Test " + name + " was Skipped - Time elapsed: " + elapsedTime + "ms");
        skipped++;
        break;
    }
    if (StringUtils.isNotBlank(stackTrace)) {
      out.println(stackTrace);
    }
    out.flush();
  }

  @Override
  public void notifySuiteEnd(String suite, long elapsedTime) {
    out.println();
    String title = "Number of tests run: " + tests + " - Failed: " + failures + " - Errors: " + errors + " - Skipped: " + skipped
        + " - Time elapsed: " + elapsedTime + "ms";
    String titleFrame = StringUtils.repeat("=", title.length());
    out.println(titleFrame);
    out.println(title);
    out.println(titleFrame);
    out.flush();
  }

}
