/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner;

import com.google.common.base.Preconditions;
import org.mule.munit.common.protocol.listeners.SuiteRunEventListener;
import org.mule.munit.runner.model.Suite;
import org.mule.munit.runner.model.SuiteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuiteRunner {
    private transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private Suite suite;
    private SuiteRunEventListener suiteRunEventListener;

    public SuiteRunner(Suite suite, SuiteRunEventListener suiteRunEventListener) {
        Preconditions.checkNotNull((Object)suite, (Object)"The suite must not be null");
        Preconditions.checkNotNull((Object)suiteRunEventListener, (Object)"The suiteRunEvent listener must not be null");
        this.suite = suite;
        this.suiteRunEventListener = suiteRunEventListener;
    }

    public void run() {
        long suiteStartTime = System.currentTimeMillis();
        this.suiteRunEventListener.notifySuiteStart(this.suite.getPath(), this.suite.getNumberOfTests());
        if (this.shouldRunSuite()) {
            this.doRun();
        } else {
            this.logger.info("MUnit suite: " + this.suite.getPath() + " will not be run. There are no tests to be run or all tests are ignored");
        }
        this.suiteRunEventListener.notifySuiteEnd(this.suite.getPath(), System.currentTimeMillis() - suiteStartTime);
    }

    private boolean shouldRunSuite() {
        return this.suite.getNumberOfTests() > 0 && !this.suite.allTestsIgnored();
    }

    private SuiteResult doRun() {
        this.logger.debug("About to run MUnit suite: " + this.suite.getPath() + " ...");
        try {
            SuiteResult suiteResult = this.suite.run();
            this.logger.debug("Tests in MUnit suite: " + this.suite.getPath() + " run");
            return suiteResult;
        }
        catch (Throwable e) {
            this.logger.error("Could not Run the suite: " + this.suite.getPath(), e);
            throw new RuntimeException("Could not Run the suite", e);
        }
    }
}

