/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.component.state;

import java.util.Optional;
import javax.inject.Inject;
import org.mule.munit.runner.processors.MunitModule;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.runtime.api.deployment.management.ComponentInitialStateManager;

public class MunitComponentInitialStateManager
implements ComponentInitialStateManager {
    private static final Boolean DEFAULT_MESSAGESOURCE_STATE = false;
    private static final String MUNIT_DISABLE_INITIAL_STATE_MANAGER = "munit.disable.initial.state.manager";
    @Inject
    protected Optional<MunitModule> munitModule;

    public boolean mustStartMessageSource(Component component) {
        if (this.disableInitialStateManager().booleanValue()) {
            return true;
        }
        if (!this.munitModule.isPresent()) {
            return DEFAULT_MESSAGESOURCE_STATE;
        }
        if (this.munitModule.get().getEnableFlowSources().getFlows().isEmpty()) {
            return !this.munitModule.get().isDisableFlowSources();
        }
        return this.shouldStartMessageSource(component);
    }

    private boolean shouldStartMessageSource(Component component) {
        ComponentLocation location = component.getLocation();
        LocationPart locationPart = (LocationPart)location.getParts().get(0);
        String partPath = locationPart.getPartPath();
        Boolean shouldStart = !this.munitModule.get().isDisableFlowSources();
        if (this.munitModule.get().getEnableFlowSources().getFlows().contains(partPath)) {
            return shouldStart == false;
        }
        return shouldStart;
    }

    private Boolean disableInitialStateManager() {
        return Boolean.valueOf(System.getProperty(MUNIT_DISABLE_INITIAL_STATE_MANAGER, "false"));
    }
}

