/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.component.state;

import java.util.Optional;

import javax.inject.Inject;

import org.mule.munit.runner.processors.MunitModule;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.runtime.api.deployment.management.ComponentInitialStateManager;

/**
 * The goal of this class is to shutdown flow sources.
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class MunitComponentInitialStateManager implements ComponentInitialStateManager {

  private static final Boolean DEFAULT_MESSAGESOURCE_STATE = false;

  private static final String MUNIT_DISABLE_INITIAL_STATE_MANAGER = "munit.disable.initial.state.manager";


  @Inject
  protected Optional<MunitModule> munitModule;

  @Override
  public boolean mustStartMessageSource(Component component) {
    if (disableInitialStateManager()) {
      return true;
    }

    if (!munitModule.isPresent()) {
      return DEFAULT_MESSAGESOURCE_STATE;
    }

    if (munitModule.get().getEnableFlowSources().getFlows().isEmpty()) {
      return !munitModule.get().isDisableFlowSources();
    } else {
      return shouldStartMessageSource(component);
    }
  }

  private boolean shouldStartMessageSource(Component component) {
    ComponentLocation location = component.getLocation();
    LocationPart locationPart = location.getParts().get(0);
    String partPath = locationPart.getPartPath();

    Boolean shouldStart = !munitModule.get().isDisableFlowSources();
    if (munitModule.get().getEnableFlowSources().getFlows().contains(partPath)) {
      return !shouldStart;
    } else {
      return shouldStart;
    }
  }

  private Boolean disableInitialStateManager() {
    return Boolean.valueOf(System.getProperty(MUNIT_DISABLE_INITIAL_STATE_MANAGER, "false"));
  }

}
