/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.processors;

import org.mule.munit.common.behavior.BehaviorManager;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.AbstractComponent;

import javax.inject.Inject;

/**
 * <p>
 * Model representing the MUnit configuration
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class MunitModule extends AbstractComponent {

  public static final String MUNIT_MODULE_ID = "___MUnitModule";

  @Inject
  protected Registry muleRegistry;

  /**
   * Defines if the flow sources should be disabled or not
   */
  protected boolean disableFlowSources = true;

  /**
   * List of flows to exclude from disableFlowSources configuration
   */
  protected EnableFlowSources enableFlowSources = new EnableFlowSources();

  public void setDisableFlowSources(boolean disableFlowSources) {
    this.disableFlowSources = disableFlowSources;
  }

  public boolean isDisableFlowSources() {
    return disableFlowSources;
  }

  public void setEnableFlowSources(EnableFlowSources enableFlowSources) {
    this.enableFlowSources = enableFlowSources;
  }

  public EnableFlowSources getEnableFlowSources() {
    return enableFlowSources;
  }

  public void reset() {
    muleRegistry.<BehaviorManager>lookupByName(BehaviorManager.ID).ifPresent(behaviorManager -> behaviorManager.reset());
  }

  public String getName() {
    return this.getLocation().getRootContainerName();
  }

}
