/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.component.state;

import java.util.Arrays;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.munit.runner.component.state.MunitComponentInitialStateManager;
import org.mule.munit.runner.processors.EnableFlowSources;
import org.mule.munit.runner.processors.MunitModule;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.LocationPart;

public class MunitComponentInitialStateManagerTest {
    private MunitModule munitModuleMock;
    private EnableFlowSources enableFlowSourcesMock;
    private MunitComponentInitialStateManager manager;

    @Before
    public void setUp() {
        this.munitModuleMock = (MunitModule)Mockito.mock(MunitModule.class);
        this.enableFlowSourcesMock = (EnableFlowSources)Mockito.mock(EnableFlowSources.class);
        Mockito.when((Object)this.munitModuleMock.getEnableFlowSources()).thenReturn((Object)this.enableFlowSourcesMock);
        this.manager = new MunitComponentInitialStateManager();
        this.manager.munitModule = Optional.of(this.munitModuleMock);
    }

    @Test
    public void noMunitModuleProvided() {
        this.manager.munitModule = Optional.empty();
        Component componentMock = (Component)Mockito.mock(Component.class);
        MatcherAssert.assertThat((String)"The message sources should not be started", (Object)this.manager.mustStartMessageSource(componentMock), (Matcher)Is.is((Object)false));
    }

    @Test
    public void nonExcludedDisableSourceMustNotStart() {
        Boolean isDisableFlowSources = true;
        Mockito.when((Object)this.munitModuleMock.isDisableFlowSources()).thenReturn((Object)isDisableFlowSources);
        Component componentMock = (Component)Mockito.mock(Component.class);
        MatcherAssert.assertThat((String)"The message sources should not be started", (Object)this.manager.mustStartMessageSource(componentMock), (Matcher)Is.is((Object)false));
    }

    @Test
    public void nonExcludedEnableSourceMustStart() {
        Boolean isDisableFlowSources = false;
        Mockito.when((Object)this.munitModuleMock.isDisableFlowSources()).thenReturn((Object)isDisableFlowSources);
        Component componentMock = (Component)Mockito.mock(Component.class);
        MatcherAssert.assertThat((String)"The message source source should started", (Object)this.manager.mustStartMessageSource(componentMock), (Matcher)Is.is((Object)true));
    }

    @Test
    public void excludedDisableSourceNoMatchMustNotStart() {
        String flowName = "aFlow";
        Boolean isDisableFlowSources = true;
        Mockito.when((Object)this.munitModuleMock.isDisableFlowSources()).thenReturn((Object)isDisableFlowSources);
        Component componentMock = this.getComponent(flowName);
        MatcherAssert.assertThat((String)"The message sources should not be started", (Object)this.manager.mustStartMessageSource(componentMock), (Matcher)Is.is((Object)false));
    }

    @Test
    public void excludedEnableSourceNoMatchMustStart() {
        String flowName = "aFlow";
        Boolean isDisableFlowSources = false;
        Mockito.when((Object)this.munitModuleMock.isDisableFlowSources()).thenReturn((Object)isDisableFlowSources);
        Component componentMock = this.getComponent(flowName);
        MatcherAssert.assertThat((String)"The message sources should not be started", (Object)this.manager.mustStartMessageSource(componentMock), (Matcher)Is.is((Object)true));
    }

    private Component getComponent(String flowName) {
        Component componentMock = (Component)Mockito.mock(Component.class);
        ComponentLocation locationMock = (ComponentLocation)Mockito.mock(ComponentLocation.class);
        LocationPart locationPartMock = (LocationPart)Mockito.mock(LocationPart.class);
        Mockito.when((Object)locationPartMock.getPartPath()).thenReturn((Object)flowName);
        Mockito.when((Object)locationMock.getParts()).thenReturn(Arrays.asList(locationPartMock));
        Mockito.when((Object)componentMock.getLocation()).thenReturn((Object)locationMock);
        return componentMock;
    }
}

