/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.flow;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import junit.framework.AssertionFailedError;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.mule.munit.common.exception.MunitError;
import org.mule.munit.runner.flow.TestFlow;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.execution.ComponentExecutionException;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.message.InternalEvent;

public class TestFlowTest {
    public static final String ANY_ERROR_ID = "ANY";
    public static final String ROUTING_ERROR_ID = "ROUTING";
    public static final String TRANSFORMATION_ERROR_ID = "TRANSFORMATION";
    public static final String EXPECTED_ERROR_ID = "MULE:ROUTING";
    public static final String EXPECTED_ERROR_ID_EXP = "#['MULE:ROUTING']";
    public static final String EXPECTED_ERROR_ID_FAKE = "FAKE:ROUTING";
    public static final String EXPECTED_EXCEPTION = "java.lang.NullPointerException";
    public static final String EXPECTED_EXCEPTION_EXP = "#[exception.causedBy(java.lang.NullPointerException)]";
    private SchedulerConfig schedulerConfigMock;
    private MuleConfiguration muleConfigurationMock;
    private ExtendedExpressionManager expressionManagerMock;
    private ErrorTypeRepository errorTypeRepositoryMock;
    private InternalEvent eventMock;
    private Error errorMock;
    private ErrorType errorTypeMock;
    private Exception causeException;
    private Event exceptionEventMock;
    private Throwable actualExceptionMock;

    @Before
    public void setUp() {
        this.muleConfigurationMock = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
        this.schedulerConfigMock = (SchedulerConfig)Mockito.mock(SchedulerConfig.class);
        this.expressionManagerMock = (ExtendedExpressionManager)Mockito.mock(ExtendedExpressionManager.class);
        this.errorTypeRepositoryMock = (ErrorTypeRepository)Mockito.mock(ErrorTypeRepository.class);
        this.eventMock = (InternalEvent)Mockito.mock(InternalEvent.class);
        this.errorMock = (Error)Mockito.mock(Error.class);
        this.errorTypeMock = (ErrorType)Mockito.mock(ErrorType.class);
        this.exceptionEventMock = (Event)Mockito.mock(Event.class);
        this.actualExceptionMock = (Throwable)Mockito.mock(Exception.class);
        this.causeException = new NullPointerException();
        Mockito.when((Object)this.muleConfigurationMock.getDefaultProcessingStrategyFactory()).thenReturn(null);
        Mockito.when((Object)this.schedulerConfigMock.withName(Matchers.anyString())).thenReturn((Object)this.schedulerConfigMock);
        Mockito.when((Object)this.eventMock.getError()).thenReturn(Optional.of(this.errorMock));
        Mockito.when((Object)this.errorMock.getErrorType()).thenReturn((Object)this.errorTypeMock);
        Mockito.when((Object)this.errorTypeMock.getNamespace()).thenReturn((Object)"MULE");
        Mockito.when((Object)this.errorTypeMock.getIdentifier()).thenReturn((Object)ANY_ERROR_ID);
        Mockito.when((Object)this.errorTypeRepositoryMock.getErrorType((ComponentIdentifier)Matchers.any(ComponentIdentifier.class))).thenReturn(Optional.of(this.errorTypeMock));
    }

    @Test
    public void validateSetters() {
        TestFlow testFlow = new TestFlow();
        testFlow.setExpectedErrorType(EXPECTED_ERROR_ID);
        testFlow.setExpectedException(EXPECTED_EXCEPTION);
        testFlow.setIgnore(true);
        MatcherAssert.assertThat((Object)testFlow.isIgnore(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)testFlow.getExpectedErrorType(), (Matcher)Is.is((Object)EXPECTED_ERROR_ID));
        MatcherAssert.assertThat((Object)testFlow.getExpectedException(), (Matcher)Is.is((Object)EXPECTED_EXCEPTION));
    }

    @Test
    public void errorIdMatchesExpectedError() {
        this.mockEvaluateIfExpression(EXPECTED_ERROR_ID, false, null);
        TestFlow testFlow = new TestFlow();
        testFlow.setExpectedErrorType(EXPECTED_ERROR_ID);
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        MatcherAssert.assertThat((Object)testFlow.validateExpected(this.actualExceptionMock, (Event)this.eventMock).isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void errorIdMatchesExpectedErrorExpression() {
        this.mockEvaluateIfExpression(EXPECTED_ERROR_ID_EXP, true, EXPECTED_ERROR_ID);
        TestFlow testFlow = new TestFlow();
        testFlow.setExpectedErrorType(EXPECTED_ERROR_ID_EXP);
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        MatcherAssert.assertThat((Object)testFlow.validateExpected(this.actualExceptionMock, (Event)this.eventMock).isPresent(), (Matcher)Is.is((Object)false));
        ((ExtendedExpressionManager)Mockito.verify((Object)this.expressionManagerMock, (VerificationMode)Mockito.atLeastOnce())).evaluate(EXPECTED_ERROR_ID_EXP, (CoreEvent)this.eventMock);
    }

    @Test(expected=MunitError.class)
    public void expectErrorExpressionIsNotString() {
        this.mockEvaluateIfExpression(EXPECTED_ERROR_ID_EXP, true, 1);
        TestFlow testFlow = new TestFlow();
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        testFlow.setExpectedErrorType(EXPECTED_ERROR_ID_EXP);
        testFlow.validateExpected(this.actualExceptionMock, (Event)this.eventMock);
    }

    @Test(expected=MunitError.class)
    public void expectErrorExpressionReturnNonExistentErrorId() {
        this.mockEvaluateIfExpression(EXPECTED_ERROR_ID_FAKE, false, null);
        Mockito.when((Object)this.errorTypeRepositoryMock.getErrorType((ComponentIdentifier)Matchers.any(ComponentIdentifier.class))).thenThrow(new Throwable[]{new IllegalStateException()});
        TestFlow testFlow = new TestFlow();
        testFlow.setExpectedErrorType(EXPECTED_ERROR_ID_FAKE);
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        testFlow.validateExpected(this.actualExceptionMock, (Event)this.eventMock);
    }

    @Ignore
    @Test
    public void errorIdDoesNotMatchesExpectedError() {
        this.mockEvaluateIfExpression(EXPECTED_ERROR_ID, false, null);
        Mockito.when((Object)this.errorTypeMock.getIdentifier()).thenReturn((Object)TRANSFORMATION_ERROR_ID);
        TestFlow testFlow = new TestFlow();
        testFlow.setExpectedErrorType(EXPECTED_ERROR_ID);
        MatcherAssert.assertThat((Object)testFlow.validateExpected(this.actualExceptionMock, (Event)this.eventMock).isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void exceptionMatchesExpectedExpression() {
        this.mockEvaluateIfExpression(EXPECTED_EXCEPTION_EXP, true, Boolean.TRUE);
        TestFlow testFlow = new TestFlow();
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        testFlow.setExpectedException(EXPECTED_EXCEPTION_EXP);
        MatcherAssert.assertThat((Object)testFlow.validateExpected(this.actualExceptionMock, (Event)this.eventMock).isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void exceptionDoesNotMatchExpression() {
        this.mockEvaluateIfExpression(EXPECTED_EXCEPTION_EXP, true, Boolean.FALSE);
        TestFlow testFlow = new TestFlow();
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        testFlow.setExpectedException(EXPECTED_EXCEPTION_EXP);
        MatcherAssert.assertThat((Object)testFlow.validateExpected(this.actualExceptionMock, (Event)this.eventMock).isPresent(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void exceptionLiteralMatchesActualExceptionClass() {
        this.mockEvaluateIfExpression(EXPECTED_EXCEPTION, false, null);
        TestFlow testFlow = new TestFlow();
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        testFlow.setExpectedException(EXPECTED_EXCEPTION);
        MatcherAssert.assertThat((Object)testFlow.validateExpected((Throwable)new NullPointerException(), (Event)this.eventMock).isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void exceptionLiteralMatchesAsSubTypeOfExceptionClass() {
        this.mockEvaluateIfExpression(EXPECTED_EXCEPTION, false, null);
        this.actualExceptionMock = new SpecificNullPointerException();
        TestFlow testFlow = new TestFlow();
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        testFlow.setExpectedException(EXPECTED_EXCEPTION);
        MatcherAssert.assertThat((Object)testFlow.validateExpected(this.actualExceptionMock, (Event)this.eventMock).isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void exceptionLiteralDoesNotMatchException() {
        this.mockEvaluateIfExpression(EXPECTED_EXCEPTION, false, null);
        this.actualExceptionMock = new IllegalArgumentException();
        TestFlow testFlow = new TestFlow();
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        testFlow.setExpectedException(EXPECTED_EXCEPTION);
        MatcherAssert.assertThat((Object)testFlow.validateExpected(this.actualExceptionMock, (Event)this.eventMock).isPresent(), (Matcher)Is.is((Object)true));
    }

    @Test(expected=MunitError.class)
    public void expectedExceptionClassNotFound() {
        this.mockEvaluateIfExpression(EXPECTED_EXCEPTION, false, null);
        TestFlow testFlow = new TestFlow();
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        testFlow.setExpectedException("org.my.FakeClass");
        testFlow.validateExpected((Throwable)new Exception((Throwable)new AssertionFailedError()), (Event)this.eventMock);
    }

    @Test
    public void exceptionWithNoCauseExceptionDoesNotMatch() {
        this.mockEvaluateIfExpression(EXPECTED_EXCEPTION, false, null);
        TestFlow testFlow = new TestFlow();
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        testFlow.setExpectedException(EXPECTED_EXCEPTION);
        MatcherAssert.assertThat((Object)testFlow.validateExpected((Throwable)new Exception((Throwable)null), (Event)this.eventMock).isPresent(), (Matcher)Is.is((Object)true));
    }

    @Test(expected=MunitError.class)
    public void failingExpressionInExpectException() {
        String weirdExpression = "#[']";
        this.mockEvaluateIfExpression(weirdExpression, false, null);
        TestFlow testFlow = new TestFlow();
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        testFlow.setExpectedException(weirdExpression);
        testFlow.validateExpected(this.actualExceptionMock, (Event)this.eventMock);
    }

    @Test(expected=MunitError.class)
    public void messagingWithNonBooleanMelInCauseException() {
        String expectExceptionExp = "#[{'':''}]";
        HashMap<String, String> mockMap = new HashMap<String, String>();
        mockMap.put("", "");
        this.mockEvaluateIfExpression(expectExceptionExp, true, mockMap);
        TestFlow testFlow = new TestFlow();
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        testFlow.setExpectedException(expectExceptionExp);
        testFlow.validateExpected(this.actualExceptionMock, (Event)this.eventMock);
    }

    @Test(expected=AssertionError.class)
    public void failureIsExpectedButNothingIsThrownItShouldFail() throws Throwable {
        Event resultEventMock = (Event)Mockito.mock(Event.class);
        InternalEvent eventMock = (InternalEvent)Mockito.mock(InternalEvent.class);
        Mockito.when((Object)resultEventMock.getError()).thenReturn(Optional.empty());
        TestFlow testFlowMock = (TestFlow)Mockito.mock(TestFlow.class);
        Mockito.when((Object)testFlowMock.isExpectingFailure()).thenReturn((Object)true);
        Mockito.when((Object)testFlowMock.doExecute((Event)Matchers.any(Event.class))).thenReturn((Object)resultEventMock);
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlowMock)).run((Event)eventMock);
        testFlowMock.run((Event)eventMock);
    }

    @Test
    public void failureIsExpectedAndMatchesCauseItShouldSucceed() throws Throwable {
        TestFlow testFlow = (TestFlow)Mockito.mock(TestFlow.class);
        testFlow.setExpectedException(EXPECTED_EXCEPTION);
        Mockito.when((Object)testFlow.isExpectingFailure()).thenReturn((Object)true);
        Mockito.when((Object)testFlow.validateExpected((Throwable)Matchers.any(), (Event)Matchers.any())).thenReturn(Optional.empty());
        Event failureEvent = (Event)Mockito.mock(Event.class);
        ExecutionException executionExceptionMock = this.buildExecutionExceptionMock(new NullPointerException(), failureEvent);
        this.mockExecuteFailure(testFlow, executionExceptionMock);
        InternalEvent internalEventMock = (InternalEvent)Mockito.mock(InternalEvent.class);
        Mockito.when((Object)internalEventMock.getError()).thenReturn(Optional.empty());
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlow)).run((Event)internalEventMock);
        Event eventResult = testFlow.run((Event)internalEventMock);
        MatcherAssert.assertThat((Object)eventResult, (Matcher)Is.is((Object)failureEvent));
    }

    @Test(expected=AssertionError.class)
    public void failureIsNotExpectedAndCauseIsAssertionErrorItShouldFail() throws Throwable {
        InternalEvent eventMock = (InternalEvent)Mockito.mock(InternalEvent.class);
        Event resultEventMock = (Event)Mockito.mock(Event.class);
        Mockito.when((Object)resultEventMock.getError()).thenReturn(Optional.empty());
        TestFlow testFlowMock = (TestFlow)Mockito.mock(TestFlow.class);
        Mockito.when((Object)testFlowMock.isExpectingFailure()).thenReturn((Object)false);
        Event failureEventMock = (Event)Mockito.mock(Event.class);
        ExecutionException executionExceptionMock = this.buildExecutionExceptionMock((Throwable)((Object)new AssertionError()), failureEventMock);
        this.mockExecuteFailure(testFlowMock, executionExceptionMock);
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlowMock)).run((Event)eventMock);
        testFlowMock.run((Event)eventMock);
    }

    @Test(expected=AssertionError.class)
    public void failureIsExpectedAndDoesNotMatchesCauseItShouldFail() throws Throwable {
        TestFlow testFlow = (TestFlow)Mockito.mock(TestFlow.class);
        Mockito.when((Object)testFlow.isExpectingFailure()).thenReturn((Object)true);
        ((TestFlow)Mockito.doThrow((Throwable)((Object)new AssertionError())).when((Object)testFlow)).validateExpected((Throwable)Matchers.any(), (Event)Matchers.any());
        Event failureEvent = (Event)Mockito.mock(Event.class);
        ExecutionException executionExceptionMock = this.buildExecutionExceptionMock(new IllegalArgumentException(), failureEvent);
        this.mockExecuteFailure(testFlow, executionExceptionMock);
        Event eventMock = (Event)Mockito.mock(Event.class);
        Mockito.when((Object)eventMock.getError()).thenReturn(Optional.empty());
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlow)).run(eventMock);
        testFlow.run(eventMock);
    }

    @Test(expected=ExecutionException.class)
    public void failureIsNotExpectedAndCauseIsNotAssertionErrorItShouldFail() throws Throwable {
        TestFlow testFlow = (TestFlow)Mockito.mock(TestFlow.class);
        Mockito.when((Object)testFlow.isExpectingFailure()).thenReturn((Object)false);
        Event failureEvent = (Event)Mockito.mock(Event.class);
        ExecutionException executionExceptionMock = this.buildExecutionExceptionMock(new IllegalArgumentException(), failureEvent);
        this.mockExecuteFailure(testFlow, executionExceptionMock);
        InternalEvent internalEventMock = (InternalEvent)Mockito.mock(InternalEvent.class);
        Mockito.when((Object)internalEventMock.getError()).thenReturn(Optional.empty());
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlow)).run((Event)internalEventMock);
        testFlow.run((Event)internalEventMock);
    }

    @Test(expected=ExecutionException.class)
    public void errorIsThrownIfCauseNotComponentExecutionException() throws Throwable {
        TestFlow testFlow = (TestFlow)Mockito.mock(TestFlow.class);
        ExecutionException executionExceptionMock = (ExecutionException)Mockito.mock(ExecutionException.class);
        Mockito.when((Object)executionExceptionMock.getCause()).thenReturn((Object)new IllegalArgumentException());
        StackTraceElement stackTraceElementMock = new StackTraceElement("FakeClass", "fakeMethod", "FakeClass.java", -1);
        StackTraceElement[] stackTraceElements = new StackTraceElement[]{stackTraceElementMock};
        Mockito.when((Object)executionExceptionMock.getStackTrace()).thenReturn((Object)stackTraceElements);
        this.mockExecuteFailure(testFlow, executionExceptionMock);
        InternalEvent internalEventMock = (InternalEvent)Mockito.mock(InternalEvent.class);
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlow)).run((Event)internalEventMock);
        testFlow.run((Event)internalEventMock);
    }

    @Test
    public void getTagsAsSet() throws Throwable {
        String tag1 = "tag1";
        String tag2 = "tag2";
        TestFlow testFlow = new TestFlow();
        testFlow.setTags("tag1,tag2");
        MatcherAssert.assertThat(new HashSet<String>(Arrays.asList(tag1, tag2)), (Matcher)Is.is((Object)testFlow.getTags()));
    }

    @Test
    public void nullTagsReturnEmptySet() throws Throwable {
        TestFlow testFlow = new TestFlow();
        testFlow.setTags(null);
        MatcherAssert.assertThat(Collections.emptySet(), (Matcher)Is.is((Object)testFlow.getTags()));
    }

    @Test
    public void blankTagsReturnEmptySet() throws Throwable {
        TestFlow testFlow = new TestFlow();
        testFlow.setTags(" ");
        MatcherAssert.assertThat(Collections.emptySet(), (Matcher)Is.is((Object)testFlow.getTags()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidTag() throws Throwable {
        TestFlow testFlow = new TestFlow();
        testFlow.setTags("NO_TAG");
        testFlow.getTags();
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidTagWithLeadingAndTrailingSpaces() throws Throwable {
        TestFlow testFlow = new TestFlow();
        testFlow.setTags(" NO_TAG ");
        testFlow.getTags();
    }

    private void mockEvaluateIfExpression(String exp, boolean isValidExpression, Object expResult) {
        this.mockIsExpressionValid(exp, isValidExpression);
        ValidationResult validationResultMock = this.validationResult(isValidExpression, "");
        Mockito.when((Object)this.expressionManagerMock.validate(exp)).thenReturn((Object)validationResultMock);
        if (isValidExpression) {
            TypedValue expressionResultMock = this.expressionResult(expResult);
            Mockito.when((Object)this.expressionManagerMock.evaluate((String)Matchers.eq((Object)exp), (CoreEvent)Matchers.any(InternalEvent.class))).thenReturn((Object)expressionResultMock);
        }
    }

    private void mockIsExpressionValid(String exp, Boolean result) {
        Mockito.when((Object)this.expressionManagerMock.isExpression(exp)).thenReturn((Object)result);
        Mockito.when((Object)this.expressionManagerMock.isValid(exp)).thenReturn((Object)result);
    }

    private TypedValue expressionResult(Object value) {
        return new TypedValue(value, DataType.fromObject((Object)value));
    }

    private ValidationResult validationResult(Boolean success, String error) {
        ValidationResult validationResultMock = (ValidationResult)Mockito.mock(ValidationResult.class);
        Mockito.when((Object)validationResultMock.isSuccess()).thenReturn((Object)success);
        Mockito.when((Object)validationResultMock.errorMessage()).thenReturn(Optional.of(error));
        return validationResultMock;
    }

    private ExecutionException buildExecutionExceptionMock(Throwable failureCause, Event failureEvent) {
        ComponentExecutionException componentExecutionExceptionMock = (ComponentExecutionException)Mockito.mock(ComponentExecutionException.class);
        Mockito.when((Object)componentExecutionExceptionMock.getCause()).thenReturn((Object)failureCause);
        Mockito.when((Object)componentExecutionExceptionMock.getEvent()).thenReturn((Object)failureEvent);
        ExecutionException failureMock = (ExecutionException)Mockito.mock(ExecutionException.class);
        Mockito.when((Object)failureMock.getCause()).thenReturn((Object)componentExecutionExceptionMock);
        StackTraceElement stackTraceElementMock = new StackTraceElement("FakeClass", "fakeMethod", "FakeClass.java", -1);
        StackTraceElement[] stackTraceElements = new StackTraceElement[]{stackTraceElementMock};
        Mockito.when((Object)failureMock.getStackTrace()).thenReturn((Object)stackTraceElements);
        return failureMock;
    }

    private void mockExecuteFailure(TestFlow testFlowMock, ExecutionException executionException) throws ExecutionException, InterruptedException {
        Mockito.when((Object)testFlowMock.doExecute((Event)Matchers.any(Event.class))).thenThrow(new Throwable[]{executionException});
    }

    public static class FallibleTestFlow
    extends TestFlow {
        private MuleException failure;

        public FallibleTestFlow(MuleException failure) {
            this.failure = failure;
        }
    }

    public static class SpecificNullPointerException
    extends NullPointerException {
    }
}

