/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.model.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import junit.framework.Assert;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.mule.munit.runner.flow.AfterTest;
import org.mule.munit.runner.flow.BeforeTest;
import org.mule.munit.runner.flow.TestFlow;
import org.mule.munit.runner.model.Suite;
import org.mule.munit.runner.model.builders.SuiteBuilder;
import org.mule.munit.runner.processors.MunitModule;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public class SuiteBuilderTest {
    private static final String SUITE_PATH = "suitePath";
    private SuiteBuilder builder;
    private MunitModule munitModuleMock;
    private ConfigurationComponentLocator componentLocatorMock;
    private LazyComponentInitializer lazyComponentInitializerMock;
    private List<AfterTest> afterTestFlows = new ArrayList<AfterTest>();
    private TestFlow testFlowMock;
    private List<BeforeTest> beforeTestFlows = new ArrayList<BeforeTest>();

    @Before
    public void setUp() {
        this.munitModuleMock = (MunitModule)Mockito.mock(MunitModule.class);
        this.componentLocatorMock = (ConfigurationComponentLocator)Mockito.mock(ConfigurationComponentLocator.class);
        this.lazyComponentInitializerMock = (LazyComponentInitializer)Mockito.mock(LazyComponentInitializer.class);
        this.testFlowMock = (TestFlow)Mockito.mock(TestFlow.class);
        Mockito.when((Object)this.componentLocatorMock.find(ComponentIdentifier.buildFromStringRepresentation((String)"munit:config"))).thenReturn(Collections.singletonList(this.munitModuleMock));
        Mockito.when((Object)this.componentLocatorMock.find(ComponentIdentifier.buildFromStringRepresentation((String)"munit:before-suite"))).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.componentLocatorMock.find(ComponentIdentifier.buildFromStringRepresentation((String)"munit:after-suite"))).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.componentLocatorMock.find(ComponentIdentifier.buildFromStringRepresentation((String)"munit:before-test"))).thenReturn(this.beforeTestFlows.stream().map(a -> a).collect(Collectors.toList()));
        Mockito.when((Object)this.componentLocatorMock.find(ComponentIdentifier.buildFromStringRepresentation((String)"munit:after-test"))).thenReturn(this.afterTestFlows.stream().map(a -> a).collect(Collectors.toList()));
        Mockito.when((Object)this.componentLocatorMock.find(ComponentIdentifier.buildFromStringRepresentation((String)"munit:test"))).thenReturn(Collections.singletonList(this.testFlowMock));
        DefaultComponentLocation.DefaultLocationPart part = (DefaultComponentLocation.DefaultLocationPart)Mockito.mock(DefaultComponentLocation.DefaultLocationPart.class);
        Mockito.when((Object)part.getFileName()).thenReturn(Optional.of(SUITE_PATH));
        Mockito.when((Object)this.munitModuleMock.getLocation()).thenReturn((Object)new DefaultComponentLocation(Optional.of("munit"), Collections.singletonList(part)));
        Mockito.when((Object)this.testFlowMock.getLocation()).thenReturn((Object)new DefaultComponentLocation(Optional.of("test1"), Collections.singletonList(part)));
        this.builder = new SuiteBuilder(SUITE_PATH, this.componentLocatorMock, this.lazyComponentInitializerMock);
    }

    @Test(expected=NullPointerException.class)
    public void createBuilderNullComponentLocatorFail() {
        new SuiteBuilder(SUITE_PATH, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createBuilderNullSuitePathFail() {
        new SuiteBuilder(null, this.componentLocatorMock, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createBuilderEmptySuitePathFail() {
        new SuiteBuilder("", this.componentLocatorMock, null);
    }

    @Test
    public void createTestMustNotBeNull() {
        Assert.assertNotNull((Object)this.builder.test(null, null, null, this.munitModuleMock));
    }

    @Test
    public void allScopesMustBeRetrieved() {
        this.builder.build();
        this.verifyLookups();
    }

    @Test
    public void testBuildBlankTestToRunName() {
        this.builder.withTestNames(Collections.emptyList());
        this.assertNumberOfTests(this.builder.build(), 1);
        this.verifyLookups();
    }

    @Test
    public void testBuildMunitTestsIsIgnored() {
        Mockito.when((Object)this.testFlowMock.isIgnore()).thenReturn((Object)true);
        this.assertNumberOfTests(this.builder.build(), 1);
        this.verifyLookups();
    }

    @Test
    public void testBuildMunitTestsNameMatchesShouldNotIgnore() {
        Mockito.when((Object)this.testFlowMock.getName()).thenReturn((Object)"test_name");
        this.builder.withTestNames(Arrays.asList("test_name"));
        this.assertNumberOfTests(this.builder.build(), 1);
        this.verifyLookups();
    }

    @Test
    public void testBuildMunitTestsNameDoesntMatchShouldIgnore() {
        Mockito.when((Object)this.testFlowMock.getName()).thenReturn((Object)"test_name");
        this.builder.withTestNames(Arrays.asList("not_matching_test_name"));
        this.assertNumberOfTests(this.builder.build(), 0);
        this.verifyLookups();
    }

    @Test
    public void testBuildMunitTestsDoesntMatchTagsShouldIgnore() {
        Mockito.when((Object)this.testFlowMock.getName()).thenReturn((Object)"test_name");
        Mockito.when((Object)this.testFlowMock.getTags()).thenReturn(Collections.singleton("oneTag"));
        this.builder.withTestNames(Collections.emptyList()).withTags(Collections.singleton("otherTag"));
        this.assertNumberOfTests(this.builder.build(), 0);
        this.verifyLookups();
    }

    @Test
    public void testBuildMunitTestsMatchesSameTagShouldNotIgnore() {
        Mockito.when((Object)this.testFlowMock.getName()).thenReturn((Object)"test_name");
        Mockito.when((Object)this.testFlowMock.getTags()).thenReturn(Collections.singleton("oneTag"));
        this.builder.withTestNames(Collections.emptyList()).withTags(Collections.singleton("oneTag"));
        this.assertNumberOfTests(this.builder.build(), 1);
        this.verifyLookups();
    }

    private void assertNumberOfTests(Suite suite, int numberOfTests) {
        MatcherAssert.assertThat((Object)suite.getNumberOfTests(), (Matcher)CoreMatchers.equalTo((Object)numberOfTests));
    }

    private void verifyLookups() {
        ((ConfigurationComponentLocator)Mockito.verify((Object)this.componentLocatorMock, (VerificationMode)Mockito.times((int)1))).find(ComponentIdentifier.buildFromStringRepresentation((String)"munit:config"));
        ((ConfigurationComponentLocator)Mockito.verify((Object)this.componentLocatorMock, (VerificationMode)Mockito.times((int)1))).find(ComponentIdentifier.buildFromStringRepresentation((String)"munit:before-suite"));
        ((ConfigurationComponentLocator)Mockito.verify((Object)this.componentLocatorMock, (VerificationMode)Mockito.times((int)1))).find(ComponentIdentifier.buildFromStringRepresentation((String)"munit:after-suite"));
        ((ConfigurationComponentLocator)Mockito.verify((Object)this.componentLocatorMock, (VerificationMode)Mockito.times((int)1))).find(ComponentIdentifier.buildFromStringRepresentation((String)"munit:before-test"));
        ((ConfigurationComponentLocator)Mockito.verify((Object)this.componentLocatorMock, (VerificationMode)Mockito.times((int)1))).find(ComponentIdentifier.buildFromStringRepresentation((String)"munit:after-test"));
        ((ConfigurationComponentLocator)Mockito.verify((Object)this.componentLocatorMock, (VerificationMode)Mockito.times((int)1))).find(ComponentIdentifier.buildFromStringRepresentation((String)"munit:test"));
    }
}

