/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.processors;

import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.mule.munit.common.behavior.BehaviorManager;
import org.mule.munit.runner.processors.MunitModule;
import org.mule.runtime.api.artifact.Registry;

public class MunitModuleTest {
    private MunitModule module;
    private Registry muleRegistryMock;
    private BehaviorManager behaviorManagerMock;

    @Before
    public void setUp() {
        this.module = new MunitModule();
        this.muleRegistryMock = (Registry)Mockito.mock(Registry.class);
        this.behaviorManagerMock = (BehaviorManager)Mockito.mock(BehaviorManager.class);
        Mockito.when((Object)this.muleRegistryMock.lookupByName("_munitBehaviorManager")).thenReturn(Optional.of(this.behaviorManagerMock));
    }

    @Test
    public void validateMockInbounds() {
        MatcherAssert.assertThat((String)"The value is wrong", (Object)this.module.isDisableFlowSources(), (Matcher)Is.is((Object)true));
        this.module.setDisableFlowSources(false);
        MatcherAssert.assertThat((String)"The value is wrong", (Object)this.module.isDisableFlowSources(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testRest() {
        this.module.muleRegistry = this.muleRegistryMock;
        this.module.reset();
        ((BehaviorManager)Mockito.verify((Object)this.behaviorManagerMock, (VerificationMode)Mockito.times((int)1))).reset();
    }
}

