/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.processors;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.activation.DataHandler;
import junit.framework.Assert;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.mule.munit.common.event.EventBuilder;
import org.mule.munit.common.exception.MunitError;
import org.mule.munit.common.model.Attachment;
import org.mule.munit.common.model.EventAttributes;
import org.mule.munit.common.model.NullObject;
import org.mule.munit.common.model.Payload;
import org.mule.munit.common.model.Property;
import org.mule.munit.common.model.UntypedEventError;
import org.mule.munit.common.model.Variable;
import org.mule.munit.common.util.IOUtils;
import org.mule.munit.runner.processors.SetEventProcessor;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.privileged.PrivilegedMuleContext;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;

public class SetEventProcessorTest {
    private static final String PAYLOAD = "r1";
    private static final String PAYLOAD_EXP = "#['exp']";
    private static final String SESSION_VALUE = "sessionValue";
    private static final String INBOUND_VALUE = "inboundValue";
    private static final String OUTBOUND_VALUE = "outboundValue";
    private static final String VARIABLE_VALUE = "invocationValue";
    private static final String INBOUND_ATTACHMENT_VALUE = "inboundAttachmentValue";
    private static final String OUTBOUND_ATTACHMENT_VALUE = "outboundAttachmentValue";
    private static final String SESSION_KEY = "sessionKey";
    private static final String INBOUND_KEY = "inboundKey";
    private static final String OUTBOUND_KEY = "outboundKey";
    private static final String VARIABLE_KEY = "variableKey";
    private static final String INBOUND_ATTACHMENT_KEY = "inboundAttachmentKey";
    private static final String OUTBOUND_ATTACHMENT_KEY = "outboundAttachmentKey";
    private static final String SESSION_KEY_EXP = "#['sessionKey']";
    private static final String INBOUND_KEY_EXP = "#['inboundKey']";
    private static final String OUTBOUND_KEY_EXP = "#['outboundKey']";
    private static final String VARIABLE_KEY_EXP = "#['variableKey']";
    private static final String INBOUND_ATTACHMENT_KEY_EXP = "#['inboundAttachmentKey']";
    private static final String OUTBOUND_ATTACHMENT_KEY_EXP = "#['outboundAttachmentKey']";
    private static final String ERROR_TYPE_ID = "my:error_type";
    private static final Exception ERROR_CAUSE_MOCK = (Exception)Mockito.mock(Exception.class);
    private static final String INVALID_MEL_EXPRESSION = "#['LALERO'";
    private static final String NON_STRING_MEL_EXPRESSION = "#[1]";
    private static final String NULL_MEL_EXPRESSION = "#[null]";
    private static final String TEST_ENCODING = "US-ASCII";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String DEFAULT_MEDIA_TYPE = "*/*";
    private static final String ENCODING = "US-ASCII";
    private static final String MEDIA_TYPE = "application/json";
    private static final Object ATTRIBUTES_MOCK = "EXAMPLE_ATTRIBUTES";
    private SetEventProcessor processor;
    private PrivilegedMuleContext muleContextMock;
    private ExtendedExpressionManager expressionManagerMock;
    private EventContext eventContextMock;
    private ErrorTypeLocator errorTypeLocatorMock;

    @Before
    public void setUp() throws InitialisationException {
        this.muleContextMock = (PrivilegedMuleContext)Mockito.mock(PrivilegedMuleContext.class);
        this.eventContextMock = (EventContext)Mockito.mock(BaseEventContext.class);
        this.expressionManagerMock = (ExtendedExpressionManager)Mockito.mock(ExtendedExpressionManager.class);
        this.errorTypeLocatorMock = (ErrorTypeLocator)Mockito.mock(ErrorTypeLocator.class);
        Mockito.when((Object)this.muleContextMock.getErrorTypeLocator()).thenReturn((Object)this.errorTypeLocatorMock);
        Mockito.when((Object)ERROR_CAUSE_MOCK.getMessage()).thenReturn((Object)"");
        this.processor = new SetEventProcessor();
        this.processor.setMuleContext(this.muleContextMock);
        this.processor.setExtendedExpressionManager(this.expressionManagerMock);
        this.processor.initialise();
    }

    @Test
    public void noExpressions() throws MuleException, IOException {
        this.processor.setSessionProperties(this.properties(SESSION_KEY, SESSION_VALUE, MEDIA_TYPE, "US-ASCII"));
        this.processor.setVariables(this.variables(VARIABLE_KEY, VARIABLE_VALUE, MEDIA_TYPE, "US-ASCII"));
        this.processor.setPayload(this.payload(PAYLOAD, MEDIA_TYPE, "US-ASCII"));
        this.processor.setAttributes(this.attributes(ATTRIBUTES_MOCK));
        this.processor.setInboundProperties(this.properties(INBOUND_KEY, INBOUND_VALUE, MEDIA_TYPE, "US-ASCII"));
        this.processor.setOutboundProperties(this.properties(OUTBOUND_KEY, OUTBOUND_VALUE, MEDIA_TYPE, "US-ASCII"));
        this.processor.setInboundAttachments(this.attachments(INBOUND_ATTACHMENT_KEY, INBOUND_ATTACHMENT_VALUE, MEDIA_TYPE, "US-ASCII"));
        this.processor.setOutboundAttachments(this.attachments(OUTBOUND_ATTACHMENT_KEY, OUTBOUND_ATTACHMENT_VALUE, MEDIA_TYPE, "US-ASCII"));
        CoreEvent event = this.processor.doProcess((CoreEvent)this.eventBuilder().build());
        MatcherAssert.assertThat((String)"Property is not as expected", (Object)((InternalEvent)event).getSession().getProperty(SESSION_KEY), (Matcher)Is.is((Object)SESSION_VALUE));
        MatcherAssert.assertThat((String)"Property is not as expected", (Object)((TypedValue)event.getVariables().get(VARIABLE_KEY)).getValue(), (Matcher)Is.is((Object)VARIABLE_VALUE));
        this.assertDataType(((TypedValue)event.getVariables().get(VARIABLE_KEY)).getDataType(), MEDIA_TYPE, "US-ASCII");
        Message message = event.getMessage();
        MatcherAssert.assertThat((String)"Payload is not as expected", (Object)((InternalMessage)message).getPayload().getValue(), (Matcher)Is.is((Object)PAYLOAD));
        this.assertDataType(message.getPayload().getDataType(), MEDIA_TYPE, "US-ASCII");
        MatcherAssert.assertThat((String)"Attributes is not as expected", (Object)message.getAttributes().getValue(), (Matcher)Is.is((Object)ATTRIBUTES_MOCK));
        MatcherAssert.assertThat((String)"Property is not as expected", (Object)((InternalMessage)message).getInboundProperty(INBOUND_KEY), (Matcher)Is.is((Object)INBOUND_VALUE));
        this.assertDataType(((InternalMessage)message).getInboundPropertyDataType(INBOUND_KEY), MEDIA_TYPE, "US-ASCII");
        MatcherAssert.assertThat((String)"Property is not as expected", (Object)((InternalMessage)message).getOutboundProperty(OUTBOUND_KEY), (Matcher)Is.is((Object)OUTBOUND_VALUE));
        this.assertDataType(((InternalMessage)message).getOutboundPropertyDataType(OUTBOUND_KEY), MEDIA_TYPE, "US-ASCII");
        this.assertAttachment(((InternalMessage)message).getInboundAttachment(INBOUND_ATTACHMENT_KEY), INBOUND_ATTACHMENT_VALUE, MEDIA_TYPE, "US-ASCII");
        this.assertAttachment(((InternalMessage)message).getOutboundAttachment(OUTBOUND_ATTACHMENT_KEY), OUTBOUND_ATTACHMENT_VALUE, MEDIA_TYPE, "US-ASCII");
    }

    @Test
    public void withExpressions() throws MuleException, IOException {
        this.mockEvaluateIfExpression(SESSION_KEY_EXP, SESSION_KEY);
        this.mockEvaluateIfExpression(INBOUND_KEY_EXP, INBOUND_KEY);
        this.mockEvaluateIfExpression(OUTBOUND_KEY_EXP, OUTBOUND_KEY);
        this.mockEvaluateIfExpression(VARIABLE_KEY_EXP, VARIABLE_KEY);
        this.mockEvaluateIfExpression(INBOUND_ATTACHMENT_KEY_EXP, INBOUND_ATTACHMENT_KEY);
        this.mockEvaluateIfExpression(OUTBOUND_ATTACHMENT_KEY_EXP, OUTBOUND_ATTACHMENT_KEY);
        this.processor.setSessionProperties(this.properties(SESSION_KEY_EXP, SESSION_VALUE, MEDIA_TYPE, "US-ASCII"));
        this.processor.setVariables(this.variables(VARIABLE_KEY_EXP, VARIABLE_VALUE, MEDIA_TYPE, "US-ASCII"));
        this.processor.setPayload(this.payload(PAYLOAD, MEDIA_TYPE, "US-ASCII"));
        this.processor.setAttributes(this.attributes(ATTRIBUTES_MOCK));
        this.processor.setInboundProperties(this.properties(INBOUND_KEY_EXP, INBOUND_VALUE, MEDIA_TYPE, "US-ASCII"));
        this.processor.setOutboundProperties(this.properties(OUTBOUND_KEY_EXP, OUTBOUND_VALUE, MEDIA_TYPE, "US-ASCII"));
        this.processor.setInboundAttachments(this.attachments(INBOUND_ATTACHMENT_KEY_EXP, INBOUND_ATTACHMENT_VALUE, MEDIA_TYPE, "US-ASCII"));
        this.processor.setOutboundAttachments(this.attachments(OUTBOUND_ATTACHMENT_KEY_EXP, OUTBOUND_ATTACHMENT_VALUE, MEDIA_TYPE, "US-ASCII"));
        CoreEvent event = this.processor.doProcess((CoreEvent)this.eventBuilder().build());
        MatcherAssert.assertThat((String)"Property is not as expected", (Object)((InternalEvent)event).getSession().getProperty(SESSION_KEY), (Matcher)Is.is((Object)SESSION_VALUE));
        MatcherAssert.assertThat((String)"Property is not as expected", (Object)((TypedValue)event.getVariables().get(VARIABLE_KEY)).getValue(), (Matcher)Is.is((Object)VARIABLE_VALUE));
        this.assertDataType(((TypedValue)event.getVariables().get(VARIABLE_KEY)).getDataType(), MEDIA_TYPE, "US-ASCII");
        Message message = event.getMessage();
        MatcherAssert.assertThat((String)"Payload is not as expected", (Object)message.getPayload().getValue(), (Matcher)Is.is((Object)PAYLOAD));
        this.assertDataType(message.getPayload().getDataType(), MEDIA_TYPE, "US-ASCII");
        MatcherAssert.assertThat((String)"Attributes is not as expected", (Object)message.getAttributes().getValue(), (Matcher)Is.is((Object)ATTRIBUTES_MOCK));
        MatcherAssert.assertThat((String)"Property is not as expected", (Object)((InternalMessage)message).getInboundProperty(INBOUND_KEY), (Matcher)Is.is((Object)INBOUND_VALUE));
        this.assertDataType(((InternalMessage)message).getInboundPropertyDataType(INBOUND_KEY), MEDIA_TYPE, "US-ASCII");
        MatcherAssert.assertThat((String)"Property is not as expected", (Object)((InternalMessage)message).getOutboundProperty(OUTBOUND_KEY), (Matcher)Is.is((Object)OUTBOUND_VALUE));
        this.assertDataType(((InternalMessage)message).getOutboundPropertyDataType(OUTBOUND_KEY), MEDIA_TYPE, "US-ASCII");
        this.assertAttachment(((InternalMessage)message).getInboundAttachment(INBOUND_ATTACHMENT_KEY), INBOUND_ATTACHMENT_VALUE, MEDIA_TYPE, "US-ASCII");
        this.assertAttachment(((InternalMessage)message).getOutboundAttachment(OUTBOUND_ATTACHMENT_KEY), OUTBOUND_ATTACHMENT_VALUE, MEDIA_TYPE, "US-ASCII");
        Stream<String> expressionsKeys = Stream.of(SESSION_KEY_EXP, INBOUND_KEY_EXP, OUTBOUND_KEY_EXP, VARIABLE_KEY_EXP, INBOUND_ATTACHMENT_KEY_EXP, OUTBOUND_ATTACHMENT_KEY_EXP);
        expressionsKeys.forEach(e -> this.verifyEvaluateIfExpression((String)e));
    }

    @Test
    public void withPayload() {
        this.processor.setPayload(this.payload(PAYLOAD));
        CoreEvent event = this.processor.doProcess((CoreEvent)((InternalEvent)this.eventBuilder().build()));
        MatcherAssert.assertThat((String)"Payload is not as expected", (Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)PAYLOAD));
    }

    @Test
    public void withPayloadFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().withPayload((Object)PAYLOAD).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MatcherAssert.assertThat((String)"Payload is not as expected", (Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)PAYLOAD));
    }

    @Test
    public void withNullPayloadFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().withPayload((Object)PAYLOAD).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setPayload(this.payload(null));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MatcherAssert.assertThat((String)"Payload is not as expected", (Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void withMediaType() {
        this.processor.setPayload(this.payload(MEDIA_TYPE, null));
        CoreEvent event = this.processor.doProcess((CoreEvent)((InternalEvent)this.eventBuilder().build()));
        MediaType mediaType = event.getMessage().getPayload().getDataType().getMediaType();
        MatcherAssert.assertThat((String)"Media type is not as expected", (Object)mediaType.getPrimaryType(), (Matcher)Is.is((Object)DataType.JSON_STRING.getMediaType().getPrimaryType()));
        MatcherAssert.assertThat((String)"Media type is not as expected", (Object)mediaType.getSubType(), (Matcher)Is.is((Object)DataType.JSON_STRING.getMediaType().getSubType()));
    }

    @Test
    public void withMediaTypeFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().withMediaType(DataType.JSON_STRING.getMediaType()).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MediaType mediaType = event.getMessage().getPayload().getDataType().getMediaType();
        MatcherAssert.assertThat((String)"Media type is not as expected", (Object)mediaType.getPrimaryType(), (Matcher)Is.is((Object)DataType.JSON_STRING.getMediaType().getPrimaryType()));
        MatcherAssert.assertThat((String)"Media type is not as expected", (Object)mediaType.getSubType(), (Matcher)Is.is((Object)DataType.JSON_STRING.getMediaType().getSubType()));
    }

    @Test
    public void withNullMediaTypeFromEventItShouldDefault() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().withMediaType(DataType.JSON_STRING.getMediaType()).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setPayload(this.payload(null, null));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MediaType mediaType = event.getMessage().getPayload().getDataType().getMediaType();
        MatcherAssert.assertThat((String)"Media type is not as expected", (Object)mediaType.getPrimaryType(), (Matcher)Is.is((Object)DataType.JSON_STRING.getMediaType().getPrimaryType()));
        MatcherAssert.assertThat((String)"Media type is not as expected", (Object)mediaType.getSubType(), (Matcher)Is.is((Object)DataType.JSON_STRING.getMediaType().getSubType()));
    }

    @Test
    public void withEmptyMediaTypeFromEventItShouldDefault() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().withMediaType(DataType.JSON_STRING.getMediaType()).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setPayload(this.payload("", null));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MediaType mediaType = event.getMessage().getPayload().getDataType().getMediaType();
        MatcherAssert.assertThat((String)"Media type is not as expected", (Object)mediaType.getPrimaryType(), (Matcher)Is.is((Object)DataType.JSON_STRING.getMediaType().getPrimaryType()));
        MatcherAssert.assertThat((String)"Media type is not as expected", (Object)mediaType.getSubType(), (Matcher)Is.is((Object)DataType.JSON_STRING.getMediaType().getSubType()));
    }

    @Test
    public void withDifferentMediaTypeFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().withMediaType(DataType.JSON_STRING.getMediaType()).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setPayload(this.payload("text/xml", null));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MediaType mediaType = event.getMessage().getPayload().getDataType().getMediaType();
        MatcherAssert.assertThat((String)"Media type is not as expected", (Object)mediaType.getPrimaryType(), (Matcher)Is.is((Object)DataType.XML_STRING.getMediaType().getPrimaryType()));
        MatcherAssert.assertThat((String)"Media type is not as expected", (Object)mediaType.getSubType(), (Matcher)Is.is((Object)DataType.XML_STRING.getMediaType().getSubType()));
    }

    @Test
    public void withEncoding() {
        this.processor.setPayload(this.payload(null, "US-ASCII"));
        CoreEvent event = this.processor.doProcess((CoreEvent)((InternalEvent)this.eventBuilder().build()));
        MediaType mediaType = event.getMessage().getPayload().getDataType().getMediaType();
        MatcherAssert.assertThat((String)"Encoding is not as expected", (Object)((Charset)mediaType.getCharset().get()).toString(), (Matcher)Is.is((Object)"US-ASCII"));
    }

    @Test
    public void withEncodingFromEvent() {
        MediaType originalMediaType = DataType.JSON_STRING.getMediaType();
        originalMediaType = originalMediaType.withCharset(Charset.forName("US-ASCII"));
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().withMediaType(originalMediaType).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MediaType mediaType = event.getMessage().getPayload().getDataType().getMediaType();
        MatcherAssert.assertThat((String)"Encoding is not as expected", (Object)((Charset)mediaType.getCharset().get()).toString(), (Matcher)Is.is((Object)"US-ASCII"));
    }

    @Test
    public void withNullEncodingFromEvent() {
        MediaType originalMediaType = DataType.JSON_STRING.getMediaType();
        originalMediaType = originalMediaType.withCharset(Charset.forName("US-ASCII"));
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().withMediaType(originalMediaType).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setPayload(this.payload(null, null, null));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MediaType mediaType = event.getMessage().getPayload().getDataType().getMediaType();
        MatcherAssert.assertThat((String)"Encoding is not as expected", (Object)((Charset)mediaType.getCharset().get()).toString(), (Matcher)Is.is((Object)"US-ASCII"));
    }

    @Test
    public void withDifferentEncodingFromEvent() {
        MediaType originalMediaType = DataType.JSON_STRING.getMediaType();
        originalMediaType = originalMediaType.withCharset(Charset.forName("US-ASCII"));
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().withMediaType(originalMediaType).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setPayload(this.payload(null, DEFAULT_ENCODING));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MediaType mediaType = event.getMessage().getPayload().getDataType().getMediaType();
        MatcherAssert.assertThat((String)"Encoding is not as expected", (Object)((Charset)mediaType.getCharset().get()).toString(), (Matcher)Is.is((Object)DEFAULT_ENCODING));
    }

    @Test
    public void withAttributes() {
        this.processor.setAttributes(this.attributes(ATTRIBUTES_MOCK));
        CoreEvent event = this.processor.doProcess((CoreEvent)((InternalEvent)this.eventBuilder().build()));
        MatcherAssert.assertThat((String)"Payload is not as expected", (Object)event.getMessage().getAttributes().getValue(), (Matcher)Is.is((Object)ATTRIBUTES_MOCK));
    }

    @Test
    public void withAttributesFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().withAttributes(ATTRIBUTES_MOCK).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MatcherAssert.assertThat((String)"Payload is not as expected", (Object)event.getMessage().getAttributes().getValue(), (Matcher)Is.is((Object)ATTRIBUTES_MOCK));
    }

    @Test
    public void withNullAttributesFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().withAttributes(ATTRIBUTES_MOCK).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setAttributes(this.attributes(null));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MatcherAssert.assertThat((String)"Payload is not as expected", (Object)event.getMessage().getAttributes().getValue(), (Matcher)Is.is((Object)ATTRIBUTES_MOCK));
    }

    @Test
    public void withDifferentAttributesFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().withAttributes((Object)new NullObject()).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setAttributes(this.attributes(ATTRIBUTES_MOCK));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MatcherAssert.assertThat((String)"Payload is not as expected", (Object)event.getMessage().getAttributes().getValue(), (Matcher)Is.is((Object)ATTRIBUTES_MOCK));
    }

    @Test
    public void withVariables() {
        this.processor.setVariables(this.variables(VARIABLE_KEY, VARIABLE_VALUE, MEDIA_TYPE, "US-ASCII"));
        CoreEvent event = this.processor.doProcess((CoreEvent)((InternalEvent)this.eventBuilder().build()));
        MatcherAssert.assertThat((String)"Property is not as expected", (Object)((TypedValue)event.getVariables().get(VARIABLE_KEY)).getValue(), (Matcher)Is.is((Object)VARIABLE_VALUE));
        this.assertDataType(((TypedValue)event.getVariables().get(VARIABLE_KEY)).getDataType(), MEDIA_TYPE, "US-ASCII");
    }

    @Test
    public void withVariablesFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().addVariable(VARIABLE_KEY, (Object)VARIABLE_VALUE, MEDIA_TYPE, "US-ASCII").build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MatcherAssert.assertThat((String)"Property is not as expected", (Object)((TypedValue)event.getVariables().get(VARIABLE_KEY)).getValue(), (Matcher)Is.is((Object)VARIABLE_VALUE));
        this.assertDataType(((TypedValue)event.getVariables().get(VARIABLE_KEY)).getDataType(), MEDIA_TYPE, "US-ASCII");
    }

    @Test
    public void withEmptyVariablesFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().addVariable(VARIABLE_KEY, (Object)VARIABLE_VALUE, MEDIA_TYPE, "US-ASCII").build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setVariables(Collections.emptyList());
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MatcherAssert.assertThat((String)"Property is not as expected", event.getVariables().keySet(), (Matcher)Is.is(Collections.emptySet()));
    }

    @Test(expected=NullPointerException.class)
    public void withNullVariablesFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().addVariable(VARIABLE_KEY, (Object)VARIABLE_VALUE, MEDIA_TYPE, "US-ASCII").build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setVariables(null);
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MatcherAssert.assertThat((String)"Property is not as expected", event.getVariables().keySet(), (Matcher)Is.is(Collections.emptySet()));
    }

    @Test
    public void withSessionProperties() {
        this.processor.setSessionProperties(this.properties(SESSION_KEY, SESSION_VALUE, MEDIA_TYPE, "US-ASCII"));
        CoreEvent event = this.processor.doProcess((CoreEvent)((InternalEvent)this.eventBuilder().build()));
        MatcherAssert.assertThat((String)"Property is not as expected", (Object)((InternalEvent)event).getSession().getProperty(SESSION_KEY), (Matcher)Is.is((Object)SESSION_VALUE));
        this.assertDataType(((InternalEvent)event).getSession().getPropertyDataType(SESSION_KEY), MEDIA_TYPE, "US-ASCII");
    }

    @Test
    public void withSessionPropertiesFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().addSessionProperty(SESSION_KEY, (Object)SESSION_VALUE, MEDIA_TYPE, "US-ASCII").build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MatcherAssert.assertThat((String)"Property is not as expected", (Object)((InternalEvent)event).getSession().getProperty(SESSION_KEY), (Matcher)Is.is((Object)SESSION_VALUE));
        this.assertDataType(((InternalEvent)event).getSession().getPropertyDataType(SESSION_KEY), MEDIA_TYPE, "US-ASCII");
    }

    @Test
    public void withEmptySessionPropertiesFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().addSessionProperty(SESSION_KEY, (Object)SESSION_VALUE, MEDIA_TYPE, "US-ASCII").build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setSessionProperties(Collections.emptyList());
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MatcherAssert.assertThat((String)"Property is not as expected", (Object)((InternalEvent)event).getSession().getPropertyNamesAsSet(), (Matcher)Is.is(Collections.emptySet()));
    }

    @Test(expected=NullPointerException.class)
    public void withNullSessionPropertiesFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().addSessionProperty(SESSION_KEY, (Object)SESSION_VALUE, MEDIA_TYPE, "US-ASCII").build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setSessionProperties(null);
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MatcherAssert.assertThat((String)"Property is not as expected", (Object)((InternalEvent)event).getSession().getPropertyNamesAsSet(), (Matcher)Is.is(Collections.emptySet()));
    }

    @Test
    public void withInboundProperties() {
        this.processor.setInboundProperties(this.properties(INBOUND_KEY, INBOUND_VALUE, MEDIA_TYPE, "US-ASCII"));
        CoreEvent event = this.processor.doProcess((CoreEvent)((InternalEvent)this.eventBuilder().build()));
        Message message = event.getMessage();
        MatcherAssert.assertThat((String)"Property is not as expected", (Object)((InternalMessage)message).getInboundProperty(INBOUND_KEY), (Matcher)Is.is((Object)INBOUND_VALUE));
        this.assertDataType(((InternalMessage)message).getInboundPropertyDataType(INBOUND_KEY), MEDIA_TYPE, "US-ASCII");
    }

    @Test
    public void withInboundPropertiesFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().addInboundProperty(INBOUND_KEY, (Serializable)((Object)INBOUND_VALUE), MEDIA_TYPE, "US-ASCII").build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        Message message = event.getMessage();
        MatcherAssert.assertThat((String)"Property is not as expected", (Object)((InternalMessage)message).getInboundProperty(INBOUND_KEY), (Matcher)Is.is((Object)INBOUND_VALUE));
        this.assertDataType(((InternalMessage)message).getInboundPropertyDataType(INBOUND_KEY), MEDIA_TYPE, "US-ASCII");
    }

    @Test
    public void withEmptyInboundPropertiesFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().addInboundProperty(INBOUND_KEY, (Serializable)((Object)INBOUND_VALUE), MEDIA_TYPE, "US-ASCII").build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setInboundProperties(Collections.emptyList());
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        Message message = event.getMessage();
        MatcherAssert.assertThat((String)"Property is not as expected", (Object)((InternalMessage)message).getInboundPropertyNames(), (Matcher)Is.is(Collections.emptySet()));
    }

    @Test(expected=NullPointerException.class)
    public void withNullEmptyInboundPropertiesFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().addInboundProperty(INBOUND_KEY, (Serializable)((Object)INBOUND_VALUE), MEDIA_TYPE, "US-ASCII").build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setInboundProperties(null);
        this.processor.doProcess((CoreEvent)originalEvent);
    }

    @Test
    public void withOutboundProperties() {
        this.processor.setOutboundProperties(this.properties(OUTBOUND_KEY, OUTBOUND_VALUE, MEDIA_TYPE, "US-ASCII"));
        CoreEvent event = this.processor.doProcess((CoreEvent)((InternalEvent)this.eventBuilder().build()));
        Message message = event.getMessage();
        MatcherAssert.assertThat((String)"Property is not as expected", (Object)((InternalMessage)message).getOutboundProperty(OUTBOUND_KEY), (Matcher)Is.is((Object)OUTBOUND_VALUE));
        this.assertDataType(((InternalMessage)message).getOutboundPropertyDataType(OUTBOUND_KEY), MEDIA_TYPE, "US-ASCII");
    }

    @Test
    public void withOutboundPropertiesFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().addOutboundProperty(OUTBOUND_KEY, (Serializable)((Object)OUTBOUND_VALUE), MEDIA_TYPE, "US-ASCII").build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        Message message = event.getMessage();
        MatcherAssert.assertThat((String)"Property is not as expected", (Object)((InternalMessage)message).getOutboundProperty(OUTBOUND_KEY), (Matcher)Is.is((Object)OUTBOUND_VALUE));
        this.assertDataType(((InternalMessage)message).getOutboundPropertyDataType(OUTBOUND_KEY), MEDIA_TYPE, "US-ASCII");
    }

    @Test
    public void withEmptyOutboundPropertiesFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().addOutboundProperty(OUTBOUND_KEY, (Serializable)((Object)OUTBOUND_VALUE), MEDIA_TYPE, "US-ASCII").build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setOutboundProperties(Collections.emptyList());
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        Message message = event.getMessage();
        MatcherAssert.assertThat((String)"Property is not as expected", (Object)((InternalMessage)message).getOutboundPropertyNames(), (Matcher)Is.is(Collections.emptySet()));
    }

    @Test(expected=NullPointerException.class)
    public void withNullOutboundPropertiesFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().addOutboundProperty(OUTBOUND_KEY, (Serializable)((Object)OUTBOUND_VALUE), MEDIA_TYPE, "US-ASCII").build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setOutboundProperties(null);
        this.processor.doProcess((CoreEvent)originalEvent);
    }

    @Test
    public void withInboundAttachments() throws IOException {
        this.processor.setInboundAttachments(this.attachments(INBOUND_ATTACHMENT_KEY, INBOUND_ATTACHMENT_VALUE, MEDIA_TYPE, "US-ASCII"));
        CoreEvent event = this.processor.doProcess((CoreEvent)((InternalEvent)this.eventBuilder().build()));
        DataHandler attachment = ((InternalMessage)event.getMessage()).getInboundAttachment(INBOUND_ATTACHMENT_KEY);
        this.assertAttachment(attachment, INBOUND_ATTACHMENT_VALUE, MEDIA_TYPE, "US-ASCII");
    }

    @Test
    public void withInboundAttachmentsFromEvent() throws IOException {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().addInboundAttachment(INBOUND_ATTACHMENT_KEY, this.buildDataHandler(INBOUND_ATTACHMENT_KEY, INBOUND_ATTACHMENT_VALUE, MEDIA_TYPE, "US-ASCII")).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        DataHandler attachment = ((InternalMessage)event.getMessage()).getInboundAttachment(INBOUND_ATTACHMENT_KEY);
        this.assertAttachment(attachment, INBOUND_ATTACHMENT_VALUE, MEDIA_TYPE, "US-ASCII");
    }

    @Test
    public void withEmptyInboundAttachmentsFromEvent() throws IOException {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().addInboundAttachment(INBOUND_ATTACHMENT_KEY, this.buildDataHandler(INBOUND_ATTACHMENT_KEY, INBOUND_ATTACHMENT_VALUE, MEDIA_TYPE, "US-ASCII")).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setInboundAttachments(Collections.emptyList());
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        Message message = event.getMessage();
        MatcherAssert.assertThat((String)"Property is not as expected", (Object)((InternalMessage)message).getInboundPropertyNames(), (Matcher)Is.is(Collections.emptySet()));
    }

    @Test(expected=NullPointerException.class)
    public void withNullInboundAttachmentsFromEvent() throws IOException {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().addInboundAttachment(INBOUND_ATTACHMENT_KEY, this.buildDataHandler(INBOUND_ATTACHMENT_KEY, INBOUND_ATTACHMENT_VALUE, MEDIA_TYPE, "US-ASCII")).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setInboundAttachments(null);
        this.processor.doProcess((CoreEvent)originalEvent);
    }

    @Test
    public void withOutboundAttachments() throws IOException {
        this.processor.setOutboundAttachments(this.attachments(OUTBOUND_ATTACHMENT_KEY, OUTBOUND_ATTACHMENT_VALUE, MEDIA_TYPE, "US-ASCII"));
        CoreEvent event = this.processor.doProcess((CoreEvent)((InternalEvent)this.eventBuilder().build()));
        DataHandler attachment = ((InternalMessage)event.getMessage()).getOutboundAttachment(OUTBOUND_ATTACHMENT_KEY);
        this.assertAttachment(attachment, OUTBOUND_ATTACHMENT_VALUE, MEDIA_TYPE, "US-ASCII");
    }

    @Test
    public void withOutboundAttachmentsFromEvent() throws IOException {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().addOutboundAttachment(OUTBOUND_ATTACHMENT_KEY, this.buildDataHandler(OUTBOUND_ATTACHMENT_KEY, OUTBOUND_ATTACHMENT_VALUE, MEDIA_TYPE, "US-ASCII")).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        DataHandler attachment = ((InternalMessage)event.getMessage()).getOutboundAttachment(OUTBOUND_ATTACHMENT_KEY);
        this.assertAttachment(attachment, OUTBOUND_ATTACHMENT_VALUE, MEDIA_TYPE, "US-ASCII");
    }

    @Test
    public void withEmptyOutboundAttachmentsFromEvent() throws IOException {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().addOutboundAttachment(OUTBOUND_ATTACHMENT_KEY, this.buildDataHandler(OUTBOUND_ATTACHMENT_KEY, OUTBOUND_ATTACHMENT_VALUE, MEDIA_TYPE, "US-ASCII")).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setOutboundAttachments(Collections.emptyList());
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        Message message = event.getMessage();
        MatcherAssert.assertThat((String)"Property is not as expected", (Object)((InternalMessage)message).getOutboundAttachmentNames(), (Matcher)Is.is(Collections.emptySet()));
    }

    @Test(expected=NullPointerException.class)
    public void withNullOutboundAttachmentsFromEvent() throws IOException {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().addOutboundAttachment(OUTBOUND_ATTACHMENT_KEY, this.buildDataHandler(OUTBOUND_ATTACHMENT_KEY, OUTBOUND_ATTACHMENT_VALUE, MEDIA_TYPE, "US-ASCII")).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setOutboundAttachments(null);
        this.processor.doProcess((CoreEvent)originalEvent);
    }

    @Test
    public void withError() {
        ErrorType errorTypeMock = (ErrorType)Mockito.mock(ErrorType.class);
        Mockito.when((Object)this.errorTypeLocatorMock.lookupComponentErrorType((ComponentIdentifier)Matchers.any(ComponentIdentifier.class), (Throwable)Matchers.any(Throwable.class))).thenReturn((Object)errorTypeMock);
        this.processor.setError(this.error(ERROR_TYPE_ID, ERROR_CAUSE_MOCK));
        CoreEvent event = this.processor.doProcess((CoreEvent)((InternalEvent)this.eventBuilder().build()));
        MatcherAssert.assertThat((String)"Error is not as expected", (Object)((Error)event.getError().get()).getErrorType(), (Matcher)Is.is((Object)errorTypeMock));
    }

    @Test
    public void withErrorFromEvent() {
        ErrorType errorTypeMock = (ErrorType)Mockito.mock(ErrorType.class);
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().withError(errorTypeMock, (Throwable)ERROR_CAUSE_MOCK).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MatcherAssert.assertThat((String)"Error is not as expected", (Object)((Error)event.getError().get()).getErrorType(), (Matcher)Is.is((Object)errorTypeMock));
    }

    @Test(expected=MunitError.class)
    public void withNonStringMediaType() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(false));
        this.processor.setPayload(this.payload(NON_STRING_MEL_EXPRESSION, null));
        this.processNonStringExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNonStringEncoding() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(false));
        this.processor.setPayload(this.payload(null, NON_STRING_MEL_EXPRESSION));
        this.processNonStringExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNonStringErrorTypeId() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setError(this.error(NON_STRING_MEL_EXPRESSION));
        this.processNonStringExpression(originalEvent);
    }

    @Ignore
    @Test(expected=MunitError.class)
    public void withNonThrowableErrorCause() throws MuleException {
        String errorTypeId = "errorType";
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processNonStringExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNonStringKeyInVariable() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setVariables(this.variables(NON_STRING_MEL_EXPRESSION, null));
        this.processNonStringExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNonStringMediaTypeInVariable() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setVariables(this.variables(null, null, NON_STRING_MEL_EXPRESSION, null));
        this.processNonStringExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNonStringEncodingInVariable() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setVariables(this.variables(null, null, null, NON_STRING_MEL_EXPRESSION));
        this.processNonStringExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNonStringKeyInInboundProperty() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setInboundProperties(this.properties(NON_STRING_MEL_EXPRESSION, null));
        this.processNonStringExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNonStringMediaTypeInInboundProperty() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setInboundProperties(this.properties(null, null, NON_STRING_MEL_EXPRESSION, null));
        this.processNonStringExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNonStringEncodingInInboundProperty() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setInboundProperties(this.properties(null, null, null, NON_STRING_MEL_EXPRESSION));
        this.processNonStringExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNonStringKeyInOutboundProperty() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setOutboundProperties(this.properties(NON_STRING_MEL_EXPRESSION, null));
        this.processNonStringExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNonStringMediaTypeInOutboundProperty() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setOutboundProperties(this.properties(null, null, NON_STRING_MEL_EXPRESSION, null));
        this.processNonStringExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNonStringEncodingInOutboundProperty() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setOutboundProperties(this.properties(null, null, null, NON_STRING_MEL_EXPRESSION));
        this.processNonStringExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNonStringKeyInSessionProperty() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setSessionProperties(this.properties(NON_STRING_MEL_EXPRESSION, null));
        this.processNonStringExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNonStringMediaTypeInSessionProperty() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setSessionProperties(this.properties(null, null, NON_STRING_MEL_EXPRESSION, null));
        this.processNonStringExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNonStringEncodingInSessionProperty() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setSessionProperties(this.properties(null, null, null, NON_STRING_MEL_EXPRESSION));
        this.processNonStringExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNonStringKeyInInboundAttachment() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setInboundAttachments(this.attachments(NON_STRING_MEL_EXPRESSION, null));
        this.processNonStringExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNonStringMediaTypeInInboundAttachment() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setInboundAttachments(this.attachments(null, null, NON_STRING_MEL_EXPRESSION, null));
        this.processNonStringExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNonStringEncodingInInboundAttachment() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setInboundAttachments(this.attachments(null, null, DEFAULT_MEDIA_TYPE, NON_STRING_MEL_EXPRESSION));
        this.processNonStringExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNonStringKeyInOutboundAttachment() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setOutboundAttachments(this.attachments(NON_STRING_MEL_EXPRESSION, null));
        this.processNonStringExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNonStringMediaTypeInOutboundAttachment() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setOutboundAttachments(this.attachments(null, null, NON_STRING_MEL_EXPRESSION, null));
        this.processNonStringExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNonStringEncodingInOutboundAttachment() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setOutboundAttachments(this.attachments(null, null, DEFAULT_MEDIA_TYPE, NON_STRING_MEL_EXPRESSION));
        this.processNonStringExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNullEvaluatedMediaTypeWhenCloningEvent() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setPayload(this.payload(NULL_MEL_EXPRESSION, null));
        this.processNullExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNullEvaluatedMediaTypeWhenNotCloningEvent() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(false));
        this.processor.setPayload(this.payload(NULL_MEL_EXPRESSION, null));
        this.processNullExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNullMediaTypeInVariable() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setVariables(this.variables(null, null, NULL_MEL_EXPRESSION, null));
        this.processNullExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNullMediaTypeInSessionProperty() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setSessionProperties(this.properties(null, null, NULL_MEL_EXPRESSION, null));
        this.processNullExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNullMediaTypeInInboundProperty() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setInboundProperties(this.properties(null, null, NULL_MEL_EXPRESSION, null));
        this.processNullExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNullMediaTypeInOutboundProperty() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setOutboundProperties(this.properties(null, null, NULL_MEL_EXPRESSION, null));
        this.processNullExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNullMediaTypeInInboundAttachment() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setInboundAttachments(this.attachments(null, null, NULL_MEL_EXPRESSION, null));
        this.processNullExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNullMediaTypeInOutboundAttachment() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setOutboundAttachments(this.attachments(null, null, NULL_MEL_EXPRESSION, null));
        this.processNullExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidMediaTypeExpression() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(false));
        this.processor.setPayload(this.payload(INVALID_MEL_EXPRESSION, null));
        this.processInvalidExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidEncodingExpression() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(false));
        this.processor.setPayload(this.payload(null, INVALID_MEL_EXPRESSION));
        this.processInvalidExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidAttributesExpression() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setAttributes(this.attributes(INVALID_MEL_EXPRESSION));
        this.processInvalidExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidErrorTypeIdExpression() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setError(this.error(INVALID_MEL_EXPRESSION));
        this.processInvalidExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidKeyExpressionInVariable() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setVariables(this.variables(INVALID_MEL_EXPRESSION, null));
        this.processInvalidExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidMediaTypeExpressionInVariable() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setVariables(this.variables(null, null, INVALID_MEL_EXPRESSION, null));
        this.processInvalidExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidEncodingExpressionInVariable() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setVariables(this.variables(null, null, null, INVALID_MEL_EXPRESSION));
        this.processInvalidExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidKeyExpressionInInboundProperty() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setInboundProperties(this.properties(INVALID_MEL_EXPRESSION, null));
        this.processInvalidExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidMediaTypeExpressionInInboundProperty() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setInboundProperties(this.properties(null, null, INVALID_MEL_EXPRESSION, null));
        this.processInvalidExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidEncodingExpressionInInboundProperty() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setInboundProperties(this.properties(null, null, null, INVALID_MEL_EXPRESSION));
        this.processInvalidExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidKeyExpressionInOutboundProperty() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setOutboundProperties(this.properties(INVALID_MEL_EXPRESSION, null));
        this.processInvalidExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidMediaTypeExpressionInOutboundProperty() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setOutboundProperties(this.properties(null, null, INVALID_MEL_EXPRESSION, null));
        this.processInvalidExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidEncodingExpressionInOutboundProperty() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setOutboundProperties(this.properties(null, null, null, INVALID_MEL_EXPRESSION));
        this.processInvalidExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidKeyExpressionInSessionProperty() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setSessionProperties(this.properties(INVALID_MEL_EXPRESSION, null));
        this.processInvalidExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidMediaTypeExpressionInSessionProperty() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setSessionProperties(this.properties(null, null, INVALID_MEL_EXPRESSION, null));
        this.processInvalidExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidEncodingExpressionInSessionProperty() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setSessionProperties(this.properties(null, null, null, INVALID_MEL_EXPRESSION));
        this.processInvalidExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidKeyExpressionInInboundAttachment() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setInboundAttachments(this.attachments(INVALID_MEL_EXPRESSION, null));
        this.processInvalidExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidMediaTypeExpressionInInboundAttachment() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setInboundAttachments(this.attachments(null, null, INVALID_MEL_EXPRESSION, null));
        this.processInvalidExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidEncodingExpressionInInboundAttachment() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setInboundAttachments(this.attachments(null, null, DEFAULT_MEDIA_TYPE, INVALID_MEL_EXPRESSION));
        this.processInvalidExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidKeyExpressionInOutboundAttachment() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setOutboundAttachments(this.attachments(INVALID_MEL_EXPRESSION, null));
        this.processInvalidExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidMediaTypeExpressionInOutboundAttachment() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setOutboundAttachments(this.attachments(null, null, INVALID_MEL_EXPRESSION, null));
        this.processInvalidExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidEncodingExpressionInOutboundAttachment() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setOutboundAttachments(this.attachments(null, null, DEFAULT_MEDIA_TYPE, INVALID_MEL_EXPRESSION));
        this.processInvalidExpression(originalEvent);
    }

    @Test
    public void checkProcessorName() {
        SetEventProcessor mp = new SetEventProcessor();
        Assert.assertEquals((String)this.getExpectedName(), (String)mp.getProcessor());
    }

    private Payload payload(Object value) {
        Payload payload = new Payload();
        payload.setValue(value);
        return payload;
    }

    private Payload payload(String mediaType, String encoding) {
        Payload payload = new Payload();
        payload.setValue((Object)new NullObject());
        payload.setMediaType(mediaType);
        payload.setEncoding(encoding);
        return payload;
    }

    private Payload payload(Object value, String mediaType, String encoding) {
        Payload payload = new Payload();
        payload.setValue(value);
        payload.setMediaType(mediaType);
        payload.setEncoding(encoding);
        return payload;
    }

    private UntypedEventError error(String id) {
        UntypedEventError error = new UntypedEventError();
        error.setTypeId(id);
        return error;
    }

    private UntypedEventError error(String id, Throwable exception) {
        UntypedEventError error = new UntypedEventError();
        error.setTypeId(id);
        error.setCause((Object)exception);
        return error;
    }

    private EventAttributes attributes(Object value) {
        EventAttributes eventAttributes = new EventAttributes();
        eventAttributes.setValue(value);
        return eventAttributes;
    }

    private List<Property> properties(String key, Object value) {
        return this.properties(key, value, null, null);
    }

    private List<Property> properties(String key, Object value, String mediaType, String encoding) {
        Property p = new Property();
        p.setKey(key);
        p.setValue((Serializable)value);
        p.setMediaType(mediaType);
        p.setEncoding(encoding);
        return Stream.of(p).collect(Collectors.toList());
    }

    private List<Variable> variables(String key, Object value) {
        return this.variables(key, value, null, null);
    }

    private List<Variable> variables(String key, Object value, String mediaType, String encoding) {
        Variable v = new Variable();
        v.setKey(key);
        v.setValue((Serializable)value);
        v.setMediaType(mediaType);
        v.setEncoding(encoding);
        return Stream.of(v).collect(Collectors.toList());
    }

    private List<Attachment> attachments(String key, Object value) {
        return this.attachments(key, value, null, null);
    }

    private List<Attachment> attachments(String key, Object value, String mediaType, String encoding) {
        Attachment a = new Attachment();
        a.setKey(key);
        a.setValue((Serializable)value);
        a.setMediaType(mediaType);
        a.setEncoding(encoding);
        return Stream.of(a).collect(Collectors.toList());
    }

    private DataHandler buildDataHandler(String key, String value, String mediaType, String encoding) throws IOException {
        MediaType contentType = DataType.builder().mediaType(mediaType).charset(encoding).build().getMediaType();
        return IOUtils.toDataHandler((String)key, (Object)value, (MediaType)contentType);
    }

    private InternalEvent buildSimpleEvent() {
        return (InternalEvent)this.eventBuilder().build();
    }

    private EventBuilder eventBuilder() {
        return new EventBuilder(this.eventContextMock);
    }

    private void processNonStringExpression(InternalEvent event) throws MuleException {
        Mockito.when((Object)this.expressionManagerMock.isExpression(NON_STRING_MEL_EXPRESSION)).thenReturn((Object)true);
        ValidationResult validationResultMock = this.validationResult(true, "");
        Mockito.when((Object)this.expressionManagerMock.validate(NON_STRING_MEL_EXPRESSION)).thenReturn((Object)validationResultMock);
        TypedValue expressionResultMock = this.expressionResult(1);
        Mockito.when((Object)this.expressionManagerMock.evaluate(NON_STRING_MEL_EXPRESSION, (CoreEvent)event)).thenReturn((Object)expressionResultMock);
        this.processor.process((CoreEvent)event);
    }

    private void processNullExpression(InternalEvent event) throws MuleException {
        Mockito.when((Object)this.expressionManagerMock.isExpression(NULL_MEL_EXPRESSION)).thenReturn((Object)true);
        ValidationResult validationResultMock = this.validationResult(true, "");
        Mockito.when((Object)this.expressionManagerMock.validate(NULL_MEL_EXPRESSION)).thenReturn((Object)validationResultMock);
        TypedValue expressionResultMock = this.expressionResult(null);
        Mockito.when((Object)this.expressionManagerMock.evaluate(NULL_MEL_EXPRESSION, (CoreEvent)event)).thenReturn((Object)expressionResultMock);
        this.processor.process((CoreEvent)event);
    }

    private void processInvalidExpression(InternalEvent event) throws MuleException {
        Mockito.when((Object)this.expressionManagerMock.isExpression(INVALID_MEL_EXPRESSION)).thenReturn((Object)true);
        ValidationResult validationResultMock = this.validationResult(false, "Invalid");
        Mockito.when((Object)this.expressionManagerMock.validate(INVALID_MEL_EXPRESSION)).thenReturn((Object)validationResultMock);
        this.processor.process((CoreEvent)event);
    }

    private void assertDataType(DataType dataType, String mediaType, String encoding) {
        DataType expectedDataType = DataType.builder((DataType)DataType.JSON_STRING).charset(Charset.forName(encoding)).build();
        this.assertDataType(dataType, mediaType, encoding, expectedDataType);
    }

    private void assertDataType(DataType dataType, String mediaType, String encoding, DataType expectedType) {
        DataType expected = DataType.builder().mediaType(mediaType).charset(encoding).build();
        MatcherAssert.assertThat((String)"DataType is not as expected", (Object)dataType, (Matcher)Is.is((Object)expectedType));
        MatcherAssert.assertThat((String)"DataType is not as expected", (Object)dataType.getMediaType().getPrimaryType(), (Matcher)Is.is((Object)expected.getMediaType().getPrimaryType()));
        MatcherAssert.assertThat((String)"DataType is not as expected", (Object)dataType.getMediaType().getSubType(), (Matcher)Is.is((Object)expected.getMediaType().getSubType()));
        MatcherAssert.assertThat((String)"DataType is not as expected", dataType.getMediaType().getCharset().get(), (Matcher)Is.is((Object)Charset.forName(encoding)));
    }

    private void assertAttachment(DataHandler attachment, String value, String mediaType, String encoding) throws IOException {
        InputStream inputStream = attachment.getDataSource().getInputStream();
        int n = inputStream.available();
        byte[] bytes = new byte[n];
        inputStream.read(bytes, 0, n);
        String s = new String(bytes);
        MatcherAssert.assertThat((String)"Attachment content is not as expected", (Object)s, (Matcher)Is.is((Object)value));
        MatcherAssert.assertThat((Object)attachment.getDataSource().getContentType(), (Matcher)Is.is((Object)(mediaType + "; charset=" + encoding)));
    }

    private void mockEvaluateIfExpression(String exp, String expResult) {
        Mockito.when((Object)this.expressionManagerMock.isExpression(exp)).thenReturn((Object)true);
        Mockito.when((Object)this.expressionManagerMock.isValid(exp)).thenReturn((Object)true);
        ValidationResult validationResultMock = this.validationResult(true, "");
        Mockito.when((Object)this.expressionManagerMock.validate(exp)).thenReturn((Object)validationResultMock);
        TypedValue expressionResultMock = this.expressionResult(expResult);
        Mockito.when((Object)this.expressionManagerMock.evaluate((String)Matchers.eq((Object)exp), (CoreEvent)Matchers.any(CoreEvent.class))).thenReturn((Object)expressionResultMock);
    }

    private void verifyEvaluateIfExpression(String exp) {
        ((ExtendedExpressionManager)Mockito.verify((Object)this.expressionManagerMock, (VerificationMode)Mockito.times((int)1))).isExpression(exp);
        ((ExtendedExpressionManager)Mockito.verify((Object)this.expressionManagerMock, (VerificationMode)Mockito.times((int)1))).validate(exp);
        ((ExtendedExpressionManager)Mockito.verify((Object)this.expressionManagerMock, (VerificationMode)Mockito.times((int)1))).evaluate((String)Matchers.eq((Object)exp), (CoreEvent)Matchers.any(CoreEvent.class));
    }

    private TypedValue expressionResult(Object value) {
        TypedValue expressionResult = new TypedValue(value, DataType.fromObject((Object)value));
        return expressionResult;
    }

    private ValidationResult validationResult(Boolean success, String error) {
        ValidationResult validationResultMock = (ValidationResult)Mockito.mock(ValidationResult.class);
        Mockito.when((Object)validationResultMock.isSuccess()).thenReturn((Object)success);
        Mockito.when((Object)validationResultMock.errorMessage()).thenReturn(Optional.of(error));
        return validationResultMock;
    }

    protected String getExpectedName() {
        return "set";
    }
}

