/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.model.builders;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.protocol.listeners.SuiteRunEventListener;
import org.mule.munit.runner.flow.AfterSuite;
import org.mule.munit.runner.flow.AfterTest;
import org.mule.munit.runner.flow.BeforeSuite;
import org.mule.munit.runner.flow.BeforeTest;
import org.mule.munit.runner.flow.TestFlow;
import org.mule.munit.runner.model.Suite;
import org.mule.munit.runner.model.Test;
import org.mule.munit.runner.model.builders.TestRunFilter;
import org.mule.munit.runner.processors.MunitModule;
import org.mule.munit.runner.remote.api.notifiers.DummySuiteRunEventListener;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.config.api.LazyComponentInitializer;

public class SuiteBuilder {
    protected String suitePath;
    private ConfigurationComponentLocator configurationComponentLocator;
    private LazyComponentInitializer lazyComponentInitializer;
    protected Set<String> tags;
    protected List<String> testNames;
    protected SuiteRunEventListener suiteRunEventListener;

    public SuiteBuilder(String suitePath, ConfigurationComponentLocator configurationComponentLocator, LazyComponentInitializer lazyComponentInitializer) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)suitePath), (Object)"The suitePath must not be null nor empty");
        Preconditions.checkNotNull((Object)configurationComponentLocator, (Object)"The configuration component locator must not be null");
        Preconditions.checkNotNull((Object)lazyComponentInitializer, (Object)"The lazyComponentInitializer must not be null");
        this.suitePath = suitePath;
        this.suiteRunEventListener = new DummySuiteRunEventListener();
        this.configurationComponentLocator = configurationComponentLocator;
        this.lazyComponentInitializer = lazyComponentInitializer;
    }

    public SuiteBuilder withTestNames(List<String> testNames) {
        this.testNames = testNames;
        return this;
    }

    public SuiteBuilder withTags(Set<String> tags) {
        this.tags = tags;
        return this;
    }

    public SuiteBuilder withSuiteRunnerEventListener(SuiteRunEventListener suiteRunEventListener) {
        Preconditions.checkNotNull((Object)suiteRunEventListener, (Object)"The suiteRunEventListener must not be null");
        this.suiteRunEventListener = suiteRunEventListener;
        return this;
    }

    public Suite build() {
        MunitModule munitModule = this.lookupMunitModule();
        Suite suite = new Suite(this.suitePath);
        suite.setSuiteRunEventListener(this.suiteRunEventListener);
        suite.setBeforeSuite(this.lookupBeforeSuite());
        this.createTests(munitModule).forEach(suite::addTest);
        suite.setAfterSuite(this.lookupAfterSuite());
        return suite;
    }

    private List<Test> createTests(MunitModule munitModule) {
        BeforeTest before = this.lookupBeforeTest();
        Collection<TestFlow> testFlows = this.lookupTests();
        AfterTest after = this.lookupAfterTest();
        TestRunFilter filter = new TestRunFilter();
        ArrayList<Test> tests = new ArrayList<Test>();
        tests.addAll(testFlows.stream().filter(testFlow -> filter.shouldRunTest((TestFlow)((Object)testFlow), this.testNames, this.tags)).map(testFlow -> this.test(before, (TestFlow)((Object)testFlow), after, munitModule)).collect(Collectors.toList()));
        return tests;
    }

    protected Test test(BeforeTest beforeTest, TestFlow test, AfterTest afterTest, MunitModule munitModule) {
        return new Test(beforeTest, test, afterTest, munitModule);
    }

    private MunitModule lookupMunitModule() {
        ComponentIdentifier componentIdentifier = ComponentIdentifier.buildFromStringRepresentation((String)"munit:config");
        this.lazyComponentInitializer.initializeComponents(componentLocation -> componentLocation.getFileName().map(file -> this.suitePath.equals(file)).orElse(false));
        List components = this.configurationComponentLocator.find(componentIdentifier);
        if (!components.isEmpty()) {
            return (MunitModule)((Object)components.get(0));
        }
        throw new IllegalStateException("Missing element [" + componentIdentifier + "] in file " + this.suitePath);
    }

    private BeforeSuite lookupBeforeSuite() {
        String componentIdentifier = "munit:before-suite";
        List components = this.configurationComponentLocator.find(ComponentIdentifier.buildFromStringRepresentation((String)componentIdentifier));
        if (!components.isEmpty()) {
            return (BeforeSuite)((Object)components.get(0));
        }
        return null;
    }

    private AfterSuite lookupAfterSuite() {
        String componentIdentifier = "munit:after-suite";
        List components = this.configurationComponentLocator.find(ComponentIdentifier.buildFromStringRepresentation((String)componentIdentifier));
        if (!components.isEmpty()) {
            return (AfterSuite)((Object)components.get(0));
        }
        return null;
    }

    private BeforeTest lookupBeforeTest() {
        String componentIdentifier = "munit:before-test";
        List components = this.configurationComponentLocator.find(ComponentIdentifier.buildFromStringRepresentation((String)componentIdentifier));
        if (!components.isEmpty()) {
            return (BeforeTest)((Object)components.get(0));
        }
        return null;
    }

    private AfterTest lookupAfterTest() {
        String componentIdentifier = "munit:after-test";
        List components = this.configurationComponentLocator.find(ComponentIdentifier.buildFromStringRepresentation((String)componentIdentifier));
        if (!components.isEmpty()) {
            return (AfterTest)((Object)components.get(0));
        }
        return null;
    }

    private Collection<TestFlow> lookupTests() {
        String componentIdentifier = "munit:test";
        List components = this.configurationComponentLocator.find(ComponentIdentifier.buildFromStringRepresentation((String)componentIdentifier));
        return components.stream().map(annotatedObject -> (TestFlow)((Object)annotatedObject)).collect(Collectors.toList());
    }
}

