/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.model;

import org.mule.munit.common.event.EventBuilder;
import org.mule.munit.common.util.StackTraceUtil;
import org.mule.munit.runner.flow.AfterTest;
import org.mule.munit.runner.flow.BeforeTest;
import org.mule.munit.runner.flow.SimpleFlow;
import org.mule.munit.runner.flow.TestFlow;
import org.mule.munit.runner.model.TestResult;
import org.mule.munit.runner.processors.MunitModule;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.privileged.exception.EventProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Test {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected BeforeTest before;
    protected AfterTest after;
    protected TestFlow test;
    protected MunitModule munitModule;

    public Test(BeforeTest before, TestFlow test, AfterTest after, MunitModule munitModule) {
        this.before = before;
        this.test = test;
        this.after = after;
        this.munitModule = munitModule;
    }

    public String getName() {
        return this.test.getName();
    }

    public String getDescription() {
        return this.test.getDescription();
    }

    public boolean isIgnore() {
        return this.test.isIgnore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult run() {
        TestResult result = new TestResult(this.getName(), this.getDescription());
        this.logger.debug("About to run MUnit test: " + this.getName());
        if (this.test.isIgnore()) {
            this.logger.debug("MUnit test: " + this.getName() + " is ignored it won't run.");
            result.setSkipped();
            result.setElapsedTime(0L);
            return result;
        }
        long testStartTime = System.currentTimeMillis();
        Event event = new EventBuilder(this.test.getLocation()).withPayload((Object)"").build();
        try {
            event = this.runBefore(event);
            event = this.test.run(event);
        }
        catch (AssertionError t) {
            result.setFailure(StackTraceUtil.getStackTrace((Throwable)((Object)t)));
        }
        catch (Throwable e) {
            result.setError(StackTraceUtil.getStackTrace((Throwable)e));
            if (e instanceof EventProcessingException) {
                event = ((EventProcessingException)e).getEvent();
            }
        }
        finally {
            this.munitModule.reset();
            this.runAfter(result, event);
        }
        result.setElapsedTime(System.currentTimeMillis() - testStartTime);
        return result;
    }

    private Event runBefore(Event event) throws Throwable {
        this.logger.debug("Running before test scopes...");
        try {
            return this.run(event, this.before);
        }
        catch (MuleException | MuleRuntimeException e) {
            throw this.handleRunBeforeFailure((Exception)e, e.getCause());
        }
    }

    private void runAfter(TestResult result, Event event) {
        this.logger.debug("Running after test scopes...");
        try {
            this.run(event, this.after);
        }
        catch (MuleException | MuleRuntimeException e) {
            this.handleRunAfterFailure(result, (Exception)e, e.getCause());
        }
    }

    private void handleRunAfterFailure(TestResult result, Exception e, Throwable cause) {
        if (null != cause && cause instanceof AssertionError) {
            result.setFailure(StackTraceUtil.getStackTrace((Throwable)cause));
        } else {
            result.setError(StackTraceUtil.getStackTrace((Throwable)e));
        }
    }

    private Throwable handleRunBeforeFailure(Exception e, Throwable cause) throws Throwable {
        if (null != cause && cause.getClass().isAssignableFrom(AssertionError.class)) {
            return cause;
        }
        return e;
    }

    protected Event run(Event event, SimpleFlow flow) throws MuleException {
        if (flow != null) {
            event = (Event)flow.execute(event).join();
        }
        return event;
    }
}

