/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.model;

import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.munit.common.event.EventBuilder;
import org.mule.munit.common.util.StackTraceUtil;
import org.mule.munit.runner.flow.AfterTest;
import org.mule.munit.runner.flow.BeforeTest;
import org.mule.munit.runner.flow.SimpleFlow;
import org.mule.munit.runner.flow.TestFlow;
import org.mule.munit.runner.model.TestResult;
import org.mule.munit.runner.processors.MunitModule;
import org.mule.runtime.api.component.execution.ComponentExecutionException;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.privileged.exception.EventProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Test {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected BeforeTest before;
    protected AfterTest after;
    protected TestFlow test;
    protected MunitModule munitModule;

    public Test(BeforeTest before, TestFlow test, AfterTest after, MunitModule munitModule) {
        this.before = before;
        this.test = test;
        this.after = after;
        this.munitModule = munitModule;
    }

    public String getName() {
        return this.test.getName();
    }

    public String getDescription() {
        return this.test.getDescription();
    }

    public boolean isIgnore() {
        return this.test.isIgnore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult run() {
        TestResult result = new TestResult(this.getName(), this.getDescription());
        this.logger.debug("About to run MUnit test: " + this.getName());
        if (this.test.isIgnore()) {
            this.logger.debug("MUnit test: " + this.getName() + " is ignored it won't run.");
            result.setSkipped();
            result.setElapsedTime(0L);
            return result;
        }
        long testStartTime = System.currentTimeMillis();
        Event event = new EventBuilder(this.test.getLocation()).withPayload((Object)"").build();
        try {
            event = this.runBefore(event);
            event = this.test.run(event);
        }
        catch (Throwable e) {
            this.handleTestFailure(result, this.getCause(e));
            event = this.getEventIfPresent(event, e);
        }
        finally {
            this.munitModule.reset();
            this.runAfter(result, event);
        }
        result.setElapsedTime(System.currentTimeMillis() - testStartTime);
        return result;
    }

    private Event runBefore(Event event) throws Throwable {
        this.logger.debug("Running before test scopes...");
        try {
            return this.run(event, this.before);
        }
        catch (MuleException | MuleRuntimeException e) {
            throw this.getCause(e);
        }
    }

    private void runAfter(TestResult result, Event event) {
        this.logger.debug("Running after test scopes...");
        try {
            this.run(event, this.after);
        }
        catch (Throwable e) {
            this.handleTestFailure(result, this.getCause(e));
        }
    }

    private void handleTestFailure(TestResult result, Throwable cause) {
        if (cause instanceof AssertionError) {
            result.setFailure(StackTraceUtil.getStackTrace((Throwable)cause));
        } else {
            result.setError(StackTraceUtil.getStackTrace((Throwable)cause));
        }
    }

    protected Event run(Event event, SimpleFlow flow) throws Throwable {
        if (flow != null) {
            try {
                event = (Event)flow.execute(event).get();
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }
        return event;
    }

    private Event getEventIfPresent(Event event, Throwable e) {
        if (e instanceof EventProcessingException) {
            event = ((EventProcessingException)e).getEvent();
        }
        if (e instanceof ComponentExecutionException) {
            event = ((ComponentExecutionException)e).getEvent();
        }
        return event;
    }

    private Throwable getCause(Throwable e) {
        return Optional.ofNullable(ExceptionUtils.getRootCause((Throwable)e)).orElse(e);
    }
}

