/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.model.builders;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.munit.runner.flow.TestFlow;
import org.mule.munit.runner.model.builders.TestRunFilter;

public class TestRunFilterTest {
    private TestFlow testFlowMock;
    private TestRunFilter testRunFilter;

    @Before
    public void setUp() {
        this.testFlowMock = (TestFlow)Mockito.mock(TestFlow.class);
        this.testRunFilter = new TestRunFilter();
    }

    @Test
    public void munitTestNameMatchesShouldNotIgnore() {
        Mockito.when((Object)this.testFlowMock.getName()).thenReturn((Object)"test_name");
        Boolean shouldRun = this.testRunFilter.shouldRunTest(this.testFlowMock, Arrays.asList("test_name"), null);
        MatcherAssert.assertThat((Object)shouldRun, (Matcher)Is.is((Object)true));
    }

    @Test
    public void munitTestNameDoesNotMatchShouldIgnore() {
        Mockito.when((Object)this.testFlowMock.getName()).thenReturn((Object)"test_name");
        Boolean shouldRun = this.testRunFilter.shouldRunTest(this.testFlowMock, Arrays.asList("not_matching_test_name"), null);
        MatcherAssert.assertThat((Object)shouldRun, (Matcher)Is.is((Object)false));
    }

    @Test
    public void munitTestDoesNotMatchTagsShouldIgnore() {
        Mockito.when((Object)this.testFlowMock.getName()).thenReturn((Object)"test_name");
        Mockito.when((Object)this.testFlowMock.getTags()).thenReturn(Collections.singleton("oneTag"));
        Boolean shouldRun = this.testRunFilter.shouldRunTest(this.testFlowMock, Collections.emptyList(), Collections.singleton("otherTag"));
        MatcherAssert.assertThat((Object)shouldRun, (Matcher)Is.is((Object)false));
    }

    @Test
    public void munitTestMatchesSameTagShouldNotIgnore() {
        Mockito.when((Object)this.testFlowMock.getName()).thenReturn((Object)"test_name");
        Mockito.when((Object)this.testFlowMock.getTags()).thenReturn(Collections.singleton("oneTag"));
        Boolean shouldRun = this.testRunFilter.shouldRunTest(this.testFlowMock, Collections.emptyList(), Collections.singleton("oneTag"));
        MatcherAssert.assertThat((Object)shouldRun, (Matcher)Is.is((Object)true));
    }

    @Test
    public void munitTestMatchesSameTrimmedTagShouldNotIgnore() {
        Mockito.when((Object)this.testFlowMock.getName()).thenReturn((Object)"test_name");
        Mockito.when((Object)this.testFlowMock.getTags()).thenReturn(Collections.singleton(" oneTag "));
        Boolean shouldRun = this.testRunFilter.shouldRunTest(this.testFlowMock, Collections.emptyList(), Collections.singleton("oneTag"));
        MatcherAssert.assertThat((Object)shouldRun, (Matcher)Is.is((Object)true));
    }

    @Test
    public void testMatchesOneOfTheTagsShouldNotIgnore() {
        Mockito.when((Object)this.testFlowMock.getName()).thenReturn((Object)"test_name");
        Mockito.when((Object)this.testFlowMock.getTags()).thenReturn(Collections.singleton("oneTag"));
        Boolean shouldRun = this.testRunFilter.shouldRunTest(this.testFlowMock, Collections.emptyList(), new HashSet<String>(Arrays.asList("oneTag", "otherTag")));
        MatcherAssert.assertThat((Object)shouldRun, (Matcher)Is.is((Object)true));
    }

    @Test
    public void testMatchesOneTagButHasOthersShouldNotIgnore() {
        Mockito.when((Object)this.testFlowMock.getName()).thenReturn((Object)"test_name");
        Mockito.when((Object)this.testFlowMock.getTags()).thenReturn(new HashSet<String>(Arrays.asList("oneTag", "otherTag")));
        Boolean shouldRun = this.testRunFilter.shouldRunTest(this.testFlowMock, Collections.emptyList(), Collections.singleton("oneTag"));
        MatcherAssert.assertThat((Object)shouldRun, (Matcher)Is.is((Object)true));
    }

    @Test
    public void testMatchesOneCaseInsensitiveShouldNotIgnore() {
        Mockito.when((Object)this.testFlowMock.getName()).thenReturn((Object)"test_name");
        Mockito.when((Object)this.testFlowMock.getTags()).thenReturn(new HashSet<String>(Arrays.asList("oneTag")));
        Boolean shouldRun = this.testRunFilter.shouldRunTest(this.testFlowMock, Collections.emptyList(), Collections.singleton("ONETAG"));
        MatcherAssert.assertThat((Object)shouldRun, (Matcher)Is.is((Object)true));
    }

    @Test
    public void testMatchesEmptyTagListShouldNotIgnore() {
        Mockito.when((Object)this.testFlowMock.getName()).thenReturn((Object)"test_name");
        Mockito.when((Object)this.testFlowMock.getTags()).thenReturn(new HashSet<String>(Arrays.asList("oneTag", "otherTag")));
        Boolean shouldRun = this.testRunFilter.shouldRunTest(this.testFlowMock, Collections.emptyList(), Collections.emptySet());
        MatcherAssert.assertThat((Object)shouldRun, (Matcher)Is.is((Object)true));
    }

    @Test
    public void testWithEmptyListMatchesNoTagTokenShouldNotIgnore() {
        Mockito.when((Object)this.testFlowMock.getName()).thenReturn((Object)"test_name");
        Mockito.when((Object)this.testFlowMock.getTags()).thenReturn(Collections.emptySet());
        Boolean shouldRun = this.testRunFilter.shouldRunTest(this.testFlowMock, Collections.emptyList(), Collections.singleton("NO_TAG"));
        MatcherAssert.assertThat((Object)shouldRun, (Matcher)Is.is((Object)true));
    }

    @Test
    public void testBuildMunitTestsWithEmptyListMatchesTrimmedNoTagTokenShouldNotIgnore() {
        Mockito.when((Object)this.testFlowMock.getName()).thenReturn((Object)"test_name");
        Mockito.when((Object)this.testFlowMock.getTags()).thenReturn(Collections.emptySet());
        Boolean shouldRun = this.testRunFilter.shouldRunTest(this.testFlowMock, Collections.emptyList(), Collections.singleton(" NO_TAG "));
        MatcherAssert.assertThat((Object)shouldRun, (Matcher)Is.is((Object)true));
    }
}

