/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.remote.api.server;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.munit.common.protocol.message.RunMessage;
import org.mule.munit.common.util.FreePortFinder;
import org.mule.munit.runner.remote.api.server.RunnerServer;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;

public class RunnerServerTest {
    private static final int MIN_PORT_NUMBER = 40000;
    private static final int MAX_PORT_NUMBER = 50000;
    private RunnerServer runnerServer;
    private Scheduler schedulerMock;
    private Gson gson = new Gson();
    private int port;
    private FreePortFinder freePortFinder = new FreePortFinder(40000, 50000);

    @Before
    public void setUp() throws IOException, InitialisationException, ClassNotFoundException {
        this.runnerServer = (RunnerServer)Mockito.spy((Object)new RunnerServer());
        Registry muleRegistry = (Registry)Mockito.mock(Registry.class);
        SchedulerService schedulerServiceMock = (SchedulerService)Mockito.mock(SchedulerService.class);
        this.schedulerMock = (Scheduler)Mockito.mock(Scheduler.class);
        Mockito.when((Object)schedulerServiceMock.ioScheduler()).thenReturn((Object)this.schedulerMock);
        this.runnerServer.setSchedulerService(schedulerServiceMock);
        this.runnerServer.setComponentLocator((ConfigurationComponentLocator)Mockito.mock(ConfigurationComponentLocator.class));
        ((RunnerServer)Mockito.doNothing().when((Object)this.runnerServer)).handleClientMessage((ObjectInput)org.mockito.Matchers.any(ObjectInput.class), (ObjectOutput)org.mockito.Matchers.any(ObjectOutput.class));
        this.port = this.freePortFinder.find();
    }

    @Test
    public void initialiseSchedulesRunnerServer() throws MuleException {
        this.runnerServer.initialise();
        this.runnerServer.start();
        ((Scheduler)Mockito.verify((Object)this.schedulerMock)).submit((Runnable)this.runnerServer);
    }

    @Test
    public void receivesMessageFromClient() throws IOException, ClassNotFoundException, InterruptedException {
        System.setProperty("munit.server.port", String.valueOf(this.port));
        new Thread((Runnable)this.runnerServer).start();
        Thread.sleep(500L);
        this.sendWithClient();
        Thread.sleep(500L);
        ((RunnerServer)Mockito.verify((Object)this.runnerServer)).handleClientMessage((ObjectInput)org.mockito.Matchers.any(ObjectInput.class), (ObjectOutput)org.mockito.Matchers.any(ObjectOutput.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidPort() throws IOException, ClassNotFoundException {
        System.setProperty("munit.server.port", "-1");
        this.runnerServer.run();
    }

    @Test
    public void ioExceptionStopsRun() throws IOException, ClassNotFoundException {
        IOException toBeThrown = new IOException();
        ((RunnerServer)Mockito.doThrow((Throwable)toBeThrown).when((Object)this.runnerServer)).createServerSocket();
        this.runnerServer.run();
        MatcherAssert.assertThat((Object)this.runnerServer.isKeepRunning(), (Matcher)Matchers.equalTo((Object)false));
        ((RunnerServer)Mockito.verify((Object)this.runnerServer, (VerificationMode)Mockito.never())).handleClientMessage((ObjectInput)org.mockito.Matchers.any(ObjectInput.class), (ObjectOutput)org.mockito.Matchers.any(ObjectOutput.class));
    }

    @Test
    public void socketTimeoutExceptionStopsRun() throws IOException, ClassNotFoundException {
        ServerSocket socketMock = (ServerSocket)Mockito.mock(ServerSocket.class);
        SocketTimeoutException toBeThrown = new SocketTimeoutException();
        ((RunnerServer)Mockito.doReturn((Object)socketMock).when((Object)this.runnerServer)).createServerSocket();
        ((ServerSocket)Mockito.doThrow((Throwable)toBeThrown).when((Object)socketMock)).accept();
        this.runnerServer.run();
        MatcherAssert.assertThat((Object)this.runnerServer.isKeepRunning(), (Matcher)Matchers.equalTo((Object)false));
        ((RunnerServer)Mockito.verify((Object)this.runnerServer, (VerificationMode)Mockito.never())).handleClientMessage((ObjectInput)org.mockito.Matchers.any(ObjectInput.class), (ObjectOutput)org.mockito.Matchers.any(ObjectOutput.class));
    }

    @After
    public void tearDown() throws MuleException {
        this.runnerServer.stop();
        this.runnerServer.dispose();
    }

    private void sendWithClient() throws IOException {
        RunnerClient runnerClient = new RunnerClient(this.port);
        runnerClient.sendMessage(64, (Map<String, String>)ImmutableMap.of((Object)"key", (Object)"value"));
    }

    private class RunnerClient {
        private ObjectOutputStream out;

        RunnerClient(int port) throws IOException {
            Socket requestSocket = new Socket("localhost", port);
            this.out = new ObjectOutputStream(requestSocket.getOutputStream());
        }

        void sendMessage(Integer id, Map<String, String> params) throws IOException {
            this.out.writeObject(RunnerServerTest.this.gson.toJson((Object)new RunMessage(id, params)));
            this.out.flush();
        }
    }
}

