/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.component;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.munit.common.util.FileUtils;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.lifecycle.Disposable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryDirectoryRule
implements Disposable {
    @Inject
    protected ConfigurationProperties configurationProperties;
    private static final Logger logger = LoggerFactory.getLogger(TemporaryDirectoryRule.class);
    protected static final String TEMP_DIRECTORY_PROPERTY = "munit.temporary.directory";

    public void cleanTemporaryDirectory() {
        this.getTemporaryDirectory().ifPresent(tempDir -> {
            try {
                FileUtils.cleanDirectory((File)new File((String)tempDir));
            }
            catch (IOException e) {
                logger.error("An error occurred when cleaning temporary folder {}", tempDir, (Object)e);
            }
        });
    }

    public void dispose() {
        this.getTemporaryDirectory().ifPresent(tempDir -> {
            try {
                FileUtils.deleteDirectory((File)new File((String)tempDir));
            }
            catch (IOException e) {
                logger.error("An error occurred when deleting temporary folder {}", tempDir, (Object)e);
            }
        });
    }

    private Optional<String> getTemporaryDirectory() {
        return this.configurationProperties.resolveStringProperty(TEMP_DIRECTORY_PROPERTY);
    }
}

