/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.flow;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import junit.framework.Assert;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.ComparisonFailure;
import org.mule.munit.common.exception.MunitError;
import org.mule.munit.common.util.MunitExpressionWrapper;
import org.mule.munit.runner.processors.EnableFlowSources;
import org.mule.munit.runner.processors.MunitModule;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.execution.ComponentExecutionException;
import org.mule.runtime.api.component.execution.ExecutionResult;
import org.mule.runtime.api.component.execution.InputEvent;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.Pipeline;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.exception.SingleErrorTypeMatcher;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.privileged.processor.CompositeProcessorChainRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFlow
extends CompositeProcessorChainRouter {
    public static final String MUNIT_TEST_TIMEOUT_PROPERTY = "munit.test.timeout";
    protected static final transient Logger logger = LoggerFactory.getLogger(TestFlow.class);
    private static final int DEFAULT_TIMEOUT = 60000;
    @Inject
    private ErrorTypeRepository errorTypeRepository;
    @Inject
    private ExtendedExpressionManager extendedExpressionManager;
    @Inject
    protected Optional<MunitModule> munitModule;
    @Inject
    private SchedulerService schedulerService;
    private static final String TAG_SEPARATOR = ",";
    public static final String NO_TAG_TOKEN = "NO_TAG";
    private String description;
    private boolean ignore;
    private String expectedErrorType;
    private String expectedException;
    private String tags;
    private EnableFlowSources enableFlowSources;
    private List<MessageSource> flowSources = Collections.emptyList();
    private Scheduler scheduler;

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public String getExpectedErrorType() {
        return this.expectedErrorType;
    }

    public void setExpectedErrorType(String expectedErrorType) {
        this.expectedErrorType = expectedErrorType;
    }

    public String getExpectedException() {
        return this.expectedException;
    }

    public void setExpectedException(String expectedException) {
        this.expectedException = expectedException;
    }

    public Set<String> getTags() {
        if (StringUtils.isBlank((CharSequence)this.tags)) {
            return Collections.emptySet();
        }
        Set<String> tagSet = Stream.of(this.tags.split(TAG_SEPARATOR)).collect(Collectors.toSet());
        if (tagSet.stream().anyMatch(tag -> tag.trim().equalsIgnoreCase(NO_TAG_TOKEN))) {
            throw new IllegalArgumentException("The tag 'NO_TAG' is invalid since it's a keyword.");
        }
        return tagSet;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public EnableFlowSources getEnableFlowSources() {
        return this.enableFlowSources;
    }

    public void setEnableFlowSources(EnableFlowSources enableFlowSources) {
        this.enableFlowSources = enableFlowSources;
        this.flowSources = this.getFlowSources(enableFlowSources);
        if (this.munitModule.isPresent() && !this.isIgnore()) {
            this.munitModule.get().addEnableFlowSources(enableFlowSources);
        }
    }

    public String getName() {
        return this.getLocation().getRootContainerName();
    }

    public Event run(Event event) throws Throwable {
        try {
            Event resultingEvent = this.doExecute(event);
            if (this.isExpectingFailure()) {
                StringBuilder builder = new StringBuilder();
                builder.append("The test: ").append(this.getName()).append(" was expecting a failure - ").append("Error ID: ").append(this.expectedErrorType).append(" - Exception: ").append(this.expectedException).append(" but it didn't fail");
                Assert.fail((String)builder.toString());
            }
            return resultingEvent;
        }
        catch (ExecutionException executionException) {
            if (!(executionException.getCause() instanceof ComponentExecutionException)) {
                throw executionException;
            }
            ComponentExecutionException componentExecutionException = (ComponentExecutionException)executionException.getCause();
            Throwable cause = componentExecutionException.getCause();
            Event exceptionEvent = componentExecutionException.getEvent();
            if (this.isExpectingFailure()) {
                Optional<ComparisonFailure> comparisonFailure = this.validateExpected(cause, exceptionEvent);
                if (comparisonFailure.isPresent()) {
                    throw new AssertionError(comparisonFailure.get().getMessage(), cause);
                }
                return exceptionEvent;
            }
            throw cause != null && cause instanceof AssertionError ? cause : executionException;
        }
    }

    public void startFlowSources() {
        try {
            LifecycleUtils.startIfNeeded(this.flowSources);
        }
        catch (MuleException e) {
            throw new MunitError("An error occurred while starting flow sources", (Throwable)e);
        }
    }

    public void stopFlowSources() {
        try {
            LifecycleUtils.stopIfNeeded(this.flowSources);
        }
        catch (MuleException e) {
            throw new MunitError("An error occurred while stopping flow sources", (Throwable)e);
        }
    }

    protected Event doExecute(Event event) throws InterruptedException, ExecutionException {
        Either submitionResult;
        try {
            submitionResult = (Either)this.scheduler.submit((Callable)new ExceptionAwareCallable(event)).get(this.getTimeout().intValue(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new MunitError(String.format("The test '%s' timeout after %s milliseconds", this.getName(), this.getTimeout()));
        }
        if (submitionResult.isRight()) {
            Throwable throwable = (Throwable)submitionResult.getRight();
            if (throwable instanceof InterruptedException) {
                throw (InterruptedException)throwable;
            }
            if (throwable instanceof ExecutionException) {
                throw (ExecutionException)throwable;
            }
            throw new MunitError("Unknown error occurred executing the test", throwable);
        }
        ExecutionResult executionResult = (ExecutionResult)submitionResult.getLeft();
        executionResult.complete();
        return executionResult.getEvent();
    }

    protected boolean isExpectingFailure() {
        return StringUtils.isNotBlank((CharSequence)this.expectedErrorType) || StringUtils.isNotBlank((CharSequence)this.expectedException);
    }

    protected Optional<ComparisonFailure> validateExpected(Throwable exception, Event exceptionEvent) throws MunitError {
        if (!this.isExpectingFailure()) {
            return Optional.empty();
        }
        ComparisonFailure failure = null;
        if (StringUtils.isNotBlank((CharSequence)this.expectedErrorType) && !this.isErrorIdExpected(exceptionEvent)) {
            String actualErrorType = ((Error)exceptionEvent.getError().get()).getErrorType().toString();
            failure = new ComparisonFailure("The error ID thrown does not match the expected one. ", this.expectedErrorType, actualErrorType);
        } else if (StringUtils.isNotBlank((CharSequence)this.expectedException) && !this.isExceptionExpected(exception, exceptionEvent)) {
            String actualException = Optional.ofNullable(ExceptionUtils.getRootCause((Throwable)exception)).orElse(exception).getClass().getName();
            failure = new ComparisonFailure("The exception thrown does not match the expected one. ", this.expectedException, actualException);
        }
        return Optional.ofNullable(failure);
    }

    protected boolean isErrorIdExpected(Event exceptionEvent) throws MunitError {
        Object errorId = this.getExpressionWrapper().evaluateIfExpression(exceptionEvent, (Object)this.expectedErrorType).getValue();
        if (errorId instanceof String) {
            try {
                ComponentIdentifier errorTypeComponentIdentifier = ComponentIdentifier.buildFromStringRepresentation((String)((String)errorId).toUpperCase());
                Optional errorType = this.errorTypeRepository.getErrorType(errorTypeComponentIdentifier);
                SingleErrorTypeMatcher errorTypeMatcher = new SingleErrorTypeMatcher((ErrorType)errorType.orElseThrow(() -> new MunitError("The expected error type " + errorId + " was not found")));
                Error eventError = (Error)exceptionEvent.getError().orElseThrow(() -> new MunitError("The event has no error"));
                return errorTypeMatcher.match(eventError.getErrorType());
            }
            catch (IllegalStateException e) {
                throw new MunitError("Expect error id " + errorId + " was never registered it can not be thrown", (Throwable)e);
            }
        }
        throw new MunitError("Expect error id expression error. The expression should return a valid string");
    }

    protected boolean isExceptionExpected(Throwable exception, Event exceptionEvent) throws MunitError {
        if (this.getExpressionWrapper().isExpressionValid((Object)this.expectedException)) {
            return this.evaluateExpectException(exceptionEvent);
        }
        return this.exceptionMatches(exception);
    }

    protected Boolean evaluateExpectException(Event event) throws MunitError {
        try {
            Object result = this.getExpressionWrapper().evaluate(event, (Object)this.expectedException).getValue();
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            throw new MunitError("Please make sure your expression matching for expectedException returns a boolean value");
        }
        catch (ExpressionRuntimeException e) {
            throw new MunitError("Expect exception expression error. " + e.getMessage());
        }
    }

    protected Boolean exceptionMatches(Throwable exception) throws MunitError {
        Class<?> expectExceptionClass;
        ClassLoader appClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            expectExceptionClass = Class.forName(this.expectedException, true, appClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new MunitError("The class " + exception + " could not be found", (Throwable)e);
        }
        return expectExceptionClass.isAssignableFrom(Optional.ofNullable(ExceptionUtils.getRootCause((Throwable)exception)).orElse(exception).getClass());
    }

    protected void setErrorTypeRepository(ErrorTypeRepository errorTypeRepository) {
        this.errorTypeRepository = errorTypeRepository;
    }

    protected void setExtendedExpressionManager(ExtendedExpressionManager extendedExpressionManager) {
        this.extendedExpressionManager = extendedExpressionManager;
    }

    protected void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    private MunitExpressionWrapper getExpressionWrapper() {
        return new MunitExpressionWrapper((ExpressionManager)this.extendedExpressionManager);
    }

    private List<MessageSource> getFlowSources(EnableFlowSources enabledFlowSources) {
        return Optional.ofNullable(enabledFlowSources).map(flowSources -> flowSources.getFlows().stream().map(EnableFlowSources.FlowRef::getFlow).filter(this::isFlow).map(component -> (Flow)component).map(Pipeline::getSource).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private boolean isFlow(Component component) {
        if (component instanceof Flow) {
            return true;
        }
        logger.warn("Component {} listed in enable-flow-sources section is not a flow", (Object)component);
        return false;
    }

    private Integer getTimeout() {
        String property = System.getProperty(MUNIT_TEST_TIMEOUT_PROPERTY);
        if (property != null) {
            return Integer.valueOf(property);
        }
        return 60000;
    }

    public void dispose() {
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
        super.dispose();
    }

    public void initialise() throws InitialisationException {
        this.scheduler = this.schedulerService.cpuLightScheduler(SchedulerConfig.config().withName("MUnit-Runner"));
        super.initialise();
    }

    protected class ExceptionAwareCallable
    implements Callable<Either<ExecutionResult, Throwable>> {
        private final Event event;

        ExceptionAwareCallable(Event event) {
            this.event = event;
        }

        @Override
        public Either<ExecutionResult, Throwable> call() throws Exception {
            try {
                return Either.left(TestFlow.this.execute(InputEvent.create((Event)this.event)).get());
            }
            catch (Throwable t) {
                return Either.right((Object)t);
            }
        }
    }
}

