/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.processors;

import java.util.Arrays;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.munit.common.behavior.BehaviorManager;
import org.mule.munit.runner.component.rules.TemporaryDirectoryRule;
import org.mule.munit.runner.component.rules.TestRule;
import org.mule.munit.runner.processors.EnableFlowSources;
import org.mule.munit.runner.processors.MunitModule;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.Location;

public class MunitModuleTest {
    private MunitModule module;
    private Registry muleRegistryMock;
    private BehaviorManager behaviorManagerMock;
    private TemporaryDirectoryRule temporaryDirectoryRuleMock;

    @Before
    public void setUp() {
        this.module = new MunitModule();
        this.muleRegistryMock = (Registry)Mockito.mock(Registry.class);
        this.behaviorManagerMock = (BehaviorManager)Mockito.mock(BehaviorManager.class);
        this.temporaryDirectoryRuleMock = (TemporaryDirectoryRule)Mockito.mock(TemporaryDirectoryRule.class);
        Mockito.when((Object)this.muleRegistryMock.lookupByName("_munitBehaviorManager")).thenReturn(Optional.of(this.behaviorManagerMock));
        Mockito.when((Object)this.muleRegistryMock.lookupAllByType(TestRule.class)).thenReturn(Arrays.asList(this.temporaryDirectoryRuleMock));
    }

    @Test
    public void validateMockInbounds() {
        MatcherAssert.assertThat((String)"The value is wrong", (Object)this.module.isDisableFlowSources(), (Matcher)Is.is((Object)true));
        this.module.setDisableFlowSources(false);
        MatcherAssert.assertThat((String)"The value is wrong", (Object)this.module.isDisableFlowSources(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void addEnableFlowSources() {
        MatcherAssert.assertThat((String)"The value is wrong", (Object)this.module.getEnableFlowSources().getFlows().size(), (Matcher)Is.is((Object)0));
        EnableFlowSources enableFlowSourcesMockOne = (EnableFlowSources)Mockito.mock(EnableFlowSources.class);
        EnableFlowSources enableFlowSourcesMockTwo = (EnableFlowSources)Mockito.mock(EnableFlowSources.class);
        EnableFlowSources.FlowRef flowRefOne = this.getFlowRef("flowOne");
        EnableFlowSources.FlowRef flowRefTwo = this.getFlowRef("flowTwo");
        Mockito.when((Object)enableFlowSourcesMockOne.getFlows()).thenReturn(Arrays.asList(flowRefOne));
        Mockito.when((Object)enableFlowSourcesMockTwo.getFlows()).thenReturn(Arrays.asList(flowRefTwo));
        this.module.addEnableFlowSources(enableFlowSourcesMockOne);
        this.module.addEnableFlowSources(enableFlowSourcesMockTwo);
        MatcherAssert.assertThat((String)"The value is wrong", (Object)this.module.getEnableFlowSources().getFlows().size(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void testReset() {
        this.module.muleRegistry = this.muleRegistryMock;
        this.module.reset();
        ((BehaviorManager)Mockito.verify((Object)this.behaviorManagerMock, (VerificationMode)Mockito.times((int)1))).reset();
        ((TemporaryDirectoryRule)Mockito.verify((Object)this.temporaryDirectoryRuleMock)).reset();
    }

    private EnableFlowSources.FlowRef getFlowRef(String flowName) {
        Location locationRootMock = (Location)Mockito.mock(Location.class);
        Component flowMock = (Component)Mockito.mock(Component.class);
        Mockito.when((Object)locationRootMock.getGlobalName()).thenReturn((Object)flowName);
        Mockito.when((Object)flowMock.getRootContainerLocation()).thenReturn((Object)locationRootMock);
        EnableFlowSources.FlowRef flowRef = new EnableFlowSources.FlowRef();
        flowRef.setFlow(flowMock);
        return flowRef;
    }
}

