/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.remote.api.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.util.RunnerPortProvider;
import org.mule.munit.runner.component.TestComponentInfoProvider;
import org.mule.munit.runner.config.TestComponentLocator;
import org.mule.munit.runner.remote.api.server.RunMessageHandler;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunnerServer
implements Runnable,
Lifecycle {
    private static final int SOCKET_TIMEOUT_MILLIS = 15000;
    protected static final String MUNIT_RUNNER_SERVER_TIME_OUT = "munit.runner.server.time.out";
    protected static final String MUNIT_SCHEDULER_NAME = "munit";
    private static transient Logger log = LoggerFactory.getLogger(RunnerServer.class);
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private ConfigurationComponentLocator componentLocator;
    private Scheduler scheduler;
    @Inject
    private LazyComponentInitializer lazyComponentInitializer;
    @Inject
    private List<TestComponentInfoProvider> testComponentInfoProviders;
    private int port;
    private boolean keepRunning = true;
    private ServerSocket providerSocket = null;
    private TestComponentLocator testComponentLocator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.providerSocket = this.createServerSocket();
            do {
                log.info("Waiting for client connection ");
                Socket connection = this.providerSocket.accept();
                log.info("Client connection received from " + connection.getInetAddress().getHostName() + " - " + this.keepRunning);
                ObjectOutputStream out = new ObjectOutputStream(connection.getOutputStream());
                ObjectInputStream in = new ObjectInputStream(connection.getInputStream());
                this.handleClientMessage(in, out);
            } while (this.keepRunning);
        }
        catch (SocketTimeoutException timeoutException) {
            log.debug("MUnit server time out");
            if (this.keepRunning) {
                log.error("Client connection timeout after " + String.valueOf(this.getServerTimeout()) + " milliseconds");
            }
        }
        catch (IOException ioException) {
            if (this.providerSocket != null && this.providerSocket.isClosed()) {
                if (this.keepRunning) {
                    log.warn("Kill signal received before accept timeout in port [" + this.port + "]", (Throwable)ioException);
                } else {
                    log.debug("Shut down signal received MUnit server running in port [" + this.port + "]...");
                }
            } else {
                log.error("Failed to start MUnit server in port [" + this.port + "]", (Throwable)ioException);
            }
        }
        catch (ClassNotFoundException e) {
            log.error("Fail to deserialize message.", (Throwable)e);
        }
        finally {
            try {
                log.debug("Shutting down MUnit server running in port [" + this.port + "]...");
                if (null != this.providerSocket) {
                    this.providerSocket.close();
                }
                this.keepRunning = false;
                log.debug("MUnit server shutdown");
            }
            catch (IOException ioException) {
                log.debug("MUnit server error during shutdown.");
            }
        }
    }

    protected ServerSocket createServerSocket() throws IOException {
        RunnerPortProvider runnerPortProvider = new RunnerPortProvider();
        Optional<Integer> munitServerPort = runnerPortProvider.getPredefinedPort();
        if (!munitServerPort.isPresent()) {
            log.warn("Property munit.server.port has not been defined. Probably because this run hasn't been started by MUnit");
            log.warn("Starting server on random port...");
            munitServerPort = Optional.of(runnerPortProvider.findFreePort());
        }
        this.port = (Integer)munitServerPort.get();
        ServerSocket providerSocket = new ServerSocket(this.port, 10);
        providerSocket.setSoTimeout(this.getServerTimeout());
        log.debug("MUnit server started listening in port [" + this.port + "]...");
        return providerSocket;
    }

    protected void handleClientMessage(ObjectInput in, ObjectOutput out) throws IOException, ClassNotFoundException {
        RunMessageHandler commander = new RunMessageHandler(in, out, this.testComponentLocator);
        commander.handle();
    }

    protected boolean isKeepRunning() {
        return this.keepRunning;
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public void setComponentLocator(ConfigurationComponentLocator componentLocator) {
        this.componentLocator = componentLocator;
    }

    public void setTestComponentInfoProviders(List<TestComponentInfoProvider> testComponentInfoProviders) {
        this.testComponentInfoProviders = testComponentInfoProviders;
    }

    public void initialise() throws InitialisationException {
        log.debug("Initializing MUnit server...");
        this.testComponentLocator = new TestComponentLocator(this.componentLocator, this.lazyComponentInitializer, this.testComponentInfoProviders);
        this.scheduler = this.createScheduler();
    }

    public void start() throws MuleException {
        if (System.getProperty("munit.server.port") != null) {
            this.scheduler.submit((Runnable)this);
        }
    }

    public void stop() throws MuleException {
        log.debug("Stop signal received, shooting down MUnit server...");
        this.keepRunning = false;
    }

    public void dispose() {
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
        log.debug("Dispose signal received, shooting down MUnit server...");
        try {
            this.keepRunning = false;
            if (this.providerSocket != null) {
                this.providerSocket.close();
            }
        }
        catch (IOException e) {
            log.warn("Error when sending kill signal to MUnit server", (Throwable)e);
        }
    }

    private Integer getServerTimeout() {
        String timeout = System.getProperty(MUNIT_RUNNER_SERVER_TIME_OUT);
        if (StringUtils.isBlank((CharSequence)timeout)) {
            return 15000;
        }
        try {
            log.debug("Runner server timeout defined by property. Attempting to use that...");
            Integer to = Integer.parseInt(timeout);
            log.debug("Runner server timeout defined by property as [" + timeout + "]");
            return to;
        }
        catch (NumberFormatException e) {
            log.warn("Runner server timeout defined by property invalid. Using default");
            return 15000;
        }
    }

    private Scheduler createScheduler() {
        return this.schedulerService.customScheduler(SchedulerConfig.config().withName(MUNIT_SCHEDULER_NAME).withMaxConcurrentTasks(1).withWaitAllowed(true));
    }
}

