/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.munit.runner.component.TestComponent;
import org.mule.munit.runner.component.TestComponentInfoProvider;
import org.mule.munit.runner.config.TestComponentLocator;
import org.mule.munit.runner.flow.AfterSuite;
import org.mule.munit.runner.flow.AfterTest;
import org.mule.munit.runner.flow.BeforeSuite;
import org.mule.munit.runner.flow.BeforeTest;
import org.mule.munit.runner.processors.MunitModule;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.config.api.LazyComponentInitializer;

public class TestComponentLocatorTest {
    private static final String EXAMPLE_NAMESPACE = "example";
    private static final String EXAMPLE_NAME = "test";
    private static final ComponentIdentifier EXAMPLE_TEST_IDENTIFIER = ComponentIdentifier.builder().namespace("example").name("test").build();
    private static final TestComponentInfoProvider EXAMPLE_PROVIDER = new ExampleTestComponentInfoProvider();
    private static final String EXAMPLE_SUITE_PATH = "example-test.xml";
    private LazyComponentInitializer lazyComponentInitializerMock;
    private ConfigurationComponentLocator componentLocatorMock;
    private TestComponentLocator testComponentLocator;

    @Before
    public void setUp() {
        this.lazyComponentInitializerMock = (LazyComponentInitializer)Mockito.mock(LazyComponentInitializer.class);
        this.componentLocatorMock = (ConfigurationComponentLocator)Mockito.mock(ConfigurationComponentLocator.class);
        Mockito.when((Object)this.componentLocatorMock.find((ComponentIdentifier)org.mockito.Matchers.any(ComponentIdentifier.class))).thenReturn(Collections.emptyList());
        this.testComponentLocator = new TestComponentLocator(this.componentLocatorMock, this.lazyComponentInitializerMock, Collections.singletonList(EXAMPLE_PROVIDER));
    }

    @Test
    public void initializeComponents() {
        this.testComponentLocator.initializeComponents(EXAMPLE_SUITE_PATH);
        ((LazyComponentInitializer)Mockito.verify((Object)this.lazyComponentInitializerMock)).initializeComponents((LazyComponentInitializer.ComponentLocationFilter)org.mockito.Matchers.any(LazyComponentInitializer.ComponentLocationFilter.class));
    }

    @Test
    public void lookupMunitModule() {
        MunitModule munitModuleMock = (MunitModule)Mockito.mock(MunitModule.class);
        Mockito.when((Object)this.componentLocatorMock.find(this.componentIdentifier("munit:config"))).thenReturn(Collections.singletonList(munitModuleMock));
        this.assertPresent(this.testComponentLocator.lookupMunitModule(), munitModuleMock);
    }

    @Test
    public void lookupBeforeSuite() {
        BeforeSuite beforeSuiteMock = (BeforeSuite)Mockito.mock(BeforeSuite.class);
        Mockito.when((Object)this.componentLocatorMock.find(this.componentIdentifier("munit:before-suite"))).thenReturn(Collections.singletonList(beforeSuiteMock));
        this.assertPresent(this.testComponentLocator.lookupBeforeSuite(), beforeSuiteMock);
    }

    @Test
    public void lookupAfterSuite() {
        AfterSuite afterSuiteMock = (AfterSuite)Mockito.mock(AfterSuite.class);
        Mockito.when((Object)this.componentLocatorMock.find(this.componentIdentifier("munit:after-suite"))).thenReturn(Collections.singletonList(afterSuiteMock));
        this.assertPresent(this.testComponentLocator.lookupAfterSuite(), afterSuiteMock);
    }

    @Test
    public void lookupBeforeTest() {
        BeforeTest beforeTestMock = (BeforeTest)Mockito.mock(BeforeTest.class);
        Mockito.when((Object)this.componentLocatorMock.find(this.componentIdentifier("munit:before-test"))).thenReturn(Collections.singletonList(beforeTestMock));
        this.assertPresent(this.testComponentLocator.lookupBeforeTest(), beforeTestMock);
    }

    @Test
    public void lookupAfterTest() {
        AfterTest afterTestMock = (AfterTest)Mockito.mock(AfterTest.class);
        Mockito.when((Object)this.componentLocatorMock.find(this.componentIdentifier("munit:after-test"))).thenReturn(Collections.singletonList(afterTestMock));
        this.assertPresent(this.testComponentLocator.lookupAfterTest(), afterTestMock);
    }

    @Test
    public void lookupTests() {
        TestComponent test1Component = (TestComponent)Mockito.mock(TestComponent.class);
        TestComponent test2Component = (TestComponent)Mockito.mock(TestComponent.class);
        Mockito.when((Object)this.componentLocatorMock.find(EXAMPLE_TEST_IDENTIFIER)).thenReturn(Arrays.asList(test1Component, test2Component));
        Assert.assertThat((Object)this.testComponentLocator.lookupTests(), (Matcher)Matchers.containsInAnyOrder((Object[])new TestComponent[]{test1Component, test2Component}));
    }

    @Test
    public void emptyLookups() {
        this.assertEmpty(this.testComponentLocator.lookupMunitModule());
        this.assertEmpty(this.testComponentLocator.lookupBeforeSuite());
        this.assertEmpty(this.testComponentLocator.lookupBeforeTest());
        this.assertEmpty(this.testComponentLocator.lookupAfterSuite());
        this.assertEmpty(this.testComponentLocator.lookupAfterTest());
        Assert.assertThat((Object)this.testComponentLocator.lookupTests(), (Matcher)IsEmptyCollection.empty());
    }

    private void assertEmpty(Optional<?> optional) {
        Assert.assertThat((Object)optional.isPresent(), (Matcher)IsEqual.equalTo((Object)false));
    }

    private <T> void assertPresent(Optional<T> optional, T expected) {
        Assert.assertThat((Object)optional.isPresent(), (Matcher)IsEqual.equalTo((Object)true));
        Assert.assertThat(optional.get(), (Matcher)IsEqual.equalTo(expected));
    }

    private ComponentIdentifier componentIdentifier(String identifier) {
        return ComponentIdentifier.buildFromStringRepresentation((String)identifier);
    }

    private static class ExampleTestComponentInfoProvider
    implements TestComponentInfoProvider {
        private ExampleTestComponentInfoProvider() {
        }

        public ComponentIdentifier getComponentIdentifier() {
            return EXAMPLE_TEST_IDENTIFIER;
        }
    }
}

