/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.model;

import junit.framework.Assert;
import org.junit.Before;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.munit.common.protocol.listeners.SuiteRunEventListener;
import org.mule.munit.common.protocol.message.TestStatus;
import org.mule.munit.runner.flow.AfterSuite;
import org.mule.munit.runner.flow.BeforeSuite;
import org.mule.munit.runner.flow.SimpleFlow;
import org.mule.munit.runner.model.Suite;
import org.mule.munit.runner.model.SuiteResult;
import org.mule.munit.runner.model.Test;
import org.mule.munit.runner.model.TestResult;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.privileged.exception.EventProcessingException;
import org.slf4j.Logger;

public class SuiteTest {
    private static final String AFTER_SUITE_NAME = "AfterSuiteName";
    private static final String AFTER_SUITE_DESCRIPTION = "After Suite Description";
    private static final String BEFORE_SUITE_NAME = "BeforeSuiteName";
    private static final String BEFORE_SUITE_DESCRIPTION = "Before Suite Description";
    private static final String TEST_NAME = "TestName";
    private static final String TEST_DESCRIPTION = "TestDescription";
    private AfterSuite afterTestMock;
    private BeforeSuite beforeTestMock;
    private SuiteRunEventListener suiteRunEventListenerMock;
    private Suite suiteMock;

    @Before
    public void setUp() throws Exception {
        this.afterTestMock = (AfterSuite)Mockito.mock(AfterSuite.class);
        this.beforeTestMock = (BeforeSuite)Mockito.mock(BeforeSuite.class);
        this.suiteRunEventListenerMock = (SuiteRunEventListener)Mockito.mock(SuiteRunEventListener.class);
        Mockito.when((Object)this.afterTestMock.getDescription()).thenReturn((Object)AFTER_SUITE_DESCRIPTION);
        Mockito.when((Object)this.afterTestMock.getName()).thenReturn((Object)AFTER_SUITE_NAME);
        Mockito.when((Object)this.beforeTestMock.getDescription()).thenReturn((Object)BEFORE_SUITE_DESCRIPTION);
        Mockito.when((Object)this.beforeTestMock.getName()).thenReturn((Object)BEFORE_SUITE_NAME);
        this.suiteMock = (Suite)Mockito.mock(Suite.class);
        this.suiteMock.logger = (Logger)Mockito.mock(Logger.class);
        ((Suite)Mockito.doCallRealMethod().when((Object)this.suiteMock)).setSuiteRunEventListener(this.suiteRunEventListenerMock);
        this.suiteMock.setSuiteRunEventListener(this.suiteRunEventListenerMock);
        ((Suite)Mockito.doCallRealMethod().when((Object)this.suiteMock)).setBeforeSuite(this.beforeTestMock);
        this.suiteMock.setBeforeSuite(this.beforeTestMock);
        ((Suite)Mockito.doCallRealMethod().when((Object)this.suiteMock)).setAfterSuite(this.afterTestMock);
        this.suiteMock.setAfterSuite(this.afterTestMock);
        ((Suite)Mockito.doCallRealMethod().when((Object)this.suiteMock)).run();
    }

    @org.junit.Test
    public void mustHaveTheSameTestThatWereAdded() {
        Test test1 = this.mockTest("TestName1");
        Test test2 = this.mockTest("TestName2");
        Suite suite = new Suite("testSuite");
        suite.addTest(test1);
        suite.addTest(test2);
        Assert.assertEquals((int)2, (int)suite.getNumberOfTests());
    }

    @org.junit.Test
    public void callNotificationAndExecuteTestsWhenRun() throws Exception {
        Test test = (Test)Mockito.mock(Test.class);
        SuiteRunEventListener listener = (SuiteRunEventListener)Mockito.mock(SuiteRunEventListener.class);
        TestResult testResult = new TestResult(TEST_NAME, TEST_DESCRIPTION);
        Mockito.when((Object)test.run()).thenReturn((Object)testResult);
        Suite suite = new Suite("testSuite");
        suite.addTest(test);
        suite.setSuiteRunEventListener(listener);
        SuiteResult suiteResult = suite.run();
        ((SuiteRunEventListener)Mockito.verify((Object)listener)).notifyTestEnd(testResult.getName(), testResult.getStackTrace(), testResult.getStatus(), testResult.getElapsedTime());
        ((SuiteRunEventListener)Mockito.verify((Object)listener)).notifyTestStart(test.getName(), test.getDescription(), test.isIgnore());
        Assert.assertEquals((String)"testSuite", (String)suiteResult.getTestName());
    }

    @org.junit.Test
    public void verifyBeforeSuiteFailure() throws Throwable {
        ((Suite)Mockito.doThrow((Throwable)((Object)new AssertionError())).when((Object)this.suiteMock)).process((SimpleFlow)Mockito.eq((Object)this.beforeTestMock), (Event)Mockito.any(Event.class));
        ((Suite)Mockito.doCallRealMethod().when((Object)this.suiteMock)).handleBeforeSuiteEndByException((String)Mockito.any(), (Throwable)Mockito.any());
        this.suiteMock.run();
        ((SuiteRunEventListener)Mockito.verify((Object)this.suiteRunEventListenerMock)).notifyBeforeSuiteEnd((String)Mockito.eq((Object)BEFORE_SUITE_NAME), (String)Mockito.any(), (TestStatus)Mockito.eq((Object)TestStatus.FAILURE));
    }

    @org.junit.Test
    public void verifyBeforeSuiteFailureMessagingException() throws Throwable {
        EventProcessingException eventProcessingExceptionMock = (EventProcessingException)Mockito.mock(EventProcessingException.class);
        Mockito.when((Object)eventProcessingExceptionMock.getCause()).thenReturn((Object)new AssertionError());
        ((Suite)Mockito.doThrow((Throwable)eventProcessingExceptionMock).when((Object)this.suiteMock)).process((SimpleFlow)Mockito.eq((Object)this.beforeTestMock), (Event)Mockito.any(Event.class));
        ((Suite)Mockito.doCallRealMethod().when((Object)this.suiteMock)).handleBeforeSuiteEndByException((String)Mockito.any(), (Throwable)Mockito.any());
        this.suiteMock.run();
        ((SuiteRunEventListener)Mockito.verify((Object)this.suiteRunEventListenerMock)).notifyBeforeSuiteEnd((String)Mockito.eq((Object)BEFORE_SUITE_NAME), (String)Mockito.any(), (TestStatus)Mockito.eq((Object)TestStatus.FAILURE));
    }

    @org.junit.Test
    public void verifyBeforeSuiteErrorMessagingException() throws Throwable {
        EventProcessingException eventProcessingExceptionMock = (EventProcessingException)Mockito.mock(EventProcessingException.class);
        Mockito.when((Object)eventProcessingExceptionMock.getCause()).thenReturn((Object)new Error());
        MuleRuntimeException muleRuntimeExceptionMock = (MuleRuntimeException)Mockito.mock(MuleRuntimeException.class);
        Mockito.when((Object)muleRuntimeExceptionMock.getCause()).thenReturn((Object)eventProcessingExceptionMock);
        ((Suite)Mockito.doThrow((Throwable)muleRuntimeExceptionMock).when((Object)this.suiteMock)).process((SimpleFlow)Mockito.eq((Object)this.beforeTestMock), (Event)Mockito.any(Event.class));
        ((Suite)Mockito.doCallRealMethod().when((Object)this.suiteMock)).handleBeforeSuiteEndByException((String)Mockito.any(), (Throwable)Mockito.any());
        this.suiteMock.run();
        ((SuiteRunEventListener)Mockito.verify((Object)this.suiteRunEventListenerMock)).notifyBeforeSuiteEnd((String)Mockito.eq((Object)BEFORE_SUITE_NAME), (String)Mockito.any(), (TestStatus)Mockito.eq((Object)TestStatus.ERROR));
    }

    @org.junit.Test
    public void verifyTestsNotRunningIfBeforeSuiteFails() throws Throwable {
        ((Suite)Mockito.doThrow((Throwable)((Object)new AssertionError())).when((Object)this.suiteMock)).process((SimpleFlow)Mockito.eq((Object)this.beforeTestMock), (Event)Mockito.any(Event.class));
        ((Suite)Mockito.doCallRealMethod().when((Object)this.suiteMock)).handleBeforeSuiteEndByException((String)Mockito.any(), (Throwable)Mockito.any());
        this.suiteMock.run();
        ((SuiteRunEventListener)Mockito.verify((Object)this.suiteRunEventListenerMock)).notifyBeforeSuiteEnd((String)Mockito.eq((Object)BEFORE_SUITE_NAME), (String)Mockito.any(), (TestStatus)Mockito.eq((Object)TestStatus.FAILURE));
        ((SuiteRunEventListener)Mockito.verify((Object)this.suiteRunEventListenerMock, (VerificationMode)Mockito.never())).notifyTestStart(TEST_NAME, TEST_DESCRIPTION, false);
        ((SuiteRunEventListener)Mockito.verify((Object)this.suiteRunEventListenerMock, (VerificationMode)Mockito.never())).notifyTestEnd((String)Mockito.eq((Object)TEST_NAME), Mockito.anyString(), (TestStatus)Mockito.any(), Mockito.anyLong());
    }

    @org.junit.Test
    public void verifyAfterSuiteFailure() throws Throwable {
        EventProcessingException eventProcessingExceptionMock = (EventProcessingException)Mockito.mock(EventProcessingException.class);
        Mockito.when((Object)eventProcessingExceptionMock.getCause()).thenReturn((Object)new AssertionError());
        ((Suite)Mockito.doThrow((Throwable)((Object)new AssertionError())).when((Object)this.suiteMock)).process((SimpleFlow)Mockito.eq((Object)this.afterTestMock), (Event)Mockito.any(Event.class));
        ((Suite)Mockito.doCallRealMethod().when((Object)this.suiteMock)).handleBeforeSuiteEndByException((String)Mockito.any(), (Throwable)Mockito.any());
        this.suiteMock.run();
        ((SuiteRunEventListener)Mockito.verify((Object)this.suiteRunEventListenerMock)).notifyAfterSuiteEnd((String)Mockito.eq((Object)AFTER_SUITE_NAME), (String)Mockito.any(), (TestStatus)Mockito.eq((Object)TestStatus.FAILURE));
    }

    @org.junit.Test
    public void verifyAfterSuiteFailureEventProcessingException() throws Throwable {
        EventProcessingException eventProcessingExceptionMock = (EventProcessingException)Mockito.mock(EventProcessingException.class);
        Mockito.when((Object)eventProcessingExceptionMock.getCause()).thenReturn((Object)new AssertionError());
        ((Suite)Mockito.doThrow((Throwable)eventProcessingExceptionMock).when((Object)this.suiteMock)).process((SimpleFlow)Mockito.eq((Object)this.afterTestMock), (Event)Mockito.any(Event.class));
        ((Suite)Mockito.doCallRealMethod().when((Object)this.suiteMock)).handleBeforeSuiteEndByException((String)Mockito.any(), (Throwable)Mockito.any());
        this.suiteMock.run();
        ((SuiteRunEventListener)Mockito.verify((Object)this.suiteRunEventListenerMock)).notifyAfterSuiteEnd((String)Mockito.eq((Object)AFTER_SUITE_NAME), (String)Mockito.any(), (TestStatus)Mockito.eq((Object)TestStatus.FAILURE));
    }

    @org.junit.Test
    public void verifyAfterSuiteError() throws Throwable {
        ((Suite)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)this.suiteMock)).process((SimpleFlow)Mockito.eq((Object)this.afterTestMock), (Event)Mockito.any(Event.class));
        ((Suite)Mockito.doCallRealMethod().when((Object)this.suiteMock)).handleBeforeSuiteEndByException((String)Mockito.any(), (Throwable)Mockito.any());
        this.suiteMock.run();
        ((SuiteRunEventListener)Mockito.verify((Object)this.suiteRunEventListenerMock)).notifyAfterSuiteEnd((String)Mockito.eq((Object)AFTER_SUITE_NAME), (String)Mockito.any(), (TestStatus)Mockito.eq((Object)TestStatus.ERROR));
    }

    @org.junit.Test
    public void verifyAfterSuiteErrorEventProcessingException() throws Throwable {
        EventProcessingException eventProcessingExceptionMock = (EventProcessingException)Mockito.mock(EventProcessingException.class);
        Mockito.when((Object)eventProcessingExceptionMock.getCause()).thenReturn((Object)new NullPointerException());
        ((Suite)Mockito.doThrow((Throwable)eventProcessingExceptionMock).when((Object)this.suiteMock)).process((SimpleFlow)Mockito.eq((Object)this.afterTestMock), (Event)Mockito.any(Event.class));
        ((Suite)Mockito.doCallRealMethod().when((Object)this.suiteMock)).handleBeforeSuiteEndByException((String)Mockito.any(), (Throwable)Mockito.any());
        this.suiteMock.run();
        ((SuiteRunEventListener)Mockito.verify((Object)this.suiteRunEventListenerMock)).notifyAfterSuiteEnd((String)Mockito.eq((Object)AFTER_SUITE_NAME), (String)Mockito.any(), (TestStatus)Mockito.eq((Object)TestStatus.ERROR));
    }

    @org.junit.Test
    public void allTestsIgnoredIsTrue() throws Exception {
        Test test1 = this.mockTest("TestName1");
        Test test2 = this.mockTest("TestName2");
        Mockito.when((Object)test1.isIgnore()).thenReturn((Object)true);
        Mockito.when((Object)test2.isIgnore()).thenReturn((Object)true);
        Suite suite = new Suite("testSuite");
        suite.setSuiteRunEventListener(this.suiteRunEventListenerMock);
        suite.addTest(test1);
        suite.addTest(test2);
        Assert.assertTrue((boolean)suite.allTestsIgnored());
    }

    @org.junit.Test
    public void allTestsIgnoredIsFalse() throws Exception {
        Test test1 = this.mockTest("TestName1");
        Test test2 = this.mockTest("TestName2");
        Mockito.when((Object)test1.isIgnore()).thenReturn((Object)true);
        Mockito.when((Object)test2.isIgnore()).thenReturn((Object)false);
        Suite suite = new Suite("testSuite");
        suite.setSuiteRunEventListener(this.suiteRunEventListenerMock);
        suite.addTest(test1);
        suite.addTest(test2);
        Assert.assertFalse((boolean)suite.allTestsIgnored());
    }

    @org.junit.Test
    public void notifyIgnoredTest() throws Exception {
        Test test = this.mockTest(TEST_NAME);
        Mockito.when((Object)test.getName()).thenReturn((Object)TEST_NAME);
        Mockito.when((Object)test.getDescription()).thenReturn((Object)TEST_DESCRIPTION);
        Mockito.when((Object)test.isIgnore()).thenReturn((Object)true);
        Suite suite = new Suite("testSuite");
        suite.setSuiteRunEventListener(this.suiteRunEventListenerMock);
        suite.addTest(test);
        suite.run();
        ((SuiteRunEventListener)Mockito.verify((Object)this.suiteRunEventListenerMock)).notifyTestStart(TEST_NAME, TEST_DESCRIPTION, true);
    }

    private Test mockTest(String testName) {
        Test test = (Test)Mockito.mock(Test.class);
        TestResult testResult = new TestResult(testName, "");
        Mockito.when((Object)test.run()).thenReturn((Object)testResult);
        return test;
    }
}

