/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.model;

import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.munit.common.protocol.message.TestStatus;
import org.mule.munit.runner.component.TestComponent;
import org.mule.munit.runner.flow.AfterTest;
import org.mule.munit.runner.flow.BeforeTest;
import org.mule.munit.runner.flow.SimpleFlow;
import org.mule.munit.runner.flow.TestFlow;
import org.mule.munit.runner.model.Test;
import org.mule.munit.runner.model.TestResult;
import org.mule.munit.runner.processors.MunitModule;
import org.mule.runtime.api.component.execution.ComponentExecutionException;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.privileged.exception.EventProcessingException;

public class TestTest {
    private BeforeTest before = (BeforeTest)Mockito.mock(BeforeTest.class);
    private AfterTest after = (AfterTest)Mockito.mock(AfterTest.class);
    private TestFlow testFlowMock = (TestFlow)Mockito.mock(TestFlow.class);
    private InternalEvent muleEventMock = (InternalEvent)Mockito.mock(InternalEvent.class);
    private MunitModule munitModuleMock = (MunitModule)Mockito.mock(MunitModule.class);
    private Test testMock;

    @Before
    public void setUpMocks() throws MuleException {
        this.testMock = (Test)Mockito.mock(Test.class);
        this.testMock.before = this.before;
        this.testMock.test = this.testFlowMock;
        this.testMock.after = this.after;
        this.testMock.munitModule = this.munitModuleMock;
        Mockito.when((Object)this.testMock.getName()).thenReturn((Object)"exampleTest");
        Mockito.when((Object)this.testMock.getDescription()).thenReturn((Object)"exampleDescription");
        Mockito.when((Object)this.testFlowMock.getTags()).thenReturn(Collections.emptySet());
    }

    @org.junit.Test
    public void ignoreTestWhenRun() {
        Mockito.when((Object)this.testFlowMock.isIgnored()).thenReturn((Object)true);
        Test test = new Test(this.before, (TestComponent)this.testFlowMock, this.after, this.munitModuleMock);
        test.run();
        ((TestFlow)Mockito.verify((Object)this.testFlowMock, (VerificationMode)Mockito.times((int)1))).isIgnored();
    }

    @org.junit.Test
    public void runSuccessful() throws Throwable {
        ((Test)Mockito.doCallRealMethod().when((Object)this.testMock)).run();
        TestResult testResult = this.testMock.run();
        ((TestFlow)Mockito.verify((Object)this.testFlowMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class));
        ((Test)Mockito.verify((Object)this.testMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.before));
        ((Test)Mockito.verify((Object)this.testMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.after));
        Assert.assertTrue((testResult.getStatus() == TestStatus.SUCCESS ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void runWithFailure() throws Throwable {
        Mockito.when((Object)this.testMock.run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.before))).thenReturn((Object)this.muleEventMock);
        Mockito.when((Object)this.testFlowMock.run((Event)Mockito.any(Event.class))).thenThrow(new Throwable[]{new AssertionError((Object)"Error")});
        Mockito.when((Object)this.testMock.run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.after))).thenReturn((Object)this.muleEventMock);
        ((Test)Mockito.doCallRealMethod().when((Object)this.testMock)).run();
        TestResult testResult = this.testMock.run();
        ((Test)Mockito.verify((Object)this.testMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.before));
        ((TestFlow)Mockito.verify((Object)this.testFlowMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class));
        ((Test)Mockito.verify((Object)this.testMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.after));
        MatcherAssert.assertThat((Object)(testResult.getStatus() == TestStatus.FAILURE ? 1 : 0), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)testResult.getStackTrace(), (Matcher)Matchers.containsString((String)"Error"));
    }

    @org.junit.Test
    public void runWithFailureThatHasCause() throws Throwable {
        Mockito.when((Object)this.testMock.run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.before))).thenReturn((Object)this.muleEventMock);
        Mockito.when((Object)this.testFlowMock.run((Event)Mockito.any(Event.class))).thenThrow(new Throwable[]{new AssertionError("Error", new RuntimeException("The Cause"))});
        Mockito.when((Object)this.testMock.run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.after))).thenReturn((Object)this.muleEventMock);
        ((Test)Mockito.doCallRealMethod().when((Object)this.testMock)).run();
        TestResult testResult = this.testMock.run();
        ((Test)Mockito.verify((Object)this.testMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.before));
        ((TestFlow)Mockito.verify((Object)this.testFlowMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class));
        ((Test)Mockito.verify((Object)this.testMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.after));
        MatcherAssert.assertThat((Object)(testResult.getStatus() == TestStatus.FAILURE ? 1 : 0), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)testResult.getStackTrace(), (Matcher)Matchers.containsString((String)"Error"));
    }

    @org.junit.Test
    public void runWithError() throws Throwable {
        Mockito.when((Object)this.testMock.run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.before))).thenReturn((Object)this.muleEventMock);
        Mockito.when((Object)this.testFlowMock.run((Event)Mockito.any(Event.class))).thenThrow(new Throwable[]{new DefaultMuleException("Error")});
        Mockito.when((Object)this.testMock.run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.after))).thenReturn((Object)this.muleEventMock);
        ((Test)Mockito.doCallRealMethod().when((Object)this.testMock)).run();
        TestResult testResult = this.testMock.run();
        ((Test)Mockito.verify((Object)this.testMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.before));
        ((TestFlow)Mockito.verify((Object)this.testFlowMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class));
        ((Test)Mockito.verify((Object)this.testMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.after));
        MatcherAssert.assertThat((Object)(testResult.getStatus() == TestStatus.ERROR ? 1 : 0), (Matcher)Matchers.is((Object)true));
    }

    @org.junit.Test
    public void beforeWithAssertionErrorShouldFail() throws Throwable {
        EventProcessingException eventProcessingExceptionMock = (EventProcessingException)Mockito.mock(EventProcessingException.class);
        Mockito.when((Object)eventProcessingExceptionMock.getCause()).thenReturn((Object)new AssertionError());
        Mockito.when((Object)this.testMock.run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.before))).thenThrow(new Throwable[]{eventProcessingExceptionMock});
        ((Test)Mockito.doCallRealMethod().when((Object)this.testMock)).run();
        TestResult testResult = this.testMock.run();
        ((Test)Mockito.verify((Object)this.testMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.before));
        ((TestFlow)Mockito.verify((Object)this.testFlowMock, (VerificationMode)Mockito.times((int)0))).run((Event)Mockito.any(Event.class));
        ((Test)Mockito.verify((Object)this.testMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.after));
        MatcherAssert.assertThat((Object)(testResult.getStatus() == TestStatus.FAILURE ? 1 : 0), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)testResult.getStackTrace(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
    }

    @org.junit.Test
    public void beforeWithEventProcessingExceptionAndAssertionErrorShouldFail() throws Throwable {
        EventProcessingException eventProcessingExceptionMock = (EventProcessingException)Mockito.mock(EventProcessingException.class);
        Mockito.when((Object)eventProcessingExceptionMock.getCause()).thenReturn((Object)new AssertionError());
        Mockito.when((Object)this.testMock.run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.before))).thenThrow(new Throwable[]{eventProcessingExceptionMock});
        ((Test)Mockito.doCallRealMethod().when((Object)this.testMock)).run();
        TestResult testResult = this.testMock.run();
        ((Test)Mockito.verify((Object)this.testMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.before));
        ((TestFlow)Mockito.verify((Object)this.testFlowMock, (VerificationMode)Mockito.times((int)0))).run((Event)Mockito.any(Event.class));
        ((Test)Mockito.verify((Object)this.testMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.after));
        MatcherAssert.assertThat((Object)(testResult.getStatus() == TestStatus.FAILURE ? 1 : 0), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)testResult.getStackTrace(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
    }

    @org.junit.Test
    public void beforeWithExceptionShouldError() throws Throwable {
        EventProcessingException eventProcessingExceptionMock = (EventProcessingException)Mockito.mock(EventProcessingException.class);
        Mockito.when((Object)eventProcessingExceptionMock.getCause()).thenReturn((Object)new Error());
        Mockito.when((Object)this.testMock.run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.before))).thenThrow(new Throwable[]{eventProcessingExceptionMock});
        ((Test)Mockito.doCallRealMethod().when((Object)this.testMock)).run();
        TestResult testResult = this.testMock.run();
        ((Test)Mockito.verify((Object)this.testMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.before));
        ((TestFlow)Mockito.verify((Object)this.testFlowMock, (VerificationMode)Mockito.times((int)0))).run((Event)Mockito.any(Event.class));
        ((Test)Mockito.verify((Object)this.testMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.after));
        MatcherAssert.assertThat((Object)(testResult.getStatus() == TestStatus.ERROR ? 1 : 0), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)testResult.getStackTrace(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
    }

    @org.junit.Test
    public void afterWithErrorShouldFail() throws Throwable {
        EventProcessingException eventProcessingException = (EventProcessingException)Mockito.mock(EventProcessingException.class);
        Mockito.when((Object)eventProcessingException.getCause()).thenReturn((Object)new Error());
        Mockito.when((Object)this.testMock.run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.after))).thenThrow(new Throwable[]{eventProcessingException});
        ((Test)Mockito.doCallRealMethod().when((Object)this.testMock)).run();
        TestResult testResult = this.testMock.run();
        ((Test)Mockito.verify((Object)this.testMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.before));
        ((TestFlow)Mockito.verify((Object)this.testFlowMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class));
        ((Test)Mockito.verify((Object)this.testMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.after));
        MatcherAssert.assertThat((Object)(testResult.getStatus() == TestStatus.ERROR ? 1 : 0), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)testResult.getStackTrace(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
    }

    @org.junit.Test
    public void afterWithExceptionShouldError() throws Throwable {
        EventProcessingException eventProcessingExceptionMock = (EventProcessingException)Mockito.mock(EventProcessingException.class);
        Mockito.when((Object)eventProcessingExceptionMock.getCause()).thenReturn(null);
        MuleRuntimeException muleRuntimeExceptionMock = (MuleRuntimeException)Mockito.mock(MuleRuntimeException.class);
        Mockito.when((Object)muleRuntimeExceptionMock.getCause()).thenReturn((Object)eventProcessingExceptionMock);
        Mockito.when((Object)this.testMock.run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.after))).thenThrow(new Throwable[]{muleRuntimeExceptionMock});
        ((Test)Mockito.doCallRealMethod().when((Object)this.testMock)).run();
        TestResult testResult = this.testMock.run();
        ((Test)Mockito.verify((Object)this.testMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.before));
        ((TestFlow)Mockito.verify((Object)this.testFlowMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class));
        ((Test)Mockito.verify((Object)this.testMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.after));
        MatcherAssert.assertThat((Object)(testResult.getStatus() == TestStatus.ERROR ? 1 : 0), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)testResult.getStackTrace(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
    }

    @org.junit.Test
    public void isIgnoreTest() {
        Mockito.when((Object)this.testFlowMock.isIgnored()).thenReturn((Object)false);
        Test test = new Test(this.before, (TestComponent)this.testFlowMock, this.after, this.munitModuleMock);
        test.isIgnore();
        ((TestFlow)Mockito.verify((Object)this.testFlowMock, (VerificationMode)Mockito.times((int)1))).isIgnored();
        Mockito.when((Object)this.testFlowMock.isIgnored()).thenReturn((Object)true);
        test.run();
        ((TestFlow)Mockito.verify((Object)this.testFlowMock, (VerificationMode)Mockito.times((int)2))).isIgnored();
    }

    @org.junit.Test
    public void beforeTestSharesEventWithTest() throws Throwable {
        Mockito.when((Object)this.testMock.run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.before))).thenReturn((Object)this.muleEventMock);
        ((Test)Mockito.doCallRealMethod().when((Object)this.testMock)).run();
        this.testMock.run();
        ((Test)Mockito.verify((Object)this.testMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.before));
        ((TestFlow)Mockito.verify((Object)this.testFlowMock, (VerificationMode)Mockito.times((int)1))).run((Event)this.muleEventMock);
        ((Test)Mockito.verify((Object)this.testMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.after));
    }

    @org.junit.Test
    public void testSharesEventWithAfterTests() throws Throwable {
        Mockito.when((Object)this.testMock.run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.before))).thenReturn((Object)this.muleEventMock);
        Mockito.when((Object)this.testFlowMock.run((Event)Mockito.any(Event.class))).thenReturn((Object)this.muleEventMock);
        ((Test)Mockito.doCallRealMethod().when((Object)this.testMock)).run();
        this.testMock.run();
        ((TestFlow)Mockito.verify((Object)this.testFlowMock, (VerificationMode)Mockito.times((int)1))).run((Event)this.muleEventMock);
        ((Test)Mockito.verify((Object)this.testMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.after));
    }

    @org.junit.Test
    public void setUpAndTearDownAreCalled() throws Throwable {
        Mockito.when((Object)this.testFlowMock.run((Event)Mockito.any(Event.class))).thenReturn((Object)this.muleEventMock);
        ((Test)Mockito.doCallRealMethod().when((Object)this.testMock)).run();
        this.testMock.run();
        ((TestFlow)Mockito.verify((Object)this.testFlowMock)).setUp();
        ((TestFlow)Mockito.verify((Object)this.testFlowMock)).tearDown();
    }

    @org.junit.Test
    public void executionOrder() throws Throwable {
        Mockito.when((Object)this.testMock.run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.before))).thenReturn((Object)this.muleEventMock);
        Mockito.when((Object)this.testFlowMock.run((Event)Mockito.any(Event.class))).thenReturn((Object)this.muleEventMock);
        Mockito.when((Object)this.testMock.run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.after))).thenReturn((Object)this.muleEventMock);
        ((Test)Mockito.doCallRealMethod().when((Object)this.testMock)).run();
        this.testMock.run();
        InOrder orderVerifier = Mockito.inOrder((Object[])new Object[]{this.testMock, this.testFlowMock});
        ((Test)orderVerifier.verify((Object)this.testMock)).run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.before));
        ((TestFlow)orderVerifier.verify((Object)this.testFlowMock)).setUp();
        ((TestFlow)orderVerifier.verify((Object)this.testFlowMock)).run((Event)Mockito.any(Event.class));
        ((TestFlow)orderVerifier.verify((Object)this.testFlowMock)).tearDown();
        ((Test)orderVerifier.verify((Object)this.testMock)).run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.after));
    }

    @org.junit.Test
    public void runWithEventProcessingExceptionShouldGetEvent() throws Throwable {
        CoreEvent eventMock = (CoreEvent)Mockito.mock(CoreEvent.class);
        EventProcessingException eventProcessingException = new EventProcessingException(eventMock, (Throwable)new RuntimeException());
        Mockito.when((Object)this.testMock.run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.before))).thenReturn((Object)this.muleEventMock);
        Mockito.when((Object)this.testFlowMock.run((Event)Mockito.any(Event.class))).thenThrow(new Throwable[]{eventProcessingException});
        Mockito.when((Object)this.testMock.run((Event)eventMock, (SimpleFlow)this.after)).thenReturn((Object)this.muleEventMock);
        ((Test)Mockito.doCallRealMethod().when((Object)this.testMock)).run();
        TestResult testResult = this.testMock.run();
        ((Test)Mockito.verify((Object)this.testMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.before));
        ((TestFlow)Mockito.verify((Object)this.testFlowMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class));
        ((Test)Mockito.verify((Object)this.testMock, (VerificationMode)Mockito.times((int)1))).run((Event)eventMock, (SimpleFlow)this.after);
    }

    @org.junit.Test
    public void runWithComponentExecutingExceptionShouldGetEvent() throws Throwable {
        CoreEvent eventMock = (CoreEvent)Mockito.mock(CoreEvent.class);
        ComponentExecutionException componentExecutionException = new ComponentExecutionException((Throwable)new RuntimeException(), (Event)eventMock);
        Mockito.when((Object)this.testMock.run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.before))).thenReturn((Object)this.muleEventMock);
        Mockito.when((Object)this.testFlowMock.run((Event)Mockito.any(Event.class))).thenThrow(new Throwable[]{componentExecutionException});
        Mockito.when((Object)this.testMock.run((Event)eventMock, (SimpleFlow)this.after)).thenReturn((Object)this.muleEventMock);
        ((Test)Mockito.doCallRealMethod().when((Object)this.testMock)).run();
        TestResult testResult = this.testMock.run();
        ((Test)Mockito.verify((Object)this.testMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class), (SimpleFlow)org.mockito.Matchers.eq((Object)this.before));
        ((TestFlow)Mockito.verify((Object)this.testFlowMock, (VerificationMode)Mockito.times((int)1))).run((Event)Mockito.any(Event.class));
        ((Test)Mockito.verify((Object)this.testMock, (VerificationMode)Mockito.times((int)1))).run((Event)eventMock, (SimpleFlow)this.after);
    }
}

