/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.component.properties;

import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.munit.runner.component.properties.DynamicPortPropertiesProvider;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationProperty;

public class DynamicPortPropertiesProviderTest {
    private DynamicPortPropertiesProvider dynamicPortPropertiesProvider;
    private static final String PROPERTY_NAME = "a.port";

    @Test
    public void findPort() {
        this.dynamicPortPropertiesProvider = new DynamicPortPropertiesProvider(PROPERTY_NAME, null, null);
        Optional configurationProperty = this.dynamicPortPropertiesProvider.getConfigurationProperty(PROPERTY_NAME);
        MatcherAssert.assertThat((Object)configurationProperty.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)Integer.valueOf((String)((ConfigurationProperty)configurationProperty.get()).getRawValue()), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void findPortWithMinAndMax() {
        Integer min = 4000;
        Integer max = 6000;
        this.dynamicPortPropertiesProvider = new DynamicPortPropertiesProvider(PROPERTY_NAME, min, max);
        Optional configurationProperty = this.dynamicPortPropertiesProvider.getConfigurationProperty(PROPERTY_NAME);
        MatcherAssert.assertThat((Object)configurationProperty.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)Integer.valueOf((String)((ConfigurationProperty)configurationProperty.get()).getRawValue()), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)min));
        MatcherAssert.assertThat((Object)Integer.valueOf((String)((ConfigurationProperty)configurationProperty.get()).getRawValue()), (Matcher)Matchers.lessThanOrEqualTo((Comparable)max));
    }

    @Test(expected=IllegalArgumentException.class)
    public void illegalPorts() {
        Integer min = 6000;
        Integer max = 4000;
        this.dynamicPortPropertiesProvider = new DynamicPortPropertiesProvider(PROPERTY_NAME, min, max);
    }

    @Test
    public void description() {
        this.dynamicPortPropertiesProvider = new DynamicPortPropertiesProvider(PROPERTY_NAME, null, null);
        MatcherAssert.assertThat((Object)this.dynamicPortPropertiesProvider.getDescription(), (Matcher)Matchers.equalTo((Object)String.format("<munit:dynamic-port propertyName=\"%s\" >", PROPERTY_NAME)));
    }
}

