/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.model;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.munit.runner.model.MockTestFactory;
import org.mule.munit.runner.model.SuiteResult;
import org.mule.munit.runner.model.TestResult;

public class SuiteResultTest {
    @Test
    public void ifNoTestSucceedThenFail() {
        SuiteResult testSuite = new SuiteResult("testSuite");
        testSuite.add(MockTestFactory.failingTest("test1"));
        testSuite.add(MockTestFactory.failingTest("test2"));
        Assert.assertFalse((boolean)testSuite.hasSucceeded());
    }

    @Test
    public void ifOneTestFailedThenFail() {
        SuiteResult testSuite = new SuiteResult("testSuite");
        testSuite.add(MockTestFactory.failingTest("test1"));
        testSuite.add(MockTestFactory.succeedTest("test2"));
        Assert.assertFalse((boolean)testSuite.hasSucceeded());
    }

    @Test
    public void ifAllSucceededThenSucceed() {
        SuiteResult testSuite = new SuiteResult("testSuite");
        testSuite.add(MockTestFactory.succeedTest("test1"));
        testSuite.add(MockTestFactory.succeedTest("test2"));
        Assert.assertTrue((boolean)testSuite.hasSucceeded());
    }

    @Test
    public void ifNoTestThenSucceed() {
        Assert.assertTrue((boolean)new SuiteResult("testSuite").hasSucceeded());
    }

    @Test
    public void retrieveTheNumberOfFailingTests() {
        SuiteResult testSuite = new SuiteResult("testSuite");
        testSuite.add(MockTestFactory.failingTest("test0"));
        testSuite.add(MockTestFactory.failingTest("test1"));
        testSuite.add(MockTestFactory.succeedTest("test2"));
        testSuite.add(MockTestFactory.errorTest("test3"));
        Assert.assertFalse((boolean)testSuite.hasSucceeded());
        Assert.assertEquals((long)2L, (long)testSuite.getNumberOfFailures());
    }

    @Test
    public void returnZeroIfNoFailingTestFound() {
        SuiteResult testSuite = new SuiteResult("testSuite");
        testSuite.add(MockTestFactory.succeedTest("test2"));
        testSuite.add(MockTestFactory.errorTest("test3"));
        Assert.assertFalse((boolean)testSuite.hasSucceeded());
        Assert.assertEquals((long)0L, (long)testSuite.getNumberOfFailures());
    }

    @Test
    public void retrieveTheNumberOfErrorTests() {
        SuiteResult testSuite = new SuiteResult("testSuite");
        testSuite.add(MockTestFactory.failingTest("test1"));
        testSuite.add(MockTestFactory.succeedTest("test2"));
        testSuite.add(MockTestFactory.errorTest("test3"));
        testSuite.add(MockTestFactory.errorTest("test4"));
        Assert.assertFalse((boolean)testSuite.hasSucceeded());
        Assert.assertEquals((long)2L, (long)testSuite.getNumberOfErrors());
    }

    @Test
    public void returnZeroIfNoErrorFound() {
        SuiteResult testSuite = new SuiteResult("testSuite");
        testSuite.add(MockTestFactory.failingTest("test1"));
        testSuite.add(MockTestFactory.succeedTest("test2"));
        Assert.assertFalse((boolean)testSuite.hasSucceeded());
        Assert.assertEquals((long)0L, (long)testSuite.getNumberOfErrors());
    }

    @Test
    public void returnTheCorrectNumberOfErrorTests() {
        SuiteResult testSuite = new SuiteResult("testSuite");
        testSuite.add(MockTestFactory.failingTest("test1"));
        testSuite.add(MockTestFactory.succeedTest("test2"));
        testSuite.add(MockTestFactory.errorTest("test3"));
        testSuite.add(MockTestFactory.errorTest("test4"));
        List errorTests = testSuite.getErrorTests();
        Assert.assertEquals((long)2L, (long)errorTests.size());
        Assert.assertEquals((Object)"test3", (Object)((TestResult)errorTests.get(0)).getName());
        Assert.assertEquals((Object)"test4", (Object)((TestResult)errorTests.get(1)).getName());
    }

    @Test
    public void returnTheCorrectNumberOfFailingTests() {
        SuiteResult testSuite = new SuiteResult("testSuite");
        testSuite.add(MockTestFactory.failingTest("test1"));
        testSuite.add(MockTestFactory.succeedTest("test2"));
        testSuite.add(MockTestFactory.errorTest("test3"));
        testSuite.add(MockTestFactory.errorTest("test4"));
        List failingTests = testSuite.getFailingTests();
        Assert.assertEquals((long)1L, (long)failingTests.size());
        Assert.assertEquals((Object)"test1", (Object)((TestResult)failingTests.get(0)).getName());
    }
}

