/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.munit.common.model.Attachment;
import org.mule.munit.common.model.EventAttributes;
import org.mule.munit.common.model.Payload;
import org.mule.munit.common.model.Property;
import org.mule.munit.common.model.UntypedEventError;
import org.mule.munit.common.model.Variable;
import org.mule.munit.runner.config.MunitComponentBuildingDefinitionProvider;
import org.mule.munit.runner.flow.AfterSuite;
import org.mule.munit.runner.flow.AfterTest;
import org.mule.munit.runner.flow.BeforeSuite;
import org.mule.munit.runner.flow.BeforeTest;
import org.mule.munit.runner.flow.TestFlow;
import org.mule.munit.runner.processors.EnableFlowSources;
import org.mule.munit.runner.processors.MunitModule;
import org.mule.munit.runner.processors.SetEventProcessor;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.AttributeDefinitionVisitor;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.KeyAttributeDefinitionPair;
import org.mule.runtime.dsl.api.component.SetterAttributeDefinition;
import org.mule.runtime.dsl.api.component.TypeConverter;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.runtime.dsl.api.component.TypeDefinitionVisitor;

public class MunitComponentBuildingDefinitionProviderTest {
    private static final String NAME_SPACE = "munit";
    private MunitComponentBuildingDefinitionProvider provider;
    private List<ComponentBuildingDefinition> definitions;

    @Before
    public void setUp() {
        this.provider = new MunitComponentBuildingDefinitionProvider();
        this.definitions = this.provider.getComponentBuildingDefinitions();
    }

    @Test
    public void checkDefinitionsSize() {
        Assert.assertEquals((String)"The number of definition is not correct there are missing or extra definitions", (long)33L, (long)this.definitions.size());
    }

    @Test
    public void isConfigDefinitionValid() {
        Class<MunitModule> typeClass = MunitModule.class;
        String definitionIdentifierName = "config";
        ArrayList<String> setterParameterNames = new ArrayList<String>();
        setterParameterNames.add("parameterizations");
        setterParameterNames.add("minMuleVersion");
        setterParameterNames.add("ignore");
        setterParameterNames.add("requiredProduct");
        ComponentBuildingDefinition definition = this.findDefinition(definitionIdentifierName);
        Assert.assertNotNull((String)("The " + definitionIdentifierName + " should not be null"), (Object)definition);
        definition.getTypeDefinition().visit((TypeDefinitionVisitor)new TypeAssertionVisitor(typeClass));
        this.assertSetterParametersNames(definition, setterParameterNames);
    }

    @Test
    public void isEnableFlowSourcesDefinitionValid() {
        Class<EnableFlowSources> typeClass = EnableFlowSources.class;
        String definitionIdentifierName = "enable-flow-sources";
        ArrayList<String> setterParameterNames = new ArrayList<String>();
        setterParameterNames.add("flows");
        ComponentBuildingDefinition definition = this.findDefinition(definitionIdentifierName);
        Assert.assertNotNull((String)("The " + definitionIdentifierName + " should not be null"), (Object)definition);
        definition.getTypeDefinition().visit((TypeDefinitionVisitor)new TypeAssertionVisitor(typeClass));
        this.assertSetterParametersNames(definition, setterParameterNames);
    }

    @Test
    public void isTestDefinitionValid() {
        Class<TestFlow> typeClass = TestFlow.class;
        String definitionIdentifierName = "test";
        ArrayList<String> constructorParameterNames = new ArrayList<String>();
        ArrayList<String> setterParameterNames = new ArrayList<String>();
        setterParameterNames.add("ignore");
        setterParameterNames.add("description");
        setterParameterNames.add("expectedErrorType");
        setterParameterNames.add("expectedException");
        setterParameterNames.add("tags");
        setterParameterNames.add("enableFlowSources");
        setterParameterNames.add("processorChains");
        setterParameterNames.add("timeOut");
        setterParameterNames.add("expectedErrorDescription");
        ComponentBuildingDefinition definition = this.findDefinition(definitionIdentifierName);
        this.assertDefinition(definition, definitionIdentifierName, false, typeClass, setterParameterNames, constructorParameterNames);
    }

    @Test
    public void isBeforeSuiteDefinitionValid() {
        Class<BeforeSuite> typeClass = BeforeSuite.class;
        String definitionIdentifierName = "before-suite";
        ArrayList<String> constructorParameterNames = new ArrayList<String>();
        ArrayList<String> setterParameterNames = new ArrayList<String>();
        setterParameterNames.add("description");
        setterParameterNames.add("processors");
        ComponentBuildingDefinition definition = this.findDefinition(definitionIdentifierName);
        this.assertDefinition(definition, definitionIdentifierName, false, typeClass, setterParameterNames, constructorParameterNames);
    }

    @Test
    public void isBeforeTestDefinitionValid() {
        Class<BeforeTest> typeClass = BeforeTest.class;
        String definitionIdentifierName = "before-test";
        ArrayList<String> constructorParameterNames = new ArrayList<String>();
        ArrayList<String> setterParameterNames = new ArrayList<String>();
        setterParameterNames.add("description");
        setterParameterNames.add("processors");
        ComponentBuildingDefinition definition = this.findDefinition(definitionIdentifierName);
        this.assertDefinition(definition, definitionIdentifierName, false, typeClass, setterParameterNames, constructorParameterNames);
    }

    @Test
    public void isAfterTestDefinitionValid() {
        Class<AfterTest> typeClass = AfterTest.class;
        String definitionIdentifierName = "after-test";
        ArrayList<String> constructorParameterNames = new ArrayList<String>();
        ArrayList<String> setterParameterNames = new ArrayList<String>();
        setterParameterNames.add("description");
        setterParameterNames.add("processors");
        ComponentBuildingDefinition definition = this.findDefinition(definitionIdentifierName);
        this.assertDefinition(definition, definitionIdentifierName, false, typeClass, setterParameterNames, constructorParameterNames);
    }

    @Test
    public void isAfterSuiteDefinitionValid() {
        Class<AfterSuite> typeClass = AfterSuite.class;
        String definitionIdentifierName = "after-suite";
        ArrayList<String> constructorParameterNames = new ArrayList<String>();
        ArrayList<String> setterParameterNames = new ArrayList<String>();
        setterParameterNames.add("description");
        setterParameterNames.add("processors");
        ComponentBuildingDefinition definition = this.findDefinition(definitionIdentifierName);
        this.assertDefinition(definition, definitionIdentifierName, false, typeClass, setterParameterNames, constructorParameterNames);
    }

    @Test
    public void isSetDefinitionValid() {
        Class<SetEventProcessor> typeClass = SetEventProcessor.class;
        String definitionIdentifierName = "set-event";
        ArrayList<String> constructorParameterNames = new ArrayList<String>();
        ArrayList<String> setterParameterNames = new ArrayList<String>();
        setterParameterNames.add("cloneOriginalEvent");
        setterParameterNames.add("payload");
        setterParameterNames.add("variables");
        setterParameterNames.add("attributes");
        setterParameterNames.add("error");
        setterParameterNames.add("inboundProperties");
        setterParameterNames.add("sessionProperties");
        setterParameterNames.add("outboundProperties");
        setterParameterNames.add("inboundAttachments");
        setterParameterNames.add("outboundAttachments");
        ComponentBuildingDefinition definition = this.findDefinition(definitionIdentifierName);
        this.assertDefinition(definition, definitionIdentifierName, true, typeClass, setterParameterNames, constructorParameterNames);
    }

    @Test
    public void isPayloadDefinitionValid() {
        Class<Payload> typeClass = Payload.class;
        String definitionIdentifierName = "payload";
        ArrayList<String> constructorParameterNames = new ArrayList<String>();
        ArrayList<String> setterParameterNames = new ArrayList<String>();
        setterParameterNames.add("value");
        setterParameterNames.add("mediaType");
        setterParameterNames.add("encoding");
        ComponentBuildingDefinition definition = this.findDefinition(definitionIdentifierName);
        this.assertDefinition(definition, definitionIdentifierName, false, typeClass, setterParameterNames, constructorParameterNames);
    }

    @Test
    public void isVariablesDefinitionValid() {
        Class<List> typeClass = List.class;
        String definitionIdentifierName = "variables";
        ArrayList<String> constructorParameterNames = new ArrayList<String>();
        ArrayList<String> setterParameterNames = new ArrayList<String>();
        ComponentBuildingDefinition definition = this.findDefinition(definitionIdentifierName);
        this.assertDefinition(definition, definitionIdentifierName, false, typeClass, setterParameterNames, constructorParameterNames);
    }

    @Test
    public void isAttributesDefinitionValid() {
        Class<EventAttributes> typeClass = EventAttributes.class;
        String definitionIdentifierName = "attributes";
        ArrayList<String> constructorParameterNames = new ArrayList<String>();
        ArrayList<String> setterParameterNames = new ArrayList<String>();
        setterParameterNames.add("value");
        setterParameterNames.add("encoding");
        setterParameterNames.add("mediaType");
        ComponentBuildingDefinition definition = this.findDefinition(definitionIdentifierName);
        this.assertDefinition(definition, definitionIdentifierName, false, typeClass, setterParameterNames, constructorParameterNames);
    }

    @Test
    public void isErrorDefinitionValid() {
        Class<UntypedEventError> typeClass = UntypedEventError.class;
        String definitionIdentifierName = "error";
        ArrayList<String> constructorParameterNames = new ArrayList<String>();
        ArrayList<String> setterParameterNames = new ArrayList<String>();
        setterParameterNames.add("typeId");
        setterParameterNames.add("cause");
        ComponentBuildingDefinition definition = this.findDefinition(definitionIdentifierName);
        this.assertDefinition(definition, definitionIdentifierName, false, typeClass, setterParameterNames, constructorParameterNames);
    }

    @Test
    public void isInboundPropertiesDefinitionValid() {
        Class<List> typeClass = List.class;
        String definitionIdentifierName = "inbound-properties";
        ArrayList<String> constructorParameterNames = new ArrayList<String>();
        ArrayList<String> setterParameterNames = new ArrayList<String>();
        ComponentBuildingDefinition definition = this.findDefinition(definitionIdentifierName);
        this.assertDefinition(definition, definitionIdentifierName, false, typeClass, setterParameterNames, constructorParameterNames);
    }

    @Test
    public void isSessionPropertiesDefinitionValid() {
        Class<List> typeClass = List.class;
        String definitionIdentifierName = "session-properties";
        ArrayList<String> constructorParameterNames = new ArrayList<String>();
        ArrayList<String> setterParameterNames = new ArrayList<String>();
        ComponentBuildingDefinition definition = this.findDefinition(definitionIdentifierName);
        this.assertDefinition(definition, definitionIdentifierName, false, typeClass, setterParameterNames, constructorParameterNames);
    }

    @Test
    public void isOutboundPropertiesDefinitionValid() {
        Class<List> typeClass = List.class;
        String definitionIdentifierName = "outbound-properties";
        ArrayList<String> constructorParameterNames = new ArrayList<String>();
        ArrayList<String> setterParameterNames = new ArrayList<String>();
        ComponentBuildingDefinition definition = this.findDefinition(definitionIdentifierName);
        this.assertDefinition(definition, definitionIdentifierName, false, typeClass, setterParameterNames, constructorParameterNames);
    }

    @Test
    public void isInboundAttachmentsDefinitionValid() {
        Class<List> typeClass = List.class;
        String definitionIdentifierName = "inbound-attachments";
        ArrayList<String> constructorParameterNames = new ArrayList<String>();
        ArrayList<String> setterParameterNames = new ArrayList<String>();
        ComponentBuildingDefinition definition = this.findDefinition(definitionIdentifierName);
        this.assertDefinition(definition, definitionIdentifierName, false, typeClass, setterParameterNames, constructorParameterNames);
    }

    @Test
    public void isOutboundAttachmentsDefinitionValid() {
        Class<List> typeClass = List.class;
        String definitionIdentifierName = "outbound-attachments";
        ArrayList<String> constructorParameterNames = new ArrayList<String>();
        ArrayList<String> setterParameterNames = new ArrayList<String>();
        ComponentBuildingDefinition definition = this.findDefinition(definitionIdentifierName);
        this.assertDefinition(definition, definitionIdentifierName, false, typeClass, setterParameterNames, constructorParameterNames);
    }

    @Test
    public void isVariableDefinitionValid() {
        Class<Variable> typeClass = Variable.class;
        String definitionIdentifierName = "variable";
        ArrayList<String> constructorParameterNames = new ArrayList<String>();
        ArrayList<String> setterParameterNames = new ArrayList<String>();
        setterParameterNames.add("key");
        setterParameterNames.add("value");
        setterParameterNames.add("mediaType");
        setterParameterNames.add("encoding");
        ComponentBuildingDefinition definition = this.findDefinition(definitionIdentifierName);
        this.assertDefinition(definition, definitionIdentifierName, false, typeClass, setterParameterNames, constructorParameterNames);
    }

    @Test
    public void isInboundPropertyDefinitionValid() {
        Class<Property> typeClass = Property.class;
        String definitionIdentifierName = "inbound-property";
        ArrayList<String> constructorParameterNames = new ArrayList<String>();
        ArrayList<String> setterParameterNames = new ArrayList<String>();
        setterParameterNames.add("key");
        setterParameterNames.add("value");
        setterParameterNames.add("mediaType");
        setterParameterNames.add("encoding");
        ComponentBuildingDefinition definition = this.findDefinition(definitionIdentifierName);
        this.assertDefinition(definition, definitionIdentifierName, false, typeClass, setterParameterNames, constructorParameterNames);
    }

    @Test
    public void isSessionPropertyDefinitionValid() {
        Class<Property> typeClass = Property.class;
        String definitionIdentifierName = "session-property";
        ArrayList<String> constructorParameterNames = new ArrayList<String>();
        ArrayList<String> setterParameterNames = new ArrayList<String>();
        setterParameterNames.add("key");
        setterParameterNames.add("value");
        setterParameterNames.add("mediaType");
        setterParameterNames.add("encoding");
        ComponentBuildingDefinition definition = this.findDefinition(definitionIdentifierName);
        this.assertDefinition(definition, definitionIdentifierName, false, typeClass, setterParameterNames, constructorParameterNames);
    }

    @Test
    public void isOutboundPropertyDefinitionValid() {
        Class<Property> typeClass = Property.class;
        String definitionIdentifierName = "outbound-property";
        ArrayList<String> constructorParameterNames = new ArrayList<String>();
        ArrayList<String> setterParameterNames = new ArrayList<String>();
        setterParameterNames.add("key");
        setterParameterNames.add("value");
        setterParameterNames.add("mediaType");
        setterParameterNames.add("encoding");
        ComponentBuildingDefinition definition = this.findDefinition(definitionIdentifierName);
        this.assertDefinition(definition, definitionIdentifierName, false, typeClass, setterParameterNames, constructorParameterNames);
    }

    @Test
    public void isInboundAttachmentDefinitionValid() {
        Class<Attachment> typeClass = Attachment.class;
        String definitionIdentifierName = "inbound-attachment";
        ArrayList<String> constructorParameterNames = new ArrayList<String>();
        ArrayList<String> setterParameterNames = new ArrayList<String>();
        setterParameterNames.add("key");
        setterParameterNames.add("value");
        setterParameterNames.add("mediaType");
        setterParameterNames.add("encoding");
        ComponentBuildingDefinition definition = this.findDefinition(definitionIdentifierName);
        this.assertDefinition(definition, definitionIdentifierName, false, typeClass, setterParameterNames, constructorParameterNames);
    }

    @Test
    public void isOutboundAttachmentDefinitionValid() {
        Class<Attachment> typeClass = Attachment.class;
        String definitionIdentifierName = "outbound-attachment";
        ArrayList<String> constructorParameterNames = new ArrayList<String>();
        ArrayList<String> setterParameterNames = new ArrayList<String>();
        setterParameterNames.add("key");
        setterParameterNames.add("value");
        setterParameterNames.add("mediaType");
        setterParameterNames.add("encoding");
        ComponentBuildingDefinition definition = this.findDefinition(definitionIdentifierName);
        this.assertDefinition(definition, definitionIdentifierName, false, typeClass, setterParameterNames, constructorParameterNames);
    }

    private void assertDefinition(ComponentBuildingDefinition definition, String definitionIdentifierName, Boolean isPrototype, Class typeClass, List<String> setterParameterNames, List<String> constructorParameterNames) {
        Assert.assertNotNull((String)("The " + definitionIdentifierName + " should not be null"), (Object)definition);
        Assert.assertEquals((String)"The definition scope is wrong", (Object)isPrototype, (Object)definition.isPrototype());
        definition.getTypeDefinition().visit((TypeDefinitionVisitor)new TypeAssertionVisitor(typeClass));
        this.assertConstructorParametersNames(definition, constructorParameterNames);
        this.assertSetterParametersNames(definition, setterParameterNames);
    }

    private ComponentBuildingDefinition findDefinition(String identifierName) {
        for (ComponentBuildingDefinition d : this.definitions) {
            if (!NAME_SPACE.equals(d.getComponentIdentifier().getNamespace()) || !identifierName.equals(d.getComponentIdentifier().getName())) continue;
            return d;
        }
        return null;
    }

    private void assertSetterParametersNames(ComponentBuildingDefinition definition, List<String> expectedNames) {
        Assert.assertEquals((String)"There number of setter parameters is wrong", (long)expectedNames.size(), (long)definition.getSetterParameterDefinitions().size());
        definition.getSetterParameterDefinitions().forEach(p -> Assert.assertThat((String)("The parameter " + ((SetterAttributeDefinition)p).getAttributeName() + " is invalid"), (Object)expectedNames.contains(((SetterAttributeDefinition)p).getAttributeName()), (Matcher)Matchers.is((Object)true)));
    }

    private void assertConstructorParametersNames(ComponentBuildingDefinition definition, List<String> expectedNames) {
        Assert.assertThat((String)"The number of constructor parameters is wrong", (Object)definition.getConstructorAttributeDefinition().size(), (Matcher)Matchers.is((Object)expectedNames.size()));
        AttributeDefinitionAssertionVisitor visitor = new AttributeDefinitionAssertionVisitor(expectedNames);
        definition.getConstructorAttributeDefinition().forEach(cp -> ((AttributeDefinition)cp).accept((AttributeDefinitionVisitor)visitor));
    }

    private static class AttributeDefinitionAssertionVisitor
    implements AttributeDefinitionVisitor {
        private List<String> attributeNames;

        public AttributeDefinitionAssertionVisitor(List<String> attributeNames) {
            this.attributeNames = attributeNames;
        }

        public void onReferenceObject(Class<?> aClass) {
        }

        public void onReferenceSimpleParameter(String s) {
        }

        public void onReferenceFixedParameter(String s) {
        }

        public void onFixedValue(Object o) {
        }

        public void onConfigurationParameter(String s, Object o, Optional<TypeConverter> optional) {
            Assert.assertThat((String)("The attribute " + s + " is not expected"), (Object)this.attributeNames.contains(s), (Matcher)Matchers.is((Object)true));
        }

        public void onUndefinedSimpleParameters() {
        }

        public void onUndefinedComplexParameters() {
        }

        public void onComplexChildCollection(Class<?> aClass, Optional<String> optional) {
        }

        public void onComplexChildMap(Class<?> aClass, Class<?> aClass1, String s) {
        }

        public void onComplexChild(Class<?> aClass, Optional<String> optional, Optional<String> optional1) {
        }

        public void onValueFromTextContent() {
        }

        public void onMultipleValues(KeyAttributeDefinitionPair[] keyAttributeDefinitionPairs) {
        }
    }

    private static class TypeAssertionVisitor
    implements TypeDefinitionVisitor {
        private Class<?> clazz;

        public TypeAssertionVisitor(Class<?> clazz) {
            this.clazz = clazz;
        }

        public void onType(Class<?> type) {
            Assert.assertEquals((String)"The type definition is wrong classes do not match.", this.clazz, type);
        }

        public void onConfigurationAttribute(String s, Class<?> aClass) {
        }

        public void onMapType(TypeDefinition.MapEntryType mapEntryType) {
        }
    }
}

