/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.flow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.AssertionFailedError;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.munit.common.exception.MunitError;
import org.mule.munit.runner.flow.TestFlow;
import org.mule.munit.runner.processors.EnableFlowSources;
import org.mule.munit.runner.processors.MunitModule;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.execution.ComponentExecutionException;
import org.mule.runtime.api.component.execution.ExecutionResult;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.lifecycle.StartException;
import org.mule.runtime.core.api.lifecycle.StopException;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.privileged.PrivilegedMuleContext;

public class TestFlowTest {
    private static final String ANY_ERROR_ID = "ANY";
    private static final String ROUTING_ERROR_ID = "ROUTING";
    private static final String TRANSFORMATION_ERROR_ID = "TRANSFORMATION";
    private static final String EXPECTED_ERROR_ID = "MULE:ROUTING";
    private static final String EXPECTED_ERROR_ID_EXP = "#['MULE:ROUTING']";
    private static final String EXPECTED_ERROR_ID_FAKE = "FAKE:ROUTING";
    private static final String EXPECTED_EXCEPTION = "java.lang.NullPointerException";
    private static final String EXPECTED_EXCEPTION_EXP = "#[exception.causedBy(java.lang.NullPointerException)]";
    private static final String EXPECTED_ERROR_MESSAGE = "An exception was thrown";
    private MunitModule munitModuleMock;
    private MuleConfiguration muleConfigurationMock;
    private ErrorTypeRepository errorTypeRepositoryMock;
    private ExtendedExpressionManager expressionManagerMock;
    private Registry registryMock;
    private PrivilegedMuleContext muleContextMock;
    private InternalEvent eventMock;
    private Error errorMock;
    private ErrorType errorTypeMock;
    private Throwable actualExceptionMock;
    private List<EnableFlowSources.FlowRef> enableFlowSources;
    @Rule
    public ExpectedException expectException = ExpectedException.none();

    @Before
    public void setUp() {
        this.munitModuleMock = (MunitModule)Mockito.mock(MunitModule.class);
        this.muleContextMock = (PrivilegedMuleContext)Mockito.mock(PrivilegedMuleContext.class);
        this.muleConfigurationMock = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
        this.expressionManagerMock = (ExtendedExpressionManager)Mockito.mock(ExtendedExpressionManager.class);
        this.errorTypeRepositoryMock = (ErrorTypeRepository)Mockito.mock(ErrorTypeRepository.class);
        this.eventMock = (InternalEvent)Mockito.mock(InternalEvent.class);
        this.errorMock = (Error)Mockito.mock(Error.class);
        this.errorTypeMock = (ErrorType)Mockito.mock(ErrorType.class);
        this.actualExceptionMock = (Throwable)Mockito.mock(Exception.class);
        this.enableFlowSources = new ArrayList<EnableFlowSources.FlowRef>();
        EnableFlowSources.FlowRef flowRef = new EnableFlowSources.FlowRef();
        flowRef.setFlow((Component)Mockito.mock(Flow.class));
        this.enableFlowSources.add(flowRef);
        this.registryMock = (Registry)Mockito.mock(Registry.class);
        Mockito.when((Object)this.muleContextMock.getConfiguration()).thenReturn((Object)this.muleConfigurationMock);
        Mockito.when((Object)this.muleConfigurationMock.getDefaultProcessingStrategyFactory()).thenReturn(null);
        Mockito.when((Object)this.eventMock.getError()).thenReturn(Optional.of(this.errorMock));
        Mockito.when((Object)this.errorMock.getErrorType()).thenReturn((Object)this.errorTypeMock);
        Mockito.when((Object)this.errorTypeMock.getNamespace()).thenReturn((Object)"MULE");
        Mockito.when((Object)this.errorTypeMock.getIdentifier()).thenReturn((Object)ANY_ERROR_ID);
        Mockito.when((Object)this.errorTypeRepositoryMock.getErrorType((ComponentIdentifier)Matchers.any(ComponentIdentifier.class))).thenReturn(Optional.of(this.errorTypeMock));
        Mockito.when((Object)this.registryMock.lookupByName(Matchers.anyString())).thenReturn(Optional.empty());
    }

    @Test(expected=MunitError.class)
    public void testFailSetIgnoreIfNull() {
        TestFlow testFlow = new TestFlow();
        testFlow.setIgnore(null);
    }

    @Test(expected=MunitError.class)
    public void testFailSetIgnoreIfEmptyString() {
        TestFlow testFlow = new TestFlow();
        testFlow.setIgnore("");
    }

    @Test(expected=MunitError.class)
    public void testInvalidIgnoreExpression() {
        TestFlow testFlow = new TestFlow();
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        Mockito.when((Object)this.expressionManagerMock.isExpression(Matchers.anyString())).thenReturn((Object)false);
        testFlow.setIgnore("INVALID EXPRESSION");
    }

    @Test
    public void validateSetters() {
        TestFlow testFlow = new TestFlow();
        testFlow.munitModule = Optional.of(this.munitModuleMock);
        testFlow.setExpectedErrorType(EXPECTED_ERROR_ID);
        testFlow.setExpectedException(EXPECTED_EXCEPTION);
        testFlow.setIgnore("true");
        MatcherAssert.assertThat((Object)testFlow.isIgnored(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)testFlow.getExpectedErrorType(), (Matcher)Is.is((Object)EXPECTED_ERROR_ID));
        MatcherAssert.assertThat((Object)testFlow.getExpectedException(), (Matcher)Is.is((Object)EXPECTED_EXCEPTION));
    }

    @Test
    public void validateSetEnableFlowSources() {
        TestFlow testFlow = new TestFlow();
        testFlow.setIgnore("false");
        testFlow.munitModule = Optional.of(this.munitModuleMock);
        EnableFlowSources.FlowRef flowRef = new EnableFlowSources.FlowRef();
        Flow flowMock = (Flow)Mockito.mock(Flow.class);
        MessageSource sourceMock = (MessageSource)Mockito.mock(MessageSource.class);
        Mockito.when((Object)flowMock.getSource()).thenReturn((Object)sourceMock);
        flowRef.setFlow((Component)flowMock);
        List<EnableFlowSources.FlowRef> enableFlowSources = Arrays.asList(flowRef);
        testFlow.setEnableFlowSources(enableFlowSources);
        MatcherAssert.assertThat((Object)testFlow.getEnableFlowSources(), (Matcher)Is.is(enableFlowSources));
        ((MunitModule)Mockito.verify((Object)this.munitModuleMock, (VerificationMode)Mockito.times((int)1))).addEnableFlowSources(enableFlowSources);
    }

    @Test
    public void validateSetEnableFlowSourcesTestIgnored() {
        TestFlow testFlow = new TestFlow();
        testFlow.munitModule = Optional.of(this.munitModuleMock);
        testFlow.setIgnore("true");
        testFlow.setEnableFlowSources(this.enableFlowSources);
        MatcherAssert.assertThat((Object)testFlow.getEnableFlowSources(), (Matcher)Is.is(this.enableFlowSources));
        ((MunitModule)Mockito.verify((Object)this.munitModuleMock, (VerificationMode)Mockito.times((int)0))).addEnableFlowSources(this.enableFlowSources);
    }

    @Test
    public void errorIdMatchesExpectedError() {
        this.mockEvaluateIfExpression(EXPECTED_ERROR_ID, false, null);
        TestFlow testFlow = new TestFlow();
        testFlow.setExpectedErrorType(EXPECTED_ERROR_ID);
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        MatcherAssert.assertThat((Object)testFlow.validateExpected(this.error(this.actualExceptionMock), (Event)this.eventMock).isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void errorIdMatchesExpectedErrorExpression() {
        this.mockEvaluateIfExpression(EXPECTED_ERROR_ID_EXP, true, EXPECTED_ERROR_ID);
        TestFlow testFlow = new TestFlow();
        testFlow.setExpectedErrorType(EXPECTED_ERROR_ID_EXP);
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        MatcherAssert.assertThat((Object)testFlow.validateExpected(this.error(this.actualExceptionMock), (Event)this.eventMock).isPresent(), (Matcher)Is.is((Object)false));
        ((ExtendedExpressionManager)Mockito.verify((Object)this.expressionManagerMock, (VerificationMode)Mockito.atLeastOnce())).evaluate(EXPECTED_ERROR_ID_EXP, (CoreEvent)this.eventMock);
    }

    @Test(expected=MunitError.class)
    public void expectErrorExpressionIsNotString() {
        this.mockEvaluateIfExpression(EXPECTED_ERROR_ID_EXP, true, 1);
        TestFlow testFlow = new TestFlow();
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        testFlow.setExpectedErrorType(EXPECTED_ERROR_ID_EXP);
        testFlow.validateExpected(this.error(this.actualExceptionMock), (Event)this.eventMock);
    }

    @Test(expected=MunitError.class)
    public void expectErrorExpressionReturnNonExistentErrorId() {
        this.mockEvaluateIfExpression(EXPECTED_ERROR_ID_FAKE, false, null);
        Mockito.when((Object)this.errorTypeRepositoryMock.getErrorType((ComponentIdentifier)Matchers.any(ComponentIdentifier.class))).thenThrow(new Throwable[]{new IllegalStateException()});
        TestFlow testFlow = new TestFlow();
        testFlow.setExpectedErrorType(EXPECTED_ERROR_ID_FAKE);
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        testFlow.validateExpected(this.error(this.actualExceptionMock), (Event)this.eventMock);
    }

    @Ignore
    @Test
    public void errorIdDoesNotMatchesExpectedError() {
        this.mockEvaluateIfExpression(EXPECTED_ERROR_ID, false, null);
        Mockito.when((Object)this.errorTypeMock.getIdentifier()).thenReturn((Object)TRANSFORMATION_ERROR_ID);
        TestFlow testFlow = new TestFlow();
        testFlow.setExpectedErrorType(EXPECTED_ERROR_ID);
        MatcherAssert.assertThat((Object)testFlow.validateExpected(this.error(this.actualExceptionMock), (Event)this.eventMock).isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void exceptionMatchesExpectedExpression() {
        this.mockEvaluateIfExpression(EXPECTED_EXCEPTION_EXP, true, Boolean.TRUE);
        TestFlow testFlow = new TestFlow();
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        testFlow.setExpectedException(EXPECTED_EXCEPTION_EXP);
        MatcherAssert.assertThat((Object)testFlow.validateExpected(this.error(this.actualExceptionMock), (Event)this.eventMock).isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void exceptionDoesNotMatchExpression() {
        this.mockEvaluateIfExpression(EXPECTED_EXCEPTION_EXP, true, Boolean.FALSE);
        TestFlow testFlow = new TestFlow();
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        testFlow.setExpectedException(EXPECTED_EXCEPTION_EXP);
        MatcherAssert.assertThat((Object)testFlow.validateExpected(this.error(this.actualExceptionMock), (Event)this.eventMock).isPresent(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void exceptionLiteralMatchesActualExceptionClass() {
        this.mockEvaluateIfExpression(EXPECTED_EXCEPTION, false, null);
        TestFlow testFlow = new TestFlow();
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        testFlow.setExpectedException(EXPECTED_EXCEPTION);
        MatcherAssert.assertThat((Object)testFlow.validateExpected(this.error(new NullPointerException()), (Event)this.eventMock).isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void exceptionLiteralMatchesAsSubTypeOfExceptionClass() {
        this.mockEvaluateIfExpression(EXPECTED_EXCEPTION, false, null);
        this.actualExceptionMock = new SpecificNullPointerException();
        TestFlow testFlow = new TestFlow();
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        testFlow.setExpectedException(EXPECTED_EXCEPTION);
        MatcherAssert.assertThat((Object)testFlow.validateExpected(this.error(this.actualExceptionMock), (Event)this.eventMock).isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void exceptionLiteralDoesNotMatchException() {
        this.mockEvaluateIfExpression(EXPECTED_EXCEPTION, false, null);
        this.actualExceptionMock = new IllegalArgumentException();
        TestFlow testFlow = new TestFlow();
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        testFlow.setExpectedException(EXPECTED_EXCEPTION);
        MatcherAssert.assertThat((Object)testFlow.validateExpected(this.error(this.actualExceptionMock), (Event)this.eventMock).isPresent(), (Matcher)Is.is((Object)true));
    }

    @Test(expected=MunitError.class)
    public void expectedExceptionClassNotFound() {
        this.mockEvaluateIfExpression(EXPECTED_EXCEPTION, false, null);
        TestFlow testFlow = new TestFlow();
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        testFlow.setExpectedException("org.my.FakeClass");
        testFlow.validateExpected(this.error(new Exception((Throwable)new AssertionFailedError())), (Event)this.eventMock);
    }

    @Test
    public void exceptionWithNoCauseExceptionDoesNotMatch() {
        this.mockEvaluateIfExpression(EXPECTED_EXCEPTION, false, null);
        TestFlow testFlow = new TestFlow();
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        testFlow.setExpectedException(EXPECTED_EXCEPTION);
        MatcherAssert.assertThat((Object)testFlow.validateExpected(this.error(new Exception((Throwable)null)), (Event)this.eventMock).isPresent(), (Matcher)Is.is((Object)true));
    }

    @Test(expected=MunitError.class)
    public void failingExpressionInExpectException() {
        String weirdExpression = "#[']";
        this.mockEvaluateIfExpression(weirdExpression, false, null);
        TestFlow testFlow = new TestFlow();
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        testFlow.setExpectedException(weirdExpression);
        testFlow.validateExpected(this.error(this.actualExceptionMock), (Event)this.eventMock);
    }

    @Test(expected=MunitError.class)
    public void messagingWithNonBooleanMelInCauseException() {
        String expectExceptionExp = "#[{'':''}]";
        HashMap<String, String> mockMap = new HashMap<String, String>();
        mockMap.put("", "");
        this.mockEvaluateIfExpression(expectExceptionExp, true, mockMap);
        TestFlow testFlow = new TestFlow();
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        testFlow.setExpectedException(expectExceptionExp);
        testFlow.validateExpected(this.error(this.actualExceptionMock), (Event)this.eventMock);
    }

    @Test
    public void failureIsExpectedButNothingIsThrownItShouldFail() throws Throwable {
        String testName = "test name";
        String expectedErrorType = ANY_ERROR_ID;
        String expectedException = "AssertionError";
        String expectedErrorDescriptionTemplate = "The test: %s was expecting a failure - Error ID: %s - Exception: %s but it didn't fail";
        Event resultEventMock = (Event)Mockito.mock(Event.class);
        InternalEvent eventMock = (InternalEvent)Mockito.mock(InternalEvent.class);
        Mockito.when((Object)resultEventMock.getError()).thenReturn(Optional.empty());
        TestFlow testFlowMock = (TestFlow)Mockito.mock(TestFlow.class);
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlowMock)).setExpectedErrorType(ANY_ERROR_ID);
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlowMock)).setExpectedException("AssertionError");
        testFlowMock.setExpectedErrorType(ANY_ERROR_ID);
        testFlowMock.setExpectedException("AssertionError");
        Mockito.when((Object)testFlowMock.isExpectingFailure()).thenReturn((Object)true);
        Mockito.when((Object)testFlowMock.doExecute((Event)Matchers.any(Event.class))).thenReturn((Object)resultEventMock);
        Mockito.when((Object)testFlowMock.getName()).thenReturn((Object)"test name");
        this.expectException.expect(AssertionError.class);
        this.expectException.expectMessage(String.format("The test: %s was expecting a failure - Error ID: %s - Exception: %s but it didn't fail", "test name", ANY_ERROR_ID, "AssertionError"));
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlowMock)).run((Event)eventMock);
        testFlowMock.run((Event)eventMock);
    }

    @Test
    public void errorTypeWasExpectedButNothingIsThrown() throws Throwable {
        String testName = "test name";
        String expectedErrorType = ANY_ERROR_ID;
        String expectedErrorDescriptionTemplate = "The test: %s was expecting a failure - Error ID: %s but it didn't fail";
        Event resultEventMock = (Event)Mockito.mock(Event.class);
        InternalEvent eventMock = (InternalEvent)Mockito.mock(InternalEvent.class);
        Mockito.when((Object)resultEventMock.getError()).thenReturn(Optional.empty());
        TestFlow testFlowMock = (TestFlow)Mockito.mock(TestFlow.class);
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlowMock)).setExpectedErrorType(ANY_ERROR_ID);
        testFlowMock.setExpectedErrorType(ANY_ERROR_ID);
        Mockito.when((Object)testFlowMock.isExpectingFailure()).thenReturn((Object)true);
        Mockito.when((Object)testFlowMock.doExecute((Event)Matchers.any(Event.class))).thenReturn((Object)resultEventMock);
        Mockito.when((Object)testFlowMock.getName()).thenReturn((Object)"test name");
        this.expectException.expect(AssertionError.class);
        this.expectException.expectMessage(String.format("The test: %s was expecting a failure - Error ID: %s but it didn't fail", "test name", ANY_ERROR_ID));
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlowMock)).run((Event)eventMock);
        testFlowMock.run((Event)eventMock);
    }

    @Test
    public void expectedExceptionWasExpectedButNothingIsThrown() throws Throwable {
        String testName = "test name";
        String expectedException = "AssertionError";
        String expectedErrorDescriptionTemplate = "The test: %s was expecting a failure - Exception: %s but it didn't fail";
        Event resultEventMock = (Event)Mockito.mock(Event.class);
        InternalEvent eventMock = (InternalEvent)Mockito.mock(InternalEvent.class);
        Mockito.when((Object)resultEventMock.getError()).thenReturn(Optional.empty());
        TestFlow testFlowMock = (TestFlow)Mockito.mock(TestFlow.class);
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlowMock)).setExpectedException("AssertionError");
        testFlowMock.setExpectedException("AssertionError");
        Mockito.when((Object)testFlowMock.isExpectingFailure()).thenReturn((Object)true);
        Mockito.when((Object)testFlowMock.doExecute((Event)Matchers.any(Event.class))).thenReturn((Object)resultEventMock);
        Mockito.when((Object)testFlowMock.getName()).thenReturn((Object)"test name");
        this.expectException.expect(AssertionError.class);
        this.expectException.expectMessage(String.format("The test: %s was expecting a failure - Exception: %s but it didn't fail", "test name", "AssertionError"));
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlowMock)).run((Event)eventMock);
        testFlowMock.run((Event)eventMock);
    }

    @Test
    public void expectedErrorDescriptionWasExpectedButNothingIsThrown() throws Throwable {
        String testName = "test name";
        String expectedErrorDescription = "An error was thrown";
        String expectedErrorDescriptionTemplate = "The test: %s was expecting a failure - Error Description: %s but it didn't fail";
        Event resultEventMock = (Event)Mockito.mock(Event.class);
        InternalEvent eventMock = (InternalEvent)Mockito.mock(InternalEvent.class);
        Mockito.when((Object)resultEventMock.getError()).thenReturn(Optional.empty());
        TestFlow testFlowMock = (TestFlow)Mockito.mock(TestFlow.class);
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlowMock)).setExpectedErrorDescription("An error was thrown");
        testFlowMock.setExpectedErrorDescription("An error was thrown");
        Mockito.when((Object)testFlowMock.isExpectingFailure()).thenReturn((Object)true);
        Mockito.when((Object)testFlowMock.doExecute((Event)Matchers.any(Event.class))).thenReturn((Object)resultEventMock);
        Mockito.when((Object)testFlowMock.getName()).thenReturn((Object)"test name");
        this.expectException.expect(AssertionError.class);
        this.expectException.expectMessage(String.format("The test: %s was expecting a failure - Error Description: %s but it didn't fail", "test name", "An error was thrown"));
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlowMock)).run((Event)eventMock);
        testFlowMock.run((Event)eventMock);
    }

    @Test
    public void failureIsExpectedAndMatchesCauseItShouldSucceed() throws Throwable {
        TestFlow testFlow = (TestFlow)Mockito.mock(TestFlow.class);
        testFlow.setExpectedException(EXPECTED_EXCEPTION);
        Mockito.when((Object)testFlow.isExpectingFailure()).thenReturn((Object)true);
        Mockito.when((Object)testFlow.validateExpected((Error)Matchers.any(), (Event)Matchers.any())).thenReturn(Optional.empty());
        Event failureEvent = (Event)Mockito.mock(Event.class);
        ExecutionException executionExceptionMock = this.buildExecutionExceptionMock(new NullPointerException(), failureEvent);
        this.mockExecuteFailure(testFlow, executionExceptionMock);
        InternalEvent internalEventMock = (InternalEvent)Mockito.mock(InternalEvent.class);
        Mockito.when((Object)internalEventMock.getError()).thenReturn(Optional.empty());
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlow)).run((Event)internalEventMock);
        Event eventResult = testFlow.run((Event)internalEventMock);
        MatcherAssert.assertThat((Object)eventResult, (Matcher)Is.is((Object)failureEvent));
    }

    @Test(expected=AssertionError.class)
    public void failureIsNotExpectedAndCauseIsAssertionErrorItShouldFail() throws Throwable {
        InternalEvent eventMock = (InternalEvent)Mockito.mock(InternalEvent.class);
        Event resultEventMock = (Event)Mockito.mock(Event.class);
        Mockito.when((Object)resultEventMock.getError()).thenReturn(Optional.empty());
        TestFlow testFlowMock = (TestFlow)Mockito.mock(TestFlow.class);
        Mockito.when((Object)testFlowMock.isExpectingFailure()).thenReturn((Object)false);
        Event failureEventMock = (Event)Mockito.mock(Event.class);
        ExecutionException executionExceptionMock = this.buildExecutionExceptionMock((Throwable)((Object)new AssertionError()), failureEventMock);
        this.mockExecuteFailure(testFlowMock, executionExceptionMock);
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlowMock)).run((Event)eventMock);
        testFlowMock.run((Event)eventMock);
    }

    @Test(expected=AssertionError.class)
    public void failureIsExpectedAndDoesNotMatchesCauseItShouldFail() throws Throwable {
        TestFlow testFlow = (TestFlow)Mockito.mock(TestFlow.class);
        Mockito.when((Object)testFlow.isExpectingFailure()).thenReturn((Object)true);
        ((TestFlow)Mockito.doThrow((Throwable)((Object)new AssertionError())).when((Object)testFlow)).validateExpected((Error)Matchers.any(), (Event)Matchers.any());
        Event failureEvent = (Event)Mockito.mock(Event.class);
        ExecutionException executionExceptionMock = this.buildExecutionExceptionMock(new IllegalArgumentException(), failureEvent);
        this.mockExecuteFailure(testFlow, executionExceptionMock);
        Event eventMock = (Event)Mockito.mock(Event.class);
        Mockito.when((Object)eventMock.getError()).thenReturn(Optional.empty());
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlow)).run(eventMock);
        testFlow.run(eventMock);
    }

    @Test(expected=ExecutionException.class)
    public void failureIsNotExpectedAndCauseIsNotAssertionErrorItShouldFail() throws Throwable {
        TestFlow testFlow = (TestFlow)Mockito.mock(TestFlow.class);
        Mockito.when((Object)testFlow.isExpectingFailure()).thenReturn((Object)false);
        Event failureEvent = (Event)Mockito.mock(Event.class);
        ExecutionException executionExceptionMock = this.buildExecutionExceptionMock(new IllegalArgumentException(), failureEvent);
        this.mockExecuteFailure(testFlow, executionExceptionMock);
        InternalEvent internalEventMock = (InternalEvent)Mockito.mock(InternalEvent.class);
        Mockito.when((Object)internalEventMock.getError()).thenReturn(Optional.empty());
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlow)).run((Event)internalEventMock);
        testFlow.run((Event)internalEventMock);
    }

    @Test(expected=ExecutionException.class)
    public void errorIsThrownIfCauseNotComponentExecutionException() throws Throwable {
        TestFlow testFlow = (TestFlow)Mockito.mock(TestFlow.class);
        ExecutionException executionExceptionMock = (ExecutionException)Mockito.mock(ExecutionException.class);
        StackTraceElement stackTraceElementMock = new StackTraceElement("FakeClass", "fakeMethod", "FakeClass.java", -1);
        StackTraceElement[] stackTraceElements = new StackTraceElement[]{stackTraceElementMock};
        Mockito.when((Object)executionExceptionMock.getStackTrace()).thenReturn((Object)stackTraceElements);
        this.mockExecuteFailure(testFlow, executionExceptionMock);
        InternalEvent internalEventMock = (InternalEvent)Mockito.mock(InternalEvent.class);
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlow)).run((Event)internalEventMock);
        testFlow.run((Event)internalEventMock);
    }

    @Test
    public void getTagsAsSet() {
        String tag1 = "tag1";
        String tag2 = "tag2";
        TestFlow testFlow = new TestFlow();
        testFlow.setTags("tag1,tag2");
        MatcherAssert.assertThat(new HashSet<String>(Arrays.asList(tag1, tag2)), (Matcher)Is.is((Object)testFlow.getTags()));
    }

    @Test
    public void nullTagsReturnEmptySet() {
        TestFlow testFlow = new TestFlow();
        testFlow.setTags(null);
        MatcherAssert.assertThat(Collections.emptySet(), (Matcher)Is.is((Object)testFlow.getTags()));
    }

    @Test
    public void blankTagsReturnEmptySet() {
        TestFlow testFlow = new TestFlow();
        testFlow.setTags(" ");
        MatcherAssert.assertThat(Collections.emptySet(), (Matcher)Is.is((Object)testFlow.getTags()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidTag() {
        TestFlow testFlow = new TestFlow();
        testFlow.setTags("NO_TAG");
        testFlow.getTags();
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidTagWithLeadingAndTrailingSpaces() {
        TestFlow testFlow = new TestFlow();
        testFlow.setTags(" NO_TAG ");
        testFlow.getTags();
    }

    @Test
    public void startFlowSources() throws Exception {
        EnableFlowSources.FlowRef flow1 = this.flowRef((Component)this.flow("flow1"));
        EnableFlowSources.FlowRef flow2 = this.flowRef((Component)this.flow("flow2"));
        EnableFlowSources.FlowRef notFlow = this.flowRef(this.component("notFlow"));
        List<EnableFlowSources.FlowRef> enabledFlows = Arrays.asList(flow1, flow2, notFlow);
        TestFlow testFlow = new TestFlow();
        testFlow.setIgnore("false");
        testFlow.munitModule = Optional.of(this.munitModuleMock);
        testFlow.setEnableFlowSources(enabledFlows);
        testFlow.startFlowSources();
        LifecycleSource flow1Source = (LifecycleSource)((Flow)flow1.getFlow()).getSource();
        LifecycleSource flow2Source = (LifecycleSource)((Flow)flow2.getFlow()).getSource();
        ((LifecycleSource)Mockito.verify((Object)flow1Source)).start();
        ((LifecycleSource)Mockito.verify((Object)flow2Source)).start();
    }

    @Test
    public void stopFlowSources() throws Exception {
        EnableFlowSources.FlowRef flow1 = this.flowRef((Component)this.flow("flow1"));
        EnableFlowSources.FlowRef flow2 = this.flowRef((Component)this.flow("flow2"));
        EnableFlowSources.FlowRef notFlow = this.flowRef(this.component("notFlow"));
        List<EnableFlowSources.FlowRef> enabledFlows = Arrays.asList(flow1, flow2, notFlow);
        TestFlow testFlow = new TestFlow();
        testFlow.setIgnore("false");
        testFlow.munitModule = Optional.of(this.munitModuleMock);
        testFlow.setEnableFlowSources(enabledFlows);
        testFlow.stopFlowSources();
        LifecycleSource flow1Source = (LifecycleSource)((Flow)flow1.getFlow()).getSource();
        LifecycleSource flow2Source = (LifecycleSource)((Flow)flow2.getFlow()).getSource();
        ((LifecycleSource)Mockito.verify((Object)flow1Source)).stop();
        ((LifecycleSource)Mockito.verify((Object)flow2Source)).stop();
    }

    @Test(expected=MunitError.class)
    public void failureToStartFlowSources() throws Exception {
        EnableFlowSources.FlowRef flow1 = this.flowRef((Component)this.flow("flow1"));
        LifecycleSource flow1Source = (LifecycleSource)((Flow)flow1.getFlow()).getSource();
        List<EnableFlowSources.FlowRef> enabledFlows = Collections.singletonList(flow1);
        StartException startException = new StartException((Throwable)new RuntimeException(), (Startable)flow1Source);
        ((LifecycleSource)Mockito.doThrow((Throwable)startException).when((Object)flow1Source)).start();
        TestFlow testFlow = new TestFlow();
        testFlow.munitModule = Optional.of(this.munitModuleMock);
        testFlow.setEnableFlowSources(enabledFlows);
        testFlow.startFlowSources();
    }

    @Test(expected=MunitError.class)
    public void failureToStopFlowSources() throws Exception {
        EnableFlowSources.FlowRef flow1 = this.flowRef((Component)this.flow("flow1"));
        LifecycleSource flow1Source = (LifecycleSource)((Flow)flow1.getFlow()).getSource();
        List<EnableFlowSources.FlowRef> enabledFlows = Collections.singletonList(flow1);
        StopException stopException = new StopException((Throwable)new RuntimeException(), (Stoppable)flow1Source);
        ((LifecycleSource)Mockito.doThrow((Throwable)stopException).when((Object)flow1Source)).stop();
        TestFlow testFlow = new TestFlow();
        testFlow.munitModule = Optional.of(this.munitModuleMock);
        testFlow.setEnableFlowSources(enabledFlows);
        testFlow.stopFlowSources();
    }

    @Test
    public void timeoutOnTest() throws Throwable {
        this.expectException.expectMessage("The test 'TestToTimeout' timeout after 120000 milliseconds");
        this.testTimeout(null);
    }

    @Test
    public void timeoutOnTestUsingSystemProperty() throws Throwable {
        System.setProperty("munit.test.timeout", "10000");
        try {
            this.expectException.expectMessage("The test 'TestToTimeout' timeout after 10000 milliseconds");
            this.testTimeout(null);
        }
        finally {
            System.clearProperty("munit.test.timeout");
        }
    }

    @Test
    public void timeoutOnTestUsingAttribute() throws Throwable {
        this.expectException.expectMessage("The test 'TestToTimeout' timeout after 50000 milliseconds");
        this.testTimeout(50000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void timeoutOnTestUsingSystemPropertyAndAttributeMustPrioritizeAttribute() throws Throwable {
        Integer attributeValue = 20000;
        String propertyValue = "10000";
        String expectedExceptionMessage = String.format("The test 'TestToTimeout' timeout after %s milliseconds", attributeValue);
        System.setProperty("munit.test.timeout", propertyValue);
        try {
            this.expectException.expectMessage(expectedExceptionMessage);
            this.testTimeout(attributeValue);
        }
        finally {
            System.clearProperty("munit.test.timeout");
        }
    }

    @Test
    public void runSuccessTestFlow() throws Throwable {
        Event resultEventMock = (Event)Mockito.mock(Event.class);
        InternalEvent eventMock = (InternalEvent)Mockito.mock(InternalEvent.class);
        Mockito.when((Object)resultEventMock.getError()).thenReturn(Optional.empty());
        Scheduler scheduler = (Scheduler)Mockito.mock(Scheduler.class);
        TestFlow testFlowMock = this.mockTestFlow(scheduler);
        Future futureMock = (Future)Mockito.mock(Future.class);
        Mockito.when(futureMock.get(Matchers.anyInt(), (TimeUnit)((Object)Matchers.any()))).thenReturn((Object)Either.left((Object)resultEventMock));
        Mockito.when((Object)scheduler.submit((Callable)Matchers.any(Callable.class))).thenReturn((Object)futureMock);
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlowMock)).run((Event)eventMock);
        Event afterTestEvent = testFlowMock.run((Event)eventMock);
        MatcherAssert.assertThat((Object)resultEventMock, (Matcher)Is.is((Object)afterTestEvent));
    }

    @Test
    public void unknownErrorExecutingTest() throws Throwable {
        this.expectException.expectMessage("Unknown error occurred executing the test");
        Event resultEventMock = (Event)Mockito.mock(Event.class);
        InternalEvent eventMock = (InternalEvent)Mockito.mock(InternalEvent.class);
        Mockito.when((Object)resultEventMock.getError()).thenReturn(Optional.empty());
        ExecutionResult executionResult = (ExecutionResult)Mockito.mock(ExecutionResult.class);
        Mockito.when((Object)executionResult.getEvent()).thenReturn((Object)resultEventMock);
        Scheduler scheduler = (Scheduler)Mockito.mock(Scheduler.class);
        TestFlow testFlow = this.mockTestFlow(scheduler);
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlow)).run((Event)eventMock);
        Mockito.when((Object)scheduler.submit((Callable)Matchers.any(Callable.class))).then(invocationOnMock -> {
            ((Callable)invocationOnMock.getArgumentAt(0, Callable.class)).call();
            Future mock = (Future)Mockito.mock(Future.class);
            Mockito.when(mock.get(Matchers.anyInt(), (TimeUnit)((Object)((Object)Matchers.any())))).thenReturn((Object)Either.right((Object)Mockito.mock(RuntimeException.class)));
            return mock;
        });
        testFlow.initialise();
        testFlow.run((Event)eventMock);
    }

    @Test
    public void exceptionMessageMatchesExpectedExceptionMessage() {
        this.mockEvaluateIfExpression(EXPECTED_ERROR_MESSAGE, false, null);
        TestFlow testFlow = new TestFlow();
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        testFlow.setExpectedErrorDescription(EXPECTED_ERROR_MESSAGE);
        MatcherAssert.assertThat((Object)testFlow.validateExpected(this.error(new Exception(), EXPECTED_ERROR_MESSAGE), (Event)this.eventMock).isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void exceptionMessageContainsExpectedExceptionMessage() {
        this.mockEvaluateIfExpression(EXPECTED_ERROR_MESSAGE, false, null);
        TestFlow testFlow = new TestFlow();
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        testFlow.setExpectedErrorDescription("was thrown");
        MatcherAssert.assertThat((Object)testFlow.validateExpected(this.error(new Exception(), EXPECTED_ERROR_MESSAGE), (Event)this.eventMock).isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void exceptionMessageDoesNotMatchExpectedExceptionMessage() {
        this.mockEvaluateIfExpression(EXPECTED_ERROR_MESSAGE, false, null);
        TestFlow testFlow = new TestFlow();
        testFlow.setErrorTypeRepository(this.errorTypeRepositoryMock);
        testFlow.setExtendedExpressionManager(this.expressionManagerMock);
        testFlow.setExpectedErrorDescription(EXPECTED_ERROR_MESSAGE);
        MatcherAssert.assertThat((Object)testFlow.validateExpected(this.error(new Exception(), ""), (Event)this.eventMock).isPresent(), (Matcher)Is.is((Object)true));
    }

    private EnableFlowSources.FlowRef flowRef(Component flow) {
        EnableFlowSources.FlowRef flowRefMock = (EnableFlowSources.FlowRef)Mockito.mock(EnableFlowSources.FlowRef.class);
        Mockito.when((Object)flowRefMock.getFlow()).thenReturn((Object)flow);
        return flowRefMock;
    }

    private Flow flow(String flowName) {
        Flow flowMock = (Flow)Mockito.mock(Flow.class);
        LifecycleSource messageSourceMock = (LifecycleSource)Mockito.mock(LifecycleSource.class);
        Location locationMock = (Location)Mockito.mock(Location.class);
        Mockito.when((Object)locationMock.getGlobalName()).thenReturn((Object)flowName);
        Mockito.when((Object)flowMock.getRootContainerLocation()).thenReturn((Object)locationMock);
        Mockito.when((Object)flowMock.getSource()).thenReturn((Object)messageSourceMock);
        return flowMock;
    }

    private Component component(String flowName) {
        Component componentMock = (Component)Mockito.mock(Component.class);
        Location locationMock = (Location)Mockito.mock(Location.class);
        Mockito.when((Object)locationMock.getGlobalName()).thenReturn((Object)flowName);
        Mockito.when((Object)componentMock.getRootContainerLocation()).thenReturn((Object)locationMock);
        return componentMock;
    }

    private void mockEvaluateIfExpression(String exp, boolean isValidExpression, Object expResult) {
        this.mockIsExpressionValid(exp, isValidExpression);
        ValidationResult validationResultMock = this.validationResult(isValidExpression, "");
        Mockito.when((Object)this.expressionManagerMock.validate(exp)).thenReturn((Object)validationResultMock);
        if (isValidExpression) {
            TypedValue expressionResultMock = this.expressionResult(expResult);
            Mockito.when((Object)this.expressionManagerMock.evaluate((String)Matchers.eq((Object)exp), (CoreEvent)Matchers.any(InternalEvent.class))).thenReturn((Object)expressionResultMock);
        }
    }

    private void mockIsExpressionValid(String exp, Boolean result) {
        Mockito.when((Object)this.expressionManagerMock.isExpression(exp)).thenReturn((Object)result);
        Mockito.when((Object)this.expressionManagerMock.isValid(exp)).thenReturn((Object)result);
    }

    private TypedValue expressionResult(Object value) {
        return new TypedValue(value, DataType.fromObject((Object)value));
    }

    private ValidationResult validationResult(Boolean success, String error) {
        ValidationResult validationResultMock = (ValidationResult)Mockito.mock(ValidationResult.class);
        Mockito.when((Object)validationResultMock.isSuccess()).thenReturn((Object)success);
        Mockito.when((Object)validationResultMock.errorMessage()).thenReturn(Optional.of(error));
        return validationResultMock;
    }

    private ExecutionException buildExecutionExceptionMock(Throwable failureCause, Event failureEvent) {
        ComponentExecutionException componentExecutionException = new ComponentExecutionException((Throwable)new NullPointerException(), failureEvent);
        ExecutionException failureMock = (ExecutionException)Mockito.mock(ExecutionException.class);
        Mockito.when((Object)failureMock.getCause()).thenReturn((Object)componentExecutionException);
        StackTraceElement stackTraceElementMock = new StackTraceElement("FakeClass", "fakeMethod", "FakeClass.java", -1);
        StackTraceElement[] stackTraceElements = new StackTraceElement[]{stackTraceElementMock};
        Mockito.when((Object)failureMock.getStackTrace()).thenReturn((Object)stackTraceElements);
        Error error = this.error(failureCause);
        Mockito.when((Object)failureEvent.getError()).thenReturn(Optional.of(error));
        return failureMock;
    }

    private void mockExecuteFailure(TestFlow testFlowMock, ExecutionException executionException) throws ExecutionException, InterruptedException {
        Mockito.when((Object)testFlowMock.doExecute((Event)Matchers.any(Event.class))).thenThrow(new Throwable[]{executionException});
    }

    private TestFlow mockTestFlow(Scheduler schedulerMock) throws Throwable {
        TestFlow testFlowMock = (TestFlow)Mockito.mock(TestFlow.class);
        Mockito.when((Object)testFlowMock.isExpectingFailure()).thenReturn((Object)false);
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlowMock)).doExecute((Event)Matchers.any());
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlowMock)).setSchedulerService((SchedulerService)Matchers.any());
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlowMock)).initialise();
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlowMock)).dispose();
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlowMock)).setProcessorChains(Matchers.anyList());
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlowMock)).setMuleContext((MuleContext)this.muleContextMock);
        testFlowMock.setProcessorChains(Collections.emptyList());
        testFlowMock.setMuleContext((MuleContext)this.muleContextMock);
        SchedulerService mock = (SchedulerService)Mockito.mock(SchedulerService.class);
        Mockito.when((Object)mock.cpuLightScheduler((SchedulerConfig)Matchers.any())).thenReturn((Object)schedulerMock);
        testFlowMock.setSchedulerService(mock);
        testFlowMock.initialise();
        return testFlowMock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testTimeout(Integer timeout) throws Throwable {
        Event resultEventMock = (Event)Mockito.mock(Event.class);
        InternalEvent eventMock = (InternalEvent)Mockito.mock(InternalEvent.class);
        Mockito.when((Object)resultEventMock.getError()).thenReturn(Optional.empty());
        Scheduler scheduler = (Scheduler)Mockito.mock(Scheduler.class);
        TestFlow testFlowMock = this.mockTestFlow(scheduler);
        Mockito.when((Object)testFlowMock.getName()).thenReturn((Object)"TestToTimeout");
        Future mock1 = (Future)Mockito.mock(Future.class);
        Mockito.when(mock1.get(Matchers.anyInt(), (TimeUnit)((Object)Matchers.any()))).thenThrow(new Throwable[]{new TimeoutException()});
        Mockito.when((Object)scheduler.submit((Callable)Matchers.any(Callable.class))).thenReturn((Object)mock1);
        testFlowMock.initialise();
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlowMock)).setTimeOut(timeout);
        ((TestFlow)Mockito.doCallRealMethod().when((Object)testFlowMock)).run((Event)eventMock);
        if (timeout != null) {
            testFlowMock.setTimeOut(timeout);
        }
        try {
            testFlowMock.run((Event)eventMock);
        }
        finally {
            testFlowMock.dispose();
        }
    }

    private Error error(Throwable cause, String description) {
        Error errorMock = this.error(cause);
        Mockito.when((Object)errorMock.getDescription()).thenReturn((Object)description);
        return errorMock;
    }

    private Error error(Throwable cause) {
        Error errorMock = (Error)Mockito.mock(Error.class);
        Mockito.when((Object)errorMock.getCause()).thenReturn((Object)cause);
        return errorMock;
    }

    private static interface LifecycleSource
    extends MessageSource,
    Lifecycle {
    }

    private static class SpecificNullPointerException
    extends NullPointerException {
        private SpecificNullPointerException() {
        }
    }
}

