/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.remote.api.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.protocol.listeners.RunEventListener;
import org.mule.munit.common.protocol.listeners.RunEventListenerContainer;
import org.mule.munit.common.protocol.listeners.SuiteRunEventListener;
import org.mule.munit.common.protocol.message.RunMessage;
import org.mule.munit.common.util.StackTraceUtil;
import org.mule.munit.runner.SuiteRunner;
import org.mule.munit.runner.config.TestComponentLocator;
import org.mule.munit.runner.model.Suite;
import org.mule.munit.runner.model.builders.SuiteBuilder;
import org.mule.munit.runner.remote.api.notifiers.ObjectOutputNotifier;
import org.mule.munit.runner.remote.api.notifiers.StreamNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunMessageHandler {
    private transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private ObjectInput in;
    private ObjectOutput out;
    private TestComponentLocator testComponentLocator;

    public RunMessageHandler(ObjectInput in, ObjectOutput out, TestComponentLocator testComponentLocator) {
        this.testComponentLocator = testComponentLocator;
        this.in = in;
        this.out = out;
    }

    public void handle() throws IOException, ClassNotFoundException {
        String message = (String)this.in.readObject();
        RunMessage runMessage = (RunMessage)new Gson().fromJson(message, RunMessage.class);
        SuiteRunEventListener listener = this.buildListenerContainer(runMessage.get("runToken"));
        if (0 == runMessage.getId()) {
            this.parseAndRun(runMessage, listener);
        }
    }

    protected void parseAndRun(RunMessage runMessage, SuiteRunEventListener listener) {
        try {
            Suite suite = this.parseSuiteMessage(runMessage, listener);
            this.runSuite(suite, listener);
        }
        catch (Throwable e) {
            e.printStackTrace();
            listener.notifySuiteUnexpectedError(this.getSuitePath(runMessage), StackTraceUtil.getStackTrace((Throwable)e));
        }
    }

    private Suite parseSuiteMessage(RunMessage runMessage, SuiteRunEventListener listener) {
        String suitePath = this.getSuitePath(runMessage);
        String parameterization = this.getParameterization(runMessage);
        List<String> testNames = this.getTestNames(runMessage);
        Set<String> tags = this.getTags(runMessage);
        return this.buildSuite(suitePath, parameterization, testNames, tags, listener);
    }

    protected void runSuite(Suite suite, SuiteRunEventListener listener) {
        SuiteRunner runner = new SuiteRunner(suite, listener);
        runner.run();
    }

    protected Suite buildSuite(String suitePath, String parameterization, List<String> testNames, Set<String> tags, SuiteRunEventListener listener) {
        SuiteBuilder suiteBuilder = new SuiteBuilder(suitePath, parameterization, this.testComponentLocator).withTestNames(testNames).withTags(tags).withSuiteRunnerEventListener(listener);
        return suiteBuilder.build();
    }

    private String getSuitePath(RunMessage runMessage) {
        return runMessage.get("munitSuite");
    }

    private String getParameterization(RunMessage runMessage) {
        return Optional.ofNullable(runMessage.get("parameterizationKey")).orElse("");
    }

    private SuiteRunEventListener buildListenerContainer(String runToken) {
        RunEventListenerContainer listenerDecorator = new RunEventListenerContainer();
        listenerDecorator.addNotificationListener((RunEventListener)new ObjectOutputNotifier(runToken, this.out));
        listenerDecorator.addNotificationListener((RunEventListener)new StreamNotifier(System.out));
        return listenerDecorator;
    }

    private List<String> getTestNames(RunMessage runMessage) {
        String testNames = runMessage.get("testNames");
        if (StringUtils.isBlank((CharSequence)testNames)) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])testNames.split(","));
    }

    private Set<String> getTags(RunMessage runMessage) {
        String tags = runMessage.get("tags");
        if (StringUtils.isBlank((CharSequence)tags)) {
            return Collections.emptySet();
        }
        return Sets.newHashSet((Object[])tags.split(","));
    }
}

