/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.component.properties;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.munit.runner.component.properties.DynamicPortPropertiesProvider;
import org.mule.munit.runner.component.properties.DynamicPortPropertiesProviderFactory;
import org.mule.runtime.config.api.dsl.model.ConfigurationParameters;

public class DynamicPortPropertiesProviderFactoryTest {
    private DynamicPortPropertiesProviderFactory dynamicPortPropertiesProviderFactory;

    @Test
    public void getPropertiesProvider() {
        this.dynamicPortPropertiesProviderFactory = new DynamicPortPropertiesProviderFactory();
        ConfigurationParameters parametersMock = (ConfigurationParameters)Mockito.mock(ConfigurationParameters.class);
        Mockito.when((Object)parametersMock.getStringParameter("propertyName")).thenReturn((Object)"a.port");
        MatcherAssert.assertThat((Object)this.dynamicPortPropertiesProviderFactory.createProvider(parametersMock, null), (Matcher)Matchers.instanceOf(DynamicPortPropertiesProvider.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void illegalArgumentWhenParameterIsNotInteger() {
        this.dynamicPortPropertiesProviderFactory = new DynamicPortPropertiesProviderFactory();
        ConfigurationParameters parametersMock = (ConfigurationParameters)Mockito.mock(ConfigurationParameters.class);
        Mockito.when((Object)parametersMock.getStringParameter("propertyName")).thenReturn((Object)"a.port");
        Mockito.when((Object)parametersMock.getStringParameter("min")).thenReturn((Object)"not.a.number");
        MatcherAssert.assertThat((Object)this.dynamicPortPropertiesProviderFactory.createProvider(parametersMock, null), (Matcher)Matchers.instanceOf(DynamicPortPropertiesProvider.class));
    }
}

