/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.remote.api.server;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.munit.common.protocol.listeners.SuiteRunEventListener;
import org.mule.munit.common.protocol.message.RunMessage;
import org.mule.munit.common.util.StackTraceUtil;
import org.mule.munit.runner.config.TestComponentLocator;
import org.mule.munit.runner.model.Suite;
import org.mule.munit.runner.remote.api.server.RunMessageHandler;

public class RunMessageHandlerTest {
    private static final String SUITE_PATH = "example-suite.xml";
    private static final String SUITE_PARAMETERIZATION = "param1";
    private static final String RUN_TOKEN = "OA815";
    private ObjectInput inMock;
    private ObjectOutput outMock;
    private List<String> testNames;
    private Set<String> tags;
    private Suite suiteMock;
    private SuiteRunEventListener listenerMock;
    private RunMessageHandler runMessageHandler;
    private Gson gson = new Gson();

    @Before
    public void setUp() throws IOException {
        this.inMock = (ObjectInput)Mockito.mock(ObjectInput.class);
        this.outMock = (ObjectOutput)Mockito.mock(ObjectOutput.class);
        this.testNames = Collections.emptyList();
        this.tags = Collections.emptySet();
        this.suiteMock = (Suite)Mockito.mock(Suite.class);
        this.listenerMock = (SuiteRunEventListener)Mockito.mock(SuiteRunEventListener.class);
        TestComponentLocator componentLocator = (TestComponentLocator)Mockito.mock(TestComponentLocator.class);
        this.runMessageHandler = (RunMessageHandler)Mockito.spy((Object)new RunMessageHandler(this.inMock, this.outMock, componentLocator));
        ((RunMessageHandler)Mockito.doNothing().when((Object)this.runMessageHandler)).runSuite((Suite)Matchers.eq((Object)this.suiteMock), (SuiteRunEventListener)Matchers.any(SuiteRunEventListener.class));
        ((RunMessageHandler)Mockito.doReturn((Object)this.suiteMock).when((Object)this.runMessageHandler)).buildSuite((String)Matchers.eq((Object)SUITE_PATH), (String)Matchers.eq((Object)SUITE_PARAMETERIZATION), Matchers.anyListOf(String.class), Matchers.anySetOf(String.class), (SuiteRunEventListener)Matchers.any(SuiteRunEventListener.class));
    }

    @Test
    public void simpleSuiteRun() throws ClassNotFoundException, IOException {
        String suiteRunMessage = this.gson.toJson((Object)this.createSuiteRunMessage());
        Mockito.when((Object)this.inMock.readObject()).thenReturn((Object)suiteRunMessage);
        this.runMessageHandler.handle();
        ((RunMessageHandler)Mockito.verify((Object)this.runMessageHandler)).buildSuite((String)Matchers.eq((Object)SUITE_PATH), (String)Matchers.eq((Object)SUITE_PARAMETERIZATION), (List)Matchers.eq(this.testNames), (Set)Matchers.eq(this.tags), (SuiteRunEventListener)Matchers.any(SuiteRunEventListener.class));
    }

    @Test
    public void suiteWithTestNames() throws ClassNotFoundException, IOException {
        this.testNames = Arrays.asList("firstTest", "secondTest");
        String suiteRunMessage = this.gson.toJson((Object)this.createSuiteRunMessage());
        Mockito.when((Object)this.inMock.readObject()).thenReturn((Object)suiteRunMessage);
        this.runMessageHandler.handle();
        ((RunMessageHandler)Mockito.verify((Object)this.runMessageHandler)).buildSuite((String)Matchers.eq((Object)SUITE_PATH), (String)Matchers.eq((Object)SUITE_PARAMETERIZATION), (List)Matchers.eq(this.testNames), (Set)Matchers.eq(this.tags), (SuiteRunEventListener)Matchers.any(SuiteRunEventListener.class));
    }

    @Test
    public void suiteWithTags() throws ClassNotFoundException, IOException {
        this.tags = Sets.newHashSet((Object[])new String[]{"firstTag", "secondTag"});
        String suiteRunMessage = this.gson.toJson((Object)this.createSuiteRunMessage());
        Mockito.when((Object)this.inMock.readObject()).thenReturn((Object)suiteRunMessage);
        this.runMessageHandler.handle();
        ((RunMessageHandler)Mockito.verify((Object)this.runMessageHandler)).buildSuite((String)Matchers.eq((Object)SUITE_PATH), (String)Matchers.eq((Object)SUITE_PARAMETERIZATION), (List)Matchers.eq(this.testNames), (Set)Matchers.eq(this.tags), (SuiteRunEventListener)Matchers.any(SuiteRunEventListener.class));
    }

    @Test
    public void suiteRunFailureNotifiesUnexpectedError() throws ClassNotFoundException, IOException {
        RunMessage runMessage = this.createSuiteRunMessage();
        IllegalStateException toBeThrown = new IllegalStateException("Test Exception");
        ((RunMessageHandler)Mockito.doThrow((Throwable)toBeThrown).when((Object)this.runMessageHandler)).runSuite(this.suiteMock, this.listenerMock);
        this.runMessageHandler.parseAndRun(runMessage, this.listenerMock);
        ((SuiteRunEventListener)Mockito.verify((Object)this.listenerMock)).notifySuiteUnexpectedError(SUITE_PATH, StackTraceUtil.getStackTrace((Throwable)toBeThrown));
    }

    private RunMessage createSuiteRunMessage() {
        return new RunMessage(Integer.valueOf(0), (Map)ImmutableMap.of((Object)"runToken", (Object)RUN_TOKEN, (Object)"munitSuite", (Object)SUITE_PATH, (Object)"parameterizationKey", (Object)SUITE_PARAMETERIZATION, (Object)"testNames", (Object)this.collectionToString(this.testNames), (Object)"tags", (Object)this.collectionToString(this.tags)));
    }

    private String collectionToString(Collection<String> collection) {
        return collection == null ? "" : collection.stream().collect(Collectors.joining(","));
    }
}

