/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.component.rules;

import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.munit.runner.component.rules.TemporaryStorageRule;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.api.store.SimpleMemoryObjectStore;

public class TemporaryStorageRuleTest {
    private static final String MY_KEY = "myKey";
    private static final int MY_VALUE = 1;
    private TemporaryStorageRule temporaryStorageRule;

    @Before
    public void setUp() {
        ObjectStoreManager objectStoreManagerMock = (ObjectStoreManager)Mockito.mock(ObjectStoreManager.class);
        LockFactory lockFactoryMock = (LockFactory)Mockito.mock(LockFactory.class);
        Lock lockMock = (Lock)Mockito.mock(Lock.class);
        this.temporaryStorageRule = new TemporaryStorageRule();
        this.temporaryStorageRule.objectStoreManager = objectStoreManagerMock;
        this.temporaryStorageRule.lockFactory = lockFactoryMock;
        Mockito.when((Object)objectStoreManagerMock.getOrCreateObjectStore(Matchers.anyString(), (ObjectStoreSettings)Matchers.any(ObjectStoreSettings.class))).thenReturn((Object)new SimpleMemoryObjectStore());
        Mockito.when((Object)lockFactoryMock.createLock(Matchers.anyString())).thenReturn((Object)lockMock);
        this.temporaryStorageRule.initialise();
    }

    @Test
    public void storeAndRetrieve() {
        this.temporaryStorageRule.store(MY_KEY, (Serializable)Integer.valueOf(1));
        Optional retrieved = this.temporaryStorageRule.retrieve(MY_KEY);
        Assert.assertThat((Object)retrieved.isPresent(), (Matcher)org.hamcrest.Matchers.equalTo((Object)true));
        Assert.assertThat(retrieved.get(), (Matcher)org.hamcrest.Matchers.equalTo((Object)1));
    }

    @Test
    public void storeRemoveAndRetrieve() {
        this.temporaryStorageRule.store(MY_KEY, (Serializable)Integer.valueOf(1));
        Optional removed = this.temporaryStorageRule.remove(MY_KEY);
        Optional retrieved = this.temporaryStorageRule.retrieve(MY_KEY);
        Assert.assertThat((Object)removed.isPresent(), (Matcher)org.hamcrest.Matchers.equalTo((Object)true));
        Assert.assertThat(removed.get(), (Matcher)org.hamcrest.Matchers.equalTo((Object)1));
        Assert.assertThat((Object)retrieved.isPresent(), (Matcher)org.hamcrest.Matchers.equalTo((Object)false));
    }

    @Test
    public void storeClearAndRetrieve() {
        this.temporaryStorageRule.store(MY_KEY, (Serializable)Integer.valueOf(1));
        this.temporaryStorageRule.clear();
        Optional retrieved = this.temporaryStorageRule.retrieve(MY_KEY);
        Assert.assertThat((Object)retrieved.isPresent(), (Matcher)org.hamcrest.Matchers.equalTo((Object)false));
    }

    @Test
    public void resetClearsData() {
        this.temporaryStorageRule = (TemporaryStorageRule)Mockito.spy((Object)this.temporaryStorageRule);
        this.temporaryStorageRule.reset();
        ((TemporaryStorageRule)Mockito.verify((Object)this.temporaryStorageRule)).clear();
    }
}

