/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.model.builders;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.runner.component.TestComponent;

public class TestRunFilter {
    public static final String NO_TAG_TOKEN = "NO_TAG";

    public boolean shouldRunTest(TestComponent testComponent, List<String> testNameList, Set<String> tags) {
        return this.isTestInList(testComponent, testNameList) && this.isTagInTest(testComponent, tags);
    }

    private boolean isTestInList(TestComponent testComponent, List<String> testNameList) {
        if (null == testNameList || testNameList.isEmpty()) {
            return true;
        }
        return testNameList.stream().filter(StringUtils::isNotBlank).anyMatch(name -> testComponent.getName().matches((String)name));
    }

    private boolean isTagInTest(TestComponent testFlow, Set<String> tags) {
        return tags == null || tags.isEmpty() || this.shouldRunWithNoTag(testFlow, tags) || this.tagsInCommon(testFlow.getTags(), tags);
    }

    private boolean tagsInCommon(Set<String> testTags, Set<String> userTags) {
        return !Collections.disjoint(this.toLowerCaseAndTrim(testTags), this.toLowerCaseAndTrim(userTags));
    }

    private Set<String> toLowerCaseAndTrim(Set<String> tags) {
        return tags.stream().map(StringUtils::lowerCase).map(String::trim).collect(Collectors.toSet());
    }

    private boolean shouldRunWithNoTag(TestComponent testFlow, Set<String> tags) {
        return testFlow.getTags().isEmpty() && tags.stream().anyMatch(tag -> tag.trim().equalsIgnoreCase(NO_TAG_TOKEN));
    }
}

