/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.model.builders;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.protocol.listeners.SuiteRunEventListener;
import org.mule.munit.runner.component.TestComponent;
import org.mule.munit.runner.config.TestComponentLocator;
import org.mule.munit.runner.flow.AfterTest;
import org.mule.munit.runner.flow.BeforeTest;
import org.mule.munit.runner.model.Suite;
import org.mule.munit.runner.model.Test;
import org.mule.munit.runner.model.builders.TestRunFilter;
import org.mule.munit.runner.processors.MunitModule;
import org.mule.munit.runner.remote.api.notifiers.DummySuiteRunEventListener;

public class SuiteBuilder {
    protected String suitePath;
    private String parameterization;
    private TestComponentLocator testComponentLocator;
    protected Set<String> tags;
    protected List<String> testNames;
    protected SuiteRunEventListener suiteRunEventListener;

    public SuiteBuilder(String suitePath, String parameterization, TestComponentLocator testComponentLocator) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)suitePath), (Object)"The suitePath must not be null nor empty");
        Preconditions.checkNotNull((Object)testComponentLocator, (Object)"The test component locator must not be null");
        this.suitePath = suitePath;
        this.parameterization = parameterization;
        this.suiteRunEventListener = new DummySuiteRunEventListener();
        this.testComponentLocator = testComponentLocator;
    }

    public SuiteBuilder withTestNames(List<String> testNames) {
        this.testNames = testNames;
        return this;
    }

    public SuiteBuilder withTags(Set<String> tags) {
        this.tags = tags;
        return this;
    }

    public SuiteBuilder withSuiteRunnerEventListener(SuiteRunEventListener suiteRunEventListener) {
        Preconditions.checkNotNull((Object)suiteRunEventListener, (Object)"The suiteRunEventListener must not be null");
        this.suiteRunEventListener = suiteRunEventListener;
        return this;
    }

    public Suite build() {
        this.testComponentLocator.initializeComponents(this.suitePath);
        MunitModule munitModule = this.testComponentLocator.lookupMunitModule().orElseThrow(() -> new IllegalStateException("Missing element [munit:config] in file " + this.suitePath));
        Suite suite = new Suite(this.suitePath, this.parameterization);
        suite.setSuiteRunEventListener(this.suiteRunEventListener);
        suite.setBeforeSuite(this.testComponentLocator.lookupBeforeSuite().orElse(null));
        this.createTests(munitModule).forEach(suite::addTest);
        suite.setAfterSuite(this.testComponentLocator.lookupAfterSuite().orElse(null));
        return suite;
    }

    private List<Test> createTests(MunitModule munitModule) {
        BeforeTest before = this.testComponentLocator.lookupBeforeTest().orElse(null);
        Collection<TestComponent> testComponents = this.testComponentLocator.lookupTests();
        AfterTest after = this.testComponentLocator.lookupAfterTest().orElse(null);
        TestRunFilter filter = new TestRunFilter();
        return testComponents.stream().filter(testComponent -> filter.shouldRunTest((TestComponent)testComponent, this.testNames, this.tags)).map(testComponent -> this.test(before, (TestComponent)testComponent, after, munitModule)).collect(Collectors.toList());
    }

    protected Test test(BeforeTest beforeTest, TestComponent test, AfterTest afterTest, MunitModule munitModule) {
        return new Test(beforeTest, test, afterTest, munitModule);
    }
}

