/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.component.state;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.munit.runner.component.state.MunitComponentInitialStateManager;
import org.mule.munit.runner.processors.EnableFlowSources;
import org.mule.munit.runner.processors.MunitModule;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.component.location.LocationPart;

public class MunitComponentInitialStateManagerTest {
    private Registry registryMock;
    private MunitModule munitModuleMock;
    private EnableFlowSources enableFlowSourcesMock;
    private MunitComponentInitialStateManager manager;

    @Before
    public void setUp() {
        this.registryMock = (Registry)Mockito.mock(Registry.class);
        this.munitModuleMock = (MunitModule)Mockito.mock(MunitModule.class);
        this.enableFlowSourcesMock = (EnableFlowSources)Mockito.mock(EnableFlowSources.class);
        Mockito.when((Object)this.munitModuleMock.getEnableFlowSources()).thenReturn((Object)this.enableFlowSourcesMock);
        Mockito.when((Object)this.registryMock.lookupByType(MunitModule.class)).thenReturn(Optional.of(this.munitModuleMock));
        this.manager = new MunitComponentInitialStateManager();
        this.manager.registry = this.registryMock;
    }

    @Test
    public void noMunitModuleProvided() {
        Mockito.when((Object)this.registryMock.lookupByType(MunitModule.class)).thenReturn(Optional.empty());
        Component componentMock = (Component)Mockito.mock(Component.class);
        MatcherAssert.assertThat((String)"The message sources should not be started", (Object)this.manager.mustStartMessageSource(componentMock), (Matcher)Is.is((Object)false));
    }

    @Test
    public void disableFlowSourcesNoneShouldBeStarted() {
        this.setEnableSourcesOnStart();
        Boolean isDisableFlowSources = true;
        Mockito.when((Object)this.munitModuleMock.isDisableFlowSources()).thenReturn((Object)isDisableFlowSources);
        Component componentMock = (Component)Mockito.mock(Component.class);
        MatcherAssert.assertThat((String)"The message sources should not be started", (Object)this.manager.mustStartMessageSource(componentMock), (Matcher)Is.is((Object)false));
    }

    @Test
    public void enableFlowSourcesNoneExcludedAllMustBeStarted() {
        this.setEnableSourcesOnStart();
        Boolean isDisableFlowSources = false;
        Mockito.when((Object)this.munitModuleMock.isDisableFlowSources()).thenReturn((Object)isDisableFlowSources);
        Component componentMock = (Component)Mockito.mock(Component.class);
        MatcherAssert.assertThat((String)"The message source source should started", (Object)this.manager.mustStartMessageSource(componentMock), (Matcher)Is.is((Object)true));
    }

    @Test
    public void excludedDisableSourceNoMatchMustNotStart() {
        this.setEnableSourcesOnStart();
        String flowName = "aFlow";
        Boolean isDisableFlowSources = true;
        Mockito.when((Object)this.munitModuleMock.isDisableFlowSources()).thenReturn((Object)isDisableFlowSources);
        Component componentMock = this.getComponent(flowName);
        MatcherAssert.assertThat((String)"The message sources should not be started", (Object)this.manager.mustStartMessageSource(componentMock), (Matcher)Is.is((Object)false));
    }

    @Test
    public void excludedEnableSourceNoMatchMustStart() {
        this.setEnableSourcesOnStart();
        String flowName = "aFlow";
        Boolean isDisableFlowSources = false;
        Component componentMock = this.getComponent(flowName);
        EnableFlowSources.FlowRef flowRef = new EnableFlowSources.FlowRef();
        flowRef.setFlow(componentMock);
        Mockito.when((Object)this.munitModuleMock.isDisableFlowSources()).thenReturn((Object)isDisableFlowSources);
        Mockito.when((Object)this.enableFlowSourcesMock.getFlows()).thenReturn(Collections.singletonList(flowRef));
        MatcherAssert.assertThat((String)"The message sources should not be started", (Object)this.manager.mustStartMessageSource(componentMock), (Matcher)Is.is((Object)true));
    }

    @Test
    public void sourcesAreShutdownByDefault() {
        Component componentMock = this.getComponent("aFlow");
        MatcherAssert.assertThat((String)"The message sources should not be started", (Object)this.manager.mustStartMessageSource(componentMock), (Matcher)Is.is((Object)false));
    }

    @After
    public void tearDown() {
        System.clearProperty("munit.enable.sources.on.start");
        System.clearProperty("munit.disable.initial.state.manager");
    }

    private void setEnableSourcesOnStart() {
        System.setProperty("munit.enable.sources.on.start", "true");
    }

    private Component getComponent(String flowName) {
        Component componentMock = (Component)Mockito.mock(Component.class);
        Location locationRootMock = (Location)Mockito.mock(Location.class);
        ComponentLocation locationMock = (ComponentLocation)Mockito.mock(ComponentLocation.class);
        LocationPart locationPartMock = (LocationPart)Mockito.mock(LocationPart.class);
        Mockito.when((Object)locationPartMock.getPartPath()).thenReturn((Object)flowName);
        Mockito.when((Object)locationMock.getParts()).thenReturn(Arrays.asList(locationPartMock));
        Mockito.when((Object)componentMock.getLocation()).thenReturn((Object)locationMock);
        Mockito.when((Object)locationRootMock.getGlobalName()).thenReturn((Object)flowName);
        Mockito.when((Object)componentMock.getRootContainerLocation()).thenReturn((Object)locationRootMock);
        return componentMock;
    }
}

