/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.model;

import org.junit.Assert;
import org.junit.Test;
import org.mule.munit.common.protocol.message.TestStatus;
import org.mule.munit.runner.model.MockTestFactory;
import org.mule.munit.runner.model.TestResult;

public class TestResultTest {
    @Test
    public void ifHasErrorThenDoNotSucceed() {
        Assert.assertFalse((MockTestFactory.errorTest("test").getStatus() == TestStatus.SUCCESS ? 1 : 0) != 0);
    }

    @Test
    public void ifHasFailureThenDoNotSucceed() {
        Assert.assertFalse((MockTestFactory.failingTest("test").getStatus() == TestStatus.SUCCESS ? 1 : 0) != 0);
    }

    @Test
    public void ifNoFailureOrErrorSucceed() {
        Assert.assertTrue((MockTestFactory.succeedTest("test").getStatus() == TestStatus.SUCCESS ? 1 : 0) != 0);
    }

    @Test
    public void testGetName() {
        TestResult tr = MockTestFactory.errorTest("a_name");
        tr.setName("a_real_name");
        Assert.assertEquals((Object)"a_real_name", (Object)tr.getName());
    }

    @Test
    public void testIsSkiped() {
        TestResult tr = MockTestFactory.errorTest("a_name");
        tr.setSkipped();
        Assert.assertEquals((Object)TestStatus.IGNORED, (Object)tr.getStatus());
    }
}

